/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.impl.v1.requirement;

import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.plant.IAgriWeed;
import com.infinityraider.agricraft.api.v1.plant.IAgriWeedSpawnable;
import com.infinityraider.agricraft.api.v1.requirement.AgriSeason;
import com.infinityraider.agricraft.api.v1.requirement.IAgriGrowCondition;
import com.infinityraider.agricraft.api.v1.requirement.IAgriGrowthResponse;
import com.infinityraider.agricraft.api.v1.requirement.IAgriSoil;
import com.infinityraider.agricraft.api.v1.requirement.IDefaultGrowConditionFactory;
import com.infinityraider.agricraft.api.v1.requirement.RequirementType;
import com.infinityraider.agricraft.impl.v1.plant.NoWeed;
import com.infinityraider.agricraft.impl.v1.requirement.FactoryAbstract;
import com.infinityraider.agricraft.impl.v1.requirement.GrowConditionAmbient;
import com.infinityraider.agricraft.impl.v1.requirement.GrowConditionBase;
import com.infinityraider.agricraft.impl.v1.requirement.NoSoil;
import com.infinityraider.infinitylib.utility.WorldHelper;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.structure.Structure;

public class Factory
extends FactoryAbstract {
    private static final Factory INSTANCE = new Factory();

    public static IDefaultGrowConditionFactory getInstance() {
        return INSTANCE;
    }

    protected Factory() {
    }

    @Override
    public GrowConditionBase<IAgriSoil> soil(BiFunction<Integer, IAgriSoil, IAgriGrowthResponse> response, List<ITextComponent> tooltips) {
        return new GrowConditionBase<IAgriSoil>(RequirementType.SOIL, response, Functions.SOIL, Offsetters.SOIL, tooltips, 1, IAgriGrowCondition.CacheType.BLOCK_UPDATE);
    }

    @Override
    protected <P extends IAgriSoil.SoilProperty> GrowConditionBase<P> soilProperty(BiFunction<Integer, P, IAgriGrowthResponse> response, Function<IAgriSoil, P> mapper, P invalid, List<ITextComponent> tooltips) {
        return new GrowConditionBase<P>(RequirementType.SOIL, response, Functions.soilProperty(mapper), Offsetters.SOIL, tooltips, 1, IAgriGrowCondition.CacheType.BLOCK_UPDATE);
    }

    @Override
    public GrowConditionBase<Integer> light(BiFunction<Integer, Integer, IAgriGrowthResponse> response, List<ITextComponent> tooltips) {
        return new GrowConditionBase<Integer>(RequirementType.LIGHT, response, Functions.LIGHT, Offsetters.NONE, tooltips, 1, IAgriGrowCondition.CacheType.NONE);
    }

    @Override
    public GrowConditionBase<Integer> redstone(BiFunction<Integer, Integer, IAgriGrowthResponse> response, List<ITextComponent> tooltips) {
        return new GrowConditionBase<Integer>(RequirementType.REDSTONE, response, Functions.REDSTONE, Offsetters.SOIL, tooltips, 1, IAgriGrowCondition.CacheType.BLOCK_UPDATE);
    }

    @Override
    public GrowConditionBase<Fluid> fluid(BiFunction<Integer, Fluid, IAgriGrowthResponse> response, List<ITextComponent> tooltips) {
        return new GrowConditionBase<Fluid>(RequirementType.LIQUID, response, Functions.FLUID, Offsetters.NONE, tooltips, 1, IAgriGrowCondition.CacheType.BLOCK_UPDATE);
    }

    @Override
    public GrowConditionBase<Biome> biome(BiFunction<Integer, Biome, IAgriGrowthResponse> response, List<ITextComponent> tooltips) {
        return new GrowConditionBase<Biome>(RequirementType.BIOME, response, Functions.BIOME, Offsetters.NONE, tooltips, 1, IAgriGrowCondition.CacheType.FULL);
    }

    @Override
    public GrowConditionBase<RegistryKey<World>> dimensionFromKey(BiFunction<Integer, RegistryKey<World>, IAgriGrowthResponse> response, List<ITextComponent> tooltips) {
        return new GrowConditionAmbient<RegistryKey<World>>(RequirementType.DIMENSION, response, Functions.DIMENSION_KEY, tooltips, IAgriGrowCondition.CacheType.FULL);
    }

    @Override
    public GrowConditionBase<DimensionType> dimensionFromType(BiFunction<Integer, DimensionType, IAgriGrowthResponse> response, List<ITextComponent> tooltips) {
        return new GrowConditionAmbient<DimensionType>(RequirementType.DIMENSION, response, Functions.DIMENSION_TYPE, tooltips, IAgriGrowCondition.CacheType.FULL);
    }

    @Override
    public GrowConditionBase<IAgriWeed> weed(BiFunction<Integer, IAgriWeed, IAgriGrowthResponse> response, List<ITextComponent> tooltips) {
        return new GrowConditionBase<IAgriWeed>(RequirementType.WEEDS, response, Functions.CROP.andThen(opt -> opt.map(IAgriWeedSpawnable::getWeeds).orElse(NoWeed.getInstance())), Offsetters.NONE, tooltips, 1, IAgriGrowCondition.CacheType.BLOCK_UPDATE);
    }

    @Override
    public GrowConditionBase<Long> time(BiFunction<Integer, Long, IAgriGrowthResponse> response, List<ITextComponent> tooltips) {
        return new GrowConditionAmbient<Long>(RequirementType.TIME, response, Functions.TIME, tooltips, IAgriGrowCondition.CacheType.FULL);
    }

    @Override
    public GrowConditionBase<Stream<BlockState>> blockStatesNearby(RequirementType type, BiFunction<Integer, Stream<BlockState>, IAgriGrowthResponse> response, BlockPos minOffset, BlockPos maxOffset, List<ITextComponent> tooltips) {
        return new GrowConditionBase<Stream<BlockState>>(type, response, Functions.blockstate(minOffset, maxOffset), Offsetters.NONE, tooltips, 1, IAgriGrowCondition.CacheType.NONE);
    }

    @Override
    public GrowConditionBase<Stream<Entity>> entitiesNearby(BiFunction<Integer, Stream<Entity>, IAgriGrowthResponse> response, double range, List<ITextComponent> tooltips) {
        return new GrowConditionBase<Stream<Entity>>(RequirementType.ENTITY, response, Functions.entity(range), Offsetters.NONE, tooltips, 1, IAgriGrowCondition.CacheType.NONE);
    }

    @Override
    public GrowConditionBase<Boolean> rain(BiFunction<Integer, Boolean, IAgriGrowthResponse> response, List<ITextComponent> tooltips) {
        return new GrowConditionBase<Boolean>(RequirementType.RAIN, response, Functions.RAIN, Offsetters.NONE, tooltips, 1, IAgriGrowCondition.CacheType.NONE);
    }

    @Override
    public GrowConditionBase<Boolean> snow(BiFunction<Integer, Boolean, IAgriGrowthResponse> response, List<ITextComponent> tooltips) {
        return new GrowConditionBase<Boolean>(RequirementType.SNOW, response, Functions.SNOW, Offsetters.NONE, tooltips, 1, IAgriGrowCondition.CacheType.NONE);
    }

    @Override
    public GrowConditionBase<AgriSeason> season(BiFunction<Integer, AgriSeason, IAgriGrowthResponse> response, List<ITextComponent> tooltips) {
        return new GrowConditionBase<AgriSeason>(RequirementType.SEASON, response, Functions.SEASON, Offsetters.NONE, tooltips, 1, IAgriGrowCondition.CacheType.NONE);
    }

    @Override
    public GrowConditionBase<Stream<Structure<?>>> structure(BiFunction<Integer, Stream<Structure<?>>, IAgriGrowthResponse> response, List<ITextComponent> tooltips) {
        return new GrowConditionBase(RequirementType.STRUCTURE, response, Functions.STRUCTURE, Offsetters.NONE, tooltips, 1, IAgriGrowCondition.CacheType.FULL);
    }

    private static final class Offsetters {
        private static final UnaryOperator<BlockPos> NONE = pos -> pos;
        private static final UnaryOperator<BlockPos> SOIL = BlockPos::func_177977_b;

        private Offsetters() {
        }
    }

    private static final class Functions {
        private static final BiFunction<World, BlockPos, IAgriSoil> SOIL = (world, pos) -> AgriApi.getSoil((IBlockReader)world, pos).orElse(NoSoil.getInstance());
        private static final BiFunction<World, BlockPos, Integer> LIGHT = IWorldReader::func_201696_r;
        private static final BiFunction<World, BlockPos, Fluid> FLUID = (world, pos) -> world.func_180495_p(pos).func_204520_s().func_206886_c();
        private static final BiFunction<World, BlockPos, Integer> REDSTONE = World::func_175687_A;
        private static final BiFunction<World, BlockPos, Biome> BIOME = IWorldReader::func_226691_t_;
        private static final Function<World, RegistryKey<World>> DIMENSION_KEY = World::func_234923_W_;
        private static final Function<World, DimensionType> DIMENSION_TYPE = World::func_230315_m_;
        private static final Function<World, Long> TIME = World::func_72820_D;
        private static final BiFunction<World, BlockPos, Boolean> RAIN = (world, pos) -> world.func_175727_C(pos) && world.func_226691_t_(pos).func_201851_b() == Biome.RainType.RAIN;
        private static final BiFunction<World, BlockPos, Boolean> SNOW = (world, pos) -> world.func_175727_C(pos) && world.func_226691_t_(pos).func_201851_b() == Biome.RainType.SNOW;
        private static final BiFunction<World, BlockPos, AgriSeason> SEASON = (world, pos) -> AgriApi.getSeasonLogic().getSeason((World)world, (BlockPos)pos);
        private static final BiFunction<World, BlockPos, Optional<IAgriCrop>> CROP = AgriApi::getCrop;
        private static final BiFunction<World, BlockPos, Stream<Structure<?>>> STRUCTURE = (world, pos) -> world.func_175726_f(pos).func_201604_d().entrySet().stream().filter(entry -> entry.getValue() != null && !((LongSet)entry.getValue()).isEmpty()).map(Map.Entry::getKey);

        private static <P extends IAgriSoil.SoilProperty> BiFunction<World, BlockPos, P> soilProperty(Function<IAgriSoil, P> mapper) {
            return SOIL.andThen(mapper);
        }

        private static BiFunction<World, BlockPos, Stream<Entity>> entity(double range) {
            return (world, pos) -> world.func_72839_b(null, new AxisAlignedBB(pos.func_177963_a(-range, -range, -range), pos.func_177963_a(range, range, range))).stream();
        }

        private static BiFunction<World, BlockPos, Stream<BlockState>> blockstate(BlockPos min, BlockPos max) {
            return (world, pos) -> WorldHelper.streamPositions((BlockPos)pos.func_177971_a((Vector3i)min), (BlockPos)pos.func_177971_a((Vector3i)max)).map(arg_0 -> ((World)world).func_180495_p(arg_0));
        }

        private Functions() {
        }
    }
}

