/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.impl.v1.requirement;

import com.google.common.collect.ImmutableList;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.plugin.IAgriPlugin;
import com.infinityraider.agricraft.api.v1.requirement.AgriSeason;
import com.infinityraider.agricraft.api.v1.requirement.IAgriSeasonLogic;
import com.infinityraider.agricraft.config.Config;
import com.infinityraider.agricraft.impl.v1.requirement.SeasonLogic;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.ModList;

public abstract class SeasonPlugin
implements IAgriPlugin {
    public static final List<String> SEASON_MODS = ImmutableList.of((Object)"betterweather", (Object)"sereneseasons");

    public static String getConfigComment() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < SEASON_MODS.size(); ++i) {
            if (i == 0) {
                builder.append("\"");
            } else {
                builder.append(", \"");
            }
            builder.append(SEASON_MODS.get(i));
            builder.append("\"");
        }
        return builder.toString();
    }

    @Override
    public final void registerSeasonLogic(@Nonnull IAgriSeasonLogic seasonLogic) {
        if (SeasonLogic.getInstance().getOwner() == null) {
            if (SEASON_MODS.stream().filter(id -> !id.equalsIgnoreCase(this.getId())).anyMatch(id -> ModList.get().isLoaded(id))) {
                if (((Config)AgriCraft.instance.getConfig()).getSeasonLogicMod().equalsIgnoreCase(this.getId())) {
                    SeasonLogic.getInstance().claim(this, this.getSeasonGetter());
                }
            } else {
                SeasonLogic.getInstance().claim(this, this.getSeasonGetter());
            }
        }
    }

    protected abstract BiFunction<World, BlockPos, AgriSeason> getSeasonGetter();
}

