/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.impl.v1.stats;

import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.config.IAgriConfig;
import com.infinityraider.agricraft.api.v1.stat.IAgriStat;
import com.infinityraider.agricraft.api.v1.stat.IAgriStatRegistry;
import com.infinityraider.agricraft.content.tools.ItemSeedBag;
import com.infinityraider.agricraft.impl.v1.AgriRegistryAbstract;
import com.infinityraider.agricraft.impl.v1.genetics.AgriGeneRegistry;
import com.infinityraider.agricraft.impl.v1.stats.AgriStat;
import javax.annotation.Nullable;
import net.minecraft.util.math.vector.Vector3f;

public class AgriStatRegistry
extends AgriRegistryAbstract<IAgriStat>
implements IAgriStatRegistry {
    private static final AgriStatRegistry INSTANCE = new AgriStatRegistry();
    private final IAgriStat gain;
    private final IAgriStat growth;
    private final IAgriStat strength;
    private final IAgriStat resistance;
    private final IAgriStat fertility;
    private final IAgriStat mutativity;

    public static AgriStatRegistry getInstance() {
        return INSTANCE;
    }

    private AgriStatRegistry() {
        IAgriConfig config = (IAgriConfig)AgriCraft.instance.getConfig();
        this.gain = new AgriStat("gain", config::getGainStatMinValue, config::getGainStatMaxValue, config::isGainStatHidden, new Vector3f(0.0f, 0.0f, 1.0f));
        this.growth = new AgriStat("growth", config::getGrowthStatMinValue, config::getGrowthStatMaxValue, config::isGrowthStatHidden, new Vector3f(0.0f, 1.0f, 0.0f));
        this.strength = new AgriStat("strength", config::getStrengthStatMinValue, config::getStrengthStatMaxValue, config::isStrengthStatHidden, new Vector3f(1.0f, 0.0f, 0.0f));
        this.resistance = new AgriStat("resistance", config::getResistanceStatMinValue, config::getResistanceStatMaxValue, config::isResistanceStatHidden, new Vector3f(1.0f, 1.0f, 0.0f));
        this.fertility = new AgriStat("fertility", config::getFertilityStatMinValue, config::getFertilityStatMaxValue, config::isFertilityStatHidden, new Vector3f(1.0f, 0.5f, 0.0f));
        this.mutativity = new AgriStat("mutativity", config::getMutativityStatMinValue, config::getMutativityStatMaxValue, config::isMutativityStatHidden, new Vector3f(0.0f, 1.0f, 1.0f));
    }

    @Override
    public boolean add(@Nullable IAgriStat element) {
        boolean result = super.add(element);
        if (result) {
            AgriGeneRegistry.getInstance().addGeneForStat(element);
            ItemSeedBag.addSorter(element);
        }
        return result;
    }

    @Override
    public boolean remove(@Nullable IAgriStat element) {
        if (this.has(element)) {
            boolean result = super.remove(element);
            if (element != null && result) {
                AgriGeneRegistry.getInstance().removeGeneForStat(element);
            }
            return result;
        }
        return false;
    }

    @Override
    public IAgriStat gainStat() {
        return this.gain;
    }

    @Override
    public IAgriStat growthStat() {
        return this.growth;
    }

    @Override
    public IAgriStat strengthStat() {
        return this.strength;
    }

    @Override
    public IAgriStat fertilityStat() {
        return this.fertility;
    }

    @Override
    public IAgriStat resistanceStat() {
        return this.resistance;
    }

    @Override
    public IAgriStat mutativityStat() {
        return this.mutativity;
    }

    static {
        INSTANCE.add(AgriStatRegistry.INSTANCE.gain);
        INSTANCE.add(AgriStatRegistry.INSTANCE.growth);
        INSTANCE.add(AgriStatRegistry.INSTANCE.strength);
        INSTANCE.add(AgriStatRegistry.INSTANCE.resistance);
        INSTANCE.add(AgriStatRegistry.INSTANCE.fertility);
        INSTANCE.add(AgriStatRegistry.INSTANCE.mutativity);
    }
}

