/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.network.json;

import com.agricraft.agricore.core.AgriCore;
import com.agricraft.agricore.json.AgriSaver;
import com.agricraft.agricore.plant.AgriWeed;
import com.google.common.collect.ImmutableList;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.impl.v1.CoreHandler;
import com.infinityraider.agricraft.impl.v1.plant.JsonWeed;
import com.infinityraider.agricraft.network.json.JsonSerializer;
import com.infinityraider.infinitylib.network.MessageBase;
import com.infinityraider.infinitylib.network.serialization.IMessageSerializer;
import java.nio.file.Path;
import java.util.List;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageSyncWeedJson
extends MessageBase {
    private AgriWeed weed;
    private int index;
    private int count;

    public MessageSyncWeedJson() {
    }

    public MessageSyncWeedJson(AgriWeed weed, int index, int count) {
        this.weed = weed;
        this.index = index;
        this.count = count;
    }

    public NetworkDirection getMessageDirection() {
        return NetworkDirection.PLAY_TO_CLIENT;
    }

    protected void processMessage(NetworkEvent.Context ctx) {
        if (this.index == 0) {
            AgriCore.getWeeds().clearElements();
        }
        AgriCore.getWeeds().addWeed(this.weed);
        AgriCore.getLogger("agricraft-net").debug("Recieved Weed {0} ({1} of {2}).", this.weed.getId(), this.index + 1, this.count);
        if (this.index == this.count - 1) {
            Path worldDir = CoreHandler.getJsonDir().resolve(this.getServerId());
            AgriSaver.saveElements(worldDir, AgriCore.getWeeds().getAllElements());
            AgriCore.getWeeds().getAllElements().stream().map(JsonWeed::new).forEach(AgriApi.getWeedRegistry()::add);
        }
    }

    protected List<IMessageSerializer> getNecessarySerializers() {
        return ImmutableList.of(new JsonSerializer());
    }
}

