/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.plugins.botanypots;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.crop.IAgriGrowthStage;
import com.infinityraider.agricraft.api.v1.plant.AgriPlantIngredient;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.requirement.IAgriGrowthRequirement;
import com.infinityraider.agricraft.plugins.botanypots.BotanyPotsPlantRenderer;
import com.infinityraider.infinitylib.crafting.IInfIngredientSerializer;
import com.infinityraider.infinitylib.crafting.IInfRecipeSerializer;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.block.DisplayableBlockState;
import net.darkhax.botanypots.BotanyPotHelper;
import net.darkhax.botanypots.BotanyPots;
import net.darkhax.botanypots.crop.CropInfo;
import net.darkhax.botanypots.crop.HarvestEntry;
import net.darkhax.botanypots.soil.SoilInfo;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class AgriCropInfo
extends CropInfo {
    public static final Serializer SERIALIZER = new Serializer();
    private final float growthStatFactor;
    private final DisplayableBlockState[] display;

    public AgriCropInfo(ResourceLocation id, AgriPlantIngredient plant, int growthTicks, float growthStatFactor) {
        super(id, (Ingredient)plant, Collections.emptySet(), growthTicks, Collections.emptyList(), new DisplayableBlockState[0], Optional.empty());
        this.growthStatFactor = growthStatFactor;
        this.display = new DisplayableBlockState[]{new AgriDisplayState()};
    }

    public IAgriPlant getPlant() {
        return this.getSeed().getPlant();
    }

    public float getGrowthStatFactor() {
        return this.growthStatFactor;
    }

    public AgriPlantIngredient getSeed() {
        return (AgriPlantIngredient)super.getSeed();
    }

    public ITextComponent getName() {
        return this.getPlant().getPlantName();
    }

    public Set<String> getSoilCategories() {
        return BotanyPotHelper.getManager().func_241447_a_(BotanyPots.instance.getContent().recipeTypeSoil).stream().map(SoilInfo::getCategories).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public List<HarvestEntry> getResults() {
        ArrayList drops = Lists.newArrayList();
        this.getPlant().getAllPossibleClipProducts(drops::add);
        float size = drops.size();
        if (size > 0.0f) {
            return drops.stream().map(drop -> new HarvestEntry(1.0f / (float)drops.size(), drop, 1, 1)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public DisplayableBlockState[] getDisplayState() {
        return this.display;
    }

    public int getLightLevel(IBlockReader world, BlockPos pos) {
        return 0;
    }

    public int getGrowthTicksForSoil(SoilInfo soilInfo) {
        Block block = soilInfo.getRenderState().getState().func_177230_c();
        if (block == Blocks.field_150346_d) {
            block = Blocks.field_150458_ak;
        }
        return AgriApi.getSoilRegistry().valueOf(block).map(soil -> {
            IAgriGrowthRequirement req = this.getPlant().getGrowthRequirement(this.getPlant().getInitialGrowthStage());
            if (!req.getSoilHumidityResponse(soil.getHumidity(), 1).isFertile()) {
                return -1;
            }
            if (!req.getSoilAcidityResponse(soil.getAcidity(), 1).isFertile()) {
                return -1;
            }
            if (!req.getSoilNutrientsResponse(soil.getNutrients(), 1).isFertile()) {
                return -1;
            }
            float modifier = soilInfo.getGrowthModifier();
            if (modifier > -1.0f) {
                modifier = (1.0f - modifier) * (float)(2.0 - soil.getGrowthModifier());
                return MathHelper.func_76141_d((float)((float)this.getGrowthTicks() * modifier));
            }
            return -1;
        }).orElse(-1);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    private static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<AgriCropInfo>,
    IInfRecipeSerializer {
        private static final String ID = "botany_pots_crop";

        private Serializer() {
        }

        public Collection<IInfIngredientSerializer<?>> getIngredientSerializers() {
            return Collections.emptyList();
        }

        @Nonnull
        public String getInternalName() {
            return ID;
        }

        public boolean isEnabled() {
            return ModList.get().isLoaded("botanypots");
        }

        @Nonnull
        public AgriCropInfo read(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            if (!json.has("plant")) {
                throw new JsonParseException("Agricraft botany pots crop must have a \"plant\" property");
            }
            if (!json.has("growthTicks")) {
                throw new JsonParseException("Agricraft botany pots crop must have a \"growthTicks\" property");
            }
            if (!json.has("growthStatFactor")) {
                throw new JsonParseException("Agricraft botany pots crop must have a \"growthStatFactor\" property");
            }
            AgriPlantIngredient plant = (AgriPlantIngredient)AgriCraft.instance.getModRecipeSerializerRegistry().plant_ingredient.parse(json);
            int growthTicks = json.get("growthTicks").getAsInt();
            float growthStatFactor = json.get("growthStatFactor").getAsFloat();
            return new AgriCropInfo(recipeId, plant, growthTicks, growthStatFactor);
        }

        @Nullable
        public AgriCropInfo read(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
            AgriPlantIngredient plant = (AgriPlantIngredient)AgriCraft.instance.getModRecipeSerializerRegistry().plant_ingredient.parse(buffer);
            int growthTicks = buffer.readInt();
            float growthStatFactor = buffer.readFloat();
            return new AgriCropInfo(recipeId, plant, growthTicks, growthStatFactor);
        }

        public void write(@Nonnull PacketBuffer buffer, @Nonnull AgriCropInfo info) {
            AgriCraft.instance.getModRecipeSerializerRegistry().plant_ingredient.write(buffer, (Ingredient)info.getSeed());
            buffer.writeInt(info.getGrowthTicks());
            buffer.writeFloat(info.getGrowthStatFactor());
        }
    }

    private class AgriDisplayState
    extends DisplayableBlockState {
        public AgriDisplayState() {
            super(AgriCraft.instance.getModBlockRegistry().crop_plant.func_176223_P());
        }

        protected IAgriGrowthStage fetchStage(World world, BlockPos pos) {
            return AgriApi.getCrop((IBlockReader)world, pos).map(IAgriCrop::getGrowthStage).orElse(AgriCropInfo.this.getPlant().getFinalStage());
        }

        @OnlyIn(value=Dist.CLIENT)
        public void render(World world, BlockPos pos, MatrixStack matrix, IRenderTypeBuffer buffer, int light, int overlay, Direction ... preferredSides) {
            BotanyPotsPlantRenderer.getInstance().renderPlant(AgriCropInfo.this.getPlant(), this.fetchStage(world, pos), matrix, buffer, light, overlay, preferredSides);
        }
    }
}

