/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.plugins.botanypots;

import com.google.common.base.Preconditions;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.crop.CropCapability;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.crop.IAgriGrowthStage;
import com.infinityraider.agricraft.api.v1.event.AgriCropEvent;
import com.infinityraider.agricraft.api.v1.fertilizer.IAgriFertilizer;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenome;
import com.infinityraider.agricraft.api.v1.items.IAgriRakeItem;
import com.infinityraider.agricraft.api.v1.items.IAgriSeedItem;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.plant.IAgriWeed;
import com.infinityraider.agricraft.api.v1.requirement.IAgriGrowthRequirement;
import com.infinityraider.agricraft.api.v1.requirement.IAgriGrowthResponse;
import com.infinityraider.agricraft.api.v1.requirement.IAgriSoil;
import com.infinityraider.agricraft.api.v1.stat.IAgriStatProvider;
import com.infinityraider.agricraft.api.v1.stat.IAgriStatsMap;
import com.infinityraider.agricraft.impl.v1.crop.NoGrowth;
import com.infinityraider.agricraft.impl.v1.plant.NoPlant;
import com.infinityraider.agricraft.impl.v1.plant.NoWeed;
import com.infinityraider.agricraft.impl.v1.requirement.AgriGrowthRequirement;
import com.infinityraider.agricraft.impl.v1.stats.NoStats;
import com.infinityraider.agricraft.plugins.botanypots.AgriCropInfo;
import com.infinityraider.agricraft.reference.AgriToolTips;
import java.util.Comparator;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.darkhax.botanypots.BotanyPotHelper;
import net.darkhax.botanypots.block.BlockBotanyPot;
import net.darkhax.botanypots.block.tileentity.TileEntityBotanyPot;
import net.darkhax.botanypots.crop.CropInfo;
import net.darkhax.botanypots.soil.SoilInfo;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class BotanyPotAgriCropInstance
implements CropCapability.Instance<TileEntityBotanyPot, Impl> {
    private static final BotanyPotAgriCropInstance INSTANCE = new BotanyPotAgriCropInstance();

    public static BotanyPotAgriCropInstance getInstance() {
        return INSTANCE;
    }

    private BotanyPotAgriCropInstance() {
    }

    @Override
    public Class<TileEntityBotanyPot> getCarrierClass() {
        return TileEntityBotanyPot.class;
    }

    @Override
    public Class<Impl> getCropClass() {
        return Impl.class;
    }

    @Override
    public Impl createCropFor(TileEntityBotanyPot tile) {
        return new Impl(tile);
    }

    @Override
    public void writeToNBT(CompoundNBT tag, Impl crop) {
        tag.func_74778_a("agri_growth", crop.stage.getId());
        tag.func_74778_a("agri_weed_growth", crop.next.getId());
    }

    @Override
    public void readFromNBT(CompoundNBT tag, Impl crop) {
        if (tag.func_74764_b("agri_growth") && tag.func_74764_b("agri_weed_growth")) {
            crop.stage = AgriApi.getGrowthStageRegistry().get(tag.func_74779_i("agri_growth")).orElse(NoGrowth.getInstance());
            crop.next = crop.stage.isGrowthStage() ? AgriApi.getGrowthStageRegistry().get(tag.func_74779_i("agri_weed_growth")).orElse(NoGrowth.getInstance()) : crop.stage;
        }
    }

    public static class Impl
    implements IAgriCrop {
        private final TileEntityBotanyPot pot;
        private IAgriGrowthStage stage;
        private IAgriGrowthStage next;

        private Impl(TileEntityBotanyPot pot) {
            this.pot = pot;
            this.stage = NoGrowth.getInstance();
            this.next = NoGrowth.getInstance();
        }

        public TileEntityBotanyPot asTile() {
            return this.pot;
        }

        @Override
        public boolean isValid() {
            return !this.asTile().func_145837_r() && this.asTile().getCrop() instanceof AgriCropInfo;
        }

        @Override
        @Nonnull
        public BlockPos getPosition() {
            return this.asTile().func_174877_v();
        }

        @Override
        @Nonnull
        public BlockState getBlockState() {
            return this.asTile().func_195044_w();
        }

        @Override
        @Nonnull
        public FluidState getFluidState() {
            return this.getBlockState().func_204520_s();
        }

        @Override
        @Nonnull
        public IAgriGrowthStage getGrowthStage() {
            World world = this.world();
            if (world == null) {
                return NoGrowth.getInstance();
            }
            if (this.hasPlant()) {
                if (this.stage.isGrowthStage() && this.next.isGrowthStage()) {
                    float progress = this.asTile().getGrowthPercent();
                    if ((double)progress >= this.next.growthPercentage() && !this.stage.isFinal()) {
                        this.stage = this.next;
                        this.next = this.stage.getNextStage(this, world.func_201674_k());
                    }
                } else {
                    float progress = this.asTile().getGrowthPercent();
                    this.stage = this.getPlant().getGrowthStages().stream().sorted(Comparator.comparingDouble(IAgriGrowthStage::growthPercentage)).filter(stage -> stage.growthPercentage() >= (double)progress).findFirst().orElse(this.getPlant().getFinalStage());
                    this.next = this.stage.getNextStage(this, world.func_201674_k());
                }
            } else {
                this.stage = NoGrowth.getInstance();
                this.next = NoGrowth.getInstance();
            }
            return this.stage;
        }

        @Override
        public boolean setGrowthStage(@Nonnull IAgriGrowthStage stage) {
            return false;
        }

        @Override
        public boolean hasCropSticks() {
            return false;
        }

        @Override
        public boolean isCrossCrop() {
            return false;
        }

        @Override
        public boolean setCrossCrop(boolean status) {
            return false;
        }

        @Override
        public IAgriGrowthResponse getFertilityResponse() {
            return this.getPlant().getGrowthRequirement(this.getGrowthStage()).check(this);
        }

        @Override
        public boolean isMature() {
            return this.asTile().canHarvest();
        }

        @Override
        public boolean isFullyGrown() {
            return this.asTile().canHarvest();
        }

        @Override
        @Nonnull
        public Optional<IAgriSoil> getSoil() {
            SoilInfo soilInfo = this.asTile().getSoil();
            if (soilInfo == null) {
                return Optional.empty();
            }
            Block block = soilInfo.getRenderState().getState().func_177230_c();
            if (block == Blocks.field_150346_d) {
                block = Blocks.field_150458_ak;
            }
            return AgriApi.getSoilRegistry().valueOf(block);
        }

        @Override
        public void breakCrop(@Nullable LivingEntity entity) {
            if (this.hasPlant()) {
                IAgriPlant plant = this.getPlant();
                IAgriWeed weed = this.getWeeds();
                if (!MinecraftForge.EVENT_BUS.post((Event)new AgriCropEvent.Break.Pre(this, entity)) && this.removeGenome()) {
                    plant.onBroken(this, entity);
                    weed.onBroken(this, entity);
                    MinecraftForge.EVENT_BUS.post((Event)new AgriCropEvent.Break.Post(this, entity));
                }
            }
        }

        @Override
        @Nonnull
        public Stream<IAgriCrop> streamNeighbours() {
            return Stream.empty();
        }

        @Override
        public void dropItem(ItemStack item) {
            World world = this.world();
            if (world != null) {
                BlockBotanyPot.dropItem((ItemStack)item, (World)world, (BlockPos)this.getPosition());
            }
        }

        @Override
        public boolean canBeHarvested(@Nullable LivingEntity entity) {
            return this.hasPlant() && this.isMature() && this.getPlant().allowsHarvest(this.getGrowthStage(), entity);
        }

        @Override
        @Nonnull
        public ActionResultType harvest(@Nonnull Consumer<ItemStack> consumer, @Nullable LivingEntity entity) {
            World world = this.world();
            CropInfo crop = this.asTile().getCrop();
            if (world != null && crop instanceof AgriCropInfo && this.canBeHarvested(entity) && !MinecraftForge.EVENT_BUS.post((Event)new AgriCropEvent.Harvest.Pre(this, entity))) {
                this.asTile().onCropHarvest();
                this.asTile().resetGrowthTime();
                for (ItemStack stack : BotanyPotHelper.getHarvestStacks((World)world, (CropInfo)crop)) {
                    this.dropItem(stack);
                }
                this.getPlant().onHarvest(this, entity);
                MinecraftForge.EVENT_BUS.post((Event)new AgriCropEvent.Harvest.Post(this, entity));
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        }

        @Override
        public boolean canBeRaked(@Nonnull IAgriRakeItem item, @Nonnull ItemStack stack, @Nullable LivingEntity entity) {
            return false;
        }

        @Override
        public boolean rake(@Nonnull Consumer<ItemStack> consumer, @Nullable LivingEntity entity) {
            return false;
        }

        @Override
        public boolean acceptsFertilizer(@Nonnull IAgriFertilizer fertilizer) {
            return false;
        }

        @Override
        public void onApplyFertilizer(@Nonnull IAgriFertilizer fertilizer, @Nonnull Random rand) {
        }

        @Override
        public void applyGrowthTick() {
        }

        @Override
        public void addDisplayInfo(@Nonnull Consumer<ITextComponent> consumer) {
            Preconditions.checkNotNull(consumer);
            if (this.hasPlant()) {
                consumer.accept(AgriToolTips.getPlantTooltip(this.getPlant()));
                this.getStats().addTooltips(consumer);
                this.getSoil().ifPresent(soil -> {
                    IAgriGrowthRequirement req = this.getPlant().getGrowthRequirement(this.getPlant().getInitialGrowthStage());
                    if (!req.getSoilHumidityResponse(soil.getHumidity(), 1).isFertile()) {
                        AgriGrowthRequirement.Tooltips.HUMIDITY_DESCRIPTION.forEach(consumer);
                    }
                    if (!req.getSoilAcidityResponse(soil.getAcidity(), 1).isFertile()) {
                        AgriGrowthRequirement.Tooltips.ACIDITY_DESCRIPTION.forEach(consumer);
                    }
                    if (!req.getSoilNutrientsResponse(soil.getNutrients(), 1).isFertile()) {
                        AgriGrowthRequirement.Tooltips.NUTRIENT_DESCRIPTION.forEach(consumer);
                    }
                });
            } else {
                consumer.accept(AgriToolTips.NO_PLANT);
            }
            if (this.hasWeeds()) {
                consumer.accept(AgriToolTips.getWeedTooltip(this.getWeeds()));
                consumer.accept(AgriToolTips.getWeedGrowthTooltip(this.getWeedGrowthStage()));
            } else {
                consumer.accept(AgriToolTips.NO_WEED);
            }
            this.getSoil().map(soil -> {
                consumer.accept(AgriToolTips.getSoilTooltip(soil));
                return true;
            }).orElseGet(() -> {
                consumer.accept(AgriToolTips.getUnknownTooltip(AgriToolTips.SOIL));
                return false;
            });
        }

        @Override
        public boolean hasPlant() {
            return this.asTile().getCrop() instanceof AgriCropInfo && ((AgriCropInfo)this.asTile().getCrop()).getPlant().isPlant();
        }

        @Override
        @Nonnull
        public IAgriPlant getPlant() {
            return this.hasPlant() ? ((AgriCropInfo)this.asTile().getCrop()).getPlant() : NoPlant.getInstance();
        }

        @Override
        public boolean hasWeeds() {
            return false;
        }

        @Override
        @Nonnull
        public IAgriWeed getWeeds() {
            return NoWeed.getInstance();
        }

        @Override
        @Nonnull
        public IAgriGrowthStage getWeedGrowthStage() {
            return NoGrowth.getInstance();
        }

        @Override
        public boolean setWeed(@Nonnull IAgriWeed weed, @Nonnull IAgriGrowthStage stage) {
            return false;
        }

        @Override
        public boolean removeWeed() {
            return false;
        }

        @Override
        public boolean acceptsGenome(@Nonnull IAgriGenome genome) {
            return this.asTile().getCrop() == null && this.asTile().getSoil() != null;
        }

        @Override
        public boolean spawnGenome(@Nonnull IAgriGenome genome) {
            if (this.asTile().getCrop() != null) {
                return false;
            }
            SoilInfo soil = this.asTile().getSoil();
            if (soil == null) {
                return false;
            }
            ItemStack seed = genome.toSeedStack();
            CropInfo crop = BotanyPotHelper.getCropForItem((ItemStack)seed);
            if (crop != null && BotanyPotHelper.isSoilValidForCrop((SoilInfo)soil, (CropInfo)crop) && this.asTile().canSetCrop(crop) && !MinecraftForge.EVENT_BUS.post((Event)new AgriCropEvent.Spawn.Plant.Pre((IAgriCrop)this, genome))) {
                this.asTile().setCrop(crop, seed);
                this.getPlant().onSpawned(this);
                MinecraftForge.EVENT_BUS.post((Event)new AgriCropEvent.Spawn.Plant.Post((IAgriCrop)this, genome));
                return true;
            }
            return false;
        }

        @Override
        public boolean plantGenome(@Nonnull IAgriGenome genome) {
            return this.plantGenome(genome, null);
        }

        @Override
        public boolean plantGenome(@Nonnull IAgriGenome genome, @Nullable LivingEntity entity) {
            if (this.asTile().getCrop() != null) {
                return false;
            }
            SoilInfo soil = this.asTile().getSoil();
            if (soil == null) {
                return false;
            }
            ItemStack seedStack = genome.toSeedStack();
            CropInfo crop = BotanyPotHelper.getCropForItem((ItemStack)seedStack);
            if (crop != null && BotanyPotHelper.isSoilValidForCrop((SoilInfo)soil, (CropInfo)crop) && this.asTile().canSetCrop(crop) && !MinecraftForge.EVENT_BUS.post((Event)new AgriCropEvent.Plant.Pre(this, genome, entity))) {
                this.asTile().setCrop(crop, seedStack);
                this.getPlant().onSpawned(this);
                MinecraftForge.EVENT_BUS.post((Event)new AgriCropEvent.Plant.Post(this, genome, entity));
                return true;
            }
            return false;
        }

        @Override
        public boolean removeGenome() {
            ItemStack seedStack;
            if (this.asTile().getCrop() != null && !(seedStack = AgriApi.getGenomeAdapterizer().valueOf(this.asTile().getCropStack()).map(IAgriGenome::toSeedStack).orElse(this.asTile().getCropStack())).func_190926_b() && this.asTile().canSetCrop(null)) {
                this.asTile().setCrop(null, ItemStack.field_190927_a);
                this.dropItem(seedStack);
                return true;
            }
            return false;
        }

        @Override
        public boolean hasGenome() {
            return this.hasPlant();
        }

        @Override
        @Nonnull
        public Optional<IAgriGenome> getGenome() {
            ItemStack stack = this.asTile().getCropStack();
            if (!(stack.func_77973_b() instanceof IAgriSeedItem)) {
                return Optional.empty();
            }
            return ((IAgriSeedItem)stack.func_77973_b()).getGenome(stack);
        }

        @Override
        @Nonnull
        public IAgriStatsMap getStats() {
            return this.getGenome().map(IAgriStatProvider::getStats).orElse(NoStats.getInstance());
        }
    }
}

