/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.plugins.jei;

import com.google.common.collect.Lists;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.crop.IAgriGrowthStage;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.plugins.jei.IAgriIngredientRenderer;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.registration.IModIngredientRegistration;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AgriIngredientPlant {
    public static final IIngredientType<IAgriPlant> TYPE = () -> IAgriPlant.class;
    private static final IIngredientHelper<IAgriPlant> HELPER = new IIngredientHelper<IAgriPlant>(){

        public IAgriPlant getMatch(Iterable<IAgriPlant> iterable, @Nonnull IAgriPlant plant) {
            return StreamSupport.stream(iterable.spliterator(), false).filter(aPlant -> aPlant == plant).findFirst().orElse(plant);
        }

        public String getDisplayName(IAgriPlant plant) {
            return plant.getPlantName().getString();
        }

        public String getUniqueId(IAgriPlant plant) {
            return plant.getId();
        }

        @Nonnull
        public String getModId(IAgriPlant plant) {
            return plant.getSeedModel().func_110624_b();
        }

        public String getResourceId(IAgriPlant plant) {
            return plant.getId();
        }

        @Nonnull
        public IAgriPlant copyIngredient(@Nonnull IAgriPlant plant) {
            return plant;
        }

        public String getErrorInfo(@Nullable IAgriPlant plant) {
            return plant == null ? "UNKNOWN PLANT" : plant.getId();
        }
    };
    public static final Renderer RENDERER = new Renderer();

    public static void register(IModIngredientRegistration registration) {
        registration.register(TYPE, (Collection)AgriApi.getPlantRegistry().stream().collect(Collectors.toList()), HELPER, (IIngredientRenderer)RENDERER);
    }

    public static class Renderer
    implements IAgriIngredientRenderer<IAgriPlant> {
        private final Map<IAgriPlant, IAgriGrowthStage> stageMap = new IdentityHashMap<IAgriPlant, IAgriGrowthStage>();

        public void useGrowthStageForNextRenderCall(IAgriPlant plant, IAgriGrowthStage stage) {
            this.stageMap.put(plant, stage);
        }

        public void render(@Nonnull MatrixStack transform, int x, int y, @Nullable IAgriPlant plant) {
            if (plant == null) {
                return;
            }
            Optional.ofNullable(this.stageMap.remove(plant)).map(stage -> {
                this.renderStage(transform, x, y, plant, (IAgriGrowthStage)stage);
                return true;
            }).orElseGet(() -> {
                plant.getGrowthStages().stream().filter(IAgriGrowthStage::isMature).findFirst().ifPresent(stage -> this.renderStage(transform, x, y, plant, (IAgriGrowthStage)stage));
                return false;
            });
        }

        private void renderStage(@Nonnull MatrixStack transform, int x, int y, IAgriPlant plant, IAgriGrowthStage stage) {
            List<ResourceLocation> tex = plant.getTexturesFor(stage);
            if (tex.size() > 0) {
                this.bindTextureAtlas();
                Screen.func_238470_a_((MatrixStack)transform, (int)x, (int)y, (int)0, (int)16, (int)16, (TextureAtlasSprite)this.getSprite(tex.get(0)));
            }
        }

        @Nonnull
        public List<ITextComponent> getTooltip(IAgriPlant plant, @Nonnull ITooltipFlag iTooltipFlag) {
            ArrayList tooltip = Lists.newArrayList();
            plant.addTooltip(tooltip::add);
            return tooltip;
        }
    }
}

