/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.plugins.jei;

import com.google.common.collect.ImmutableList;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.content.AgriItemRegistry;
import com.infinityraider.agricraft.plugins.jei.AgriIngredientPlant;
import com.infinityraider.agricraft.plugins.jei.IAgriDrawable;
import com.infinityraider.agricraft.plugins.jei.JeiPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class AgriRecipeCategoryProduce
implements IRecipeCategory<IAgriPlant> {
    public static final ResourceLocation ID = new ResourceLocation(AgriCraft.instance.getModId(), "jei/produce");
    public final IAgriDrawable icon = JeiPlugin.createAgriDrawable(new ResourceLocation(AgriCraft.instance.getModId(), "textures/item/debugger.png"), 0, 0, 16, 16, 16, 16);
    public final IAgriDrawable background = JeiPlugin.createAgriDrawable(new ResourceLocation(AgriCraft.instance.getModId(), "textures/gui/jei/crop_produce.png"), 0, 0, 128, 128, 128, 128);

    public static void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes((Collection)AgriApi.getPlantRegistry().stream().filter(IAgriPlant::isPlant).collect(Collectors.toList()), ID);
    }

    public static void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)AgriItemRegistry.getInstance().crop_sticks_wood), new ResourceLocation[]{ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)AgriItemRegistry.getInstance().crop_sticks_iron), new ResourceLocation[]{ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)AgriItemRegistry.getInstance().crop_sticks_obsidian), new ResourceLocation[]{ID});
    }

    @Nonnull
    public ResourceLocation getUid() {
        return ID;
    }

    @Nonnull
    public Class<IAgriPlant> getRecipeClass() {
        return IAgriPlant.class;
    }

    @Nonnull
    public String getTitle() {
        return I18n.func_135052_a((String)"agricraft.gui.produce", (Object[])new Object[0]);
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(IAgriPlant plant, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, (List)ImmutableList.of((Object)ImmutableList.of((Object)plant.toItemStack())));
        ingredients.setInputLists(AgriIngredientPlant.TYPE, (List)ImmutableList.of((Object)ImmutableList.of((Object)plant)));
        ArrayList products = new ArrayList();
        plant.getAllPossibleProducts(product -> products.add(ImmutableList.of((Object)product)));
        ingredients.setOutputLists(VanillaTypes.ITEM, products);
    }

    public void setRecipe(IRecipeLayout layout, @Nonnull IAgriPlant plant, @Nonnull IIngredients ingredients) {
        layout.getIngredientsGroup(AgriIngredientPlant.TYPE).setOverrideDisplayFocus(null);
        layout.getIngredientsGroup(VanillaTypes.ITEM).setOverrideDisplayFocus(null);
        layout.setShapeless();
        layout.getIngredientsGroup(AgriIngredientPlant.TYPE).init(0, true, 16, 49);
        layout.getIngredientsGroup(VanillaTypes.ITEM).init(0, true, 15, 8);
        int index = 2;
        for (int y = 32; y < 82; y += 18) {
            for (int x = 74; x < 128; x += 18) {
                layout.getItemStacks().init(++index, false, x, y);
            }
        }
        layout.getItemStacks().set(ingredients);
        layout.getIngredientsGroup(AgriIngredientPlant.TYPE).set(ingredients);
    }
}

