/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.plugins.sereneseasons;

import com.infinityraider.agricraft.api.v1.requirement.AgriSeason;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractGlassBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.config.FertilityConfig;

public class SereneSeasonsSeasonGetter
implements BiFunction<World, BlockPos, AgriSeason> {
    private static final SereneSeasonsSeasonGetter INSTANCE = new SereneSeasonsSeasonGetter();

    public static SereneSeasonsSeasonGetter getInstance() {
        return INSTANCE;
    }

    private SereneSeasonsSeasonGetter() {
    }

    @Nonnull
    public AgriSeason convert(@Nullable Object obj) {
        if (obj instanceof Season) {
            switch ((Season)obj) {
                case SPRING: {
                    return AgriSeason.SPRING;
                }
                case SUMMER: {
                    return AgriSeason.SUMMER;
                }
                case AUTUMN: {
                    return AgriSeason.AUTUMN;
                }
                case WINTER: {
                    return AgriSeason.WINTER;
                }
            }
        }
        return AgriSeason.ANY;
    }

    @Override
    public AgriSeason apply(World world, BlockPos pos) {
        if ((Integer)FertilityConfig.undergroundFertilityLevel.get() > -1 && pos.func_177956_o() < (Integer)FertilityConfig.undergroundFertilityLevel.get() && !world.func_226660_f_(pos)) {
            return AgriSeason.ANY;
        }
        BlockPos.Mutable mutablePos = pos.func_239590_i_();
        for (int i = 0; i < 16; ++i) {
            mutablePos.func_181079_c(pos.func_177958_n(), pos.func_177956_o() + i, pos.func_177952_p());
            if (!(world.func_180495_p((BlockPos)mutablePos).func_177230_c() instanceof AbstractGlassBlock)) continue;
            return AgriSeason.ANY;
        }
        return this.convert(SeasonHelper.getSeasonState((World)world).getSeason());
    }
}

