/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.reference;

import com.google.common.collect.ImmutableSet;
import com.infinityraider.agricraft.api.v1.crop.IAgriGrowthStage;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenePair;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.plant.IAgriWeed;
import com.infinityraider.agricraft.api.v1.requirement.IAgriSoil;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class AgriToolTips {
    public static final TranslationTextComponent UNKNOWN = new TranslationTextComponent("agricraft.tooltip.unknown");
    public static final ITextComponent GENOME = new TranslationTextComponent("agricraft.tooltip.genome").func_240701_a_(new TextFormatting[]{TextFormatting.DARK_GREEN, TextFormatting.BOLD});
    public static final ITextComponent PLANT = new TranslationTextComponent("agricraft.tooltip.plant");
    public static final ITextComponent NO_PLANT = new TranslationTextComponent("agricraft.tooltip.no_plant");
    public static final ITextComponent GROWTH = new TranslationTextComponent("agricraft.tooltip.growth");
    public static final ITextComponent MATURE = new TranslationTextComponent("agricraft.tooltip.mature");
    public static final ITextComponent WEED = new TranslationTextComponent("agricraft.tooltip.weed");
    public static final ITextComponent NO_WEED = new TranslationTextComponent("agricraft.tooltip.no_weed");
    public static final ITextComponent WEED_GROWTH = new TranslationTextComponent("agricraft.tooltip.weed_growth");
    public static final ITextComponent FERTILE = new TranslationTextComponent("agricraft.tooltip.fertile");
    public static final ITextComponent NOT_FERTILE = new TranslationTextComponent("agricraft.tooltip.not_fertile");
    public static final ITextComponent SOIL = new TranslationTextComponent("agricraft.tooltip.soil");
    public static final ITextComponent LIGHT = new TranslationTextComponent("agricraft.tooltip.light");
    public static final ITextComponent VALVE_INFO_OPEN = new TranslationTextComponent("agricraft.tooltip.valve.open");
    public static final ITextComponent VALVE_INFO_CLOSED = new TranslationTextComponent("agricraft.tooltip.valve.closed");
    public static final ITextComponent CLIPPER = new TranslationTextComponent("agricraft.tooltip.clipper").func_240699_a_(TextFormatting.DARK_GRAY);
    public static final ITextComponent JOURNAL_USE_1 = new TranslationTextComponent("agricraft.tooltip.journal_use_1").func_240699_a_(TextFormatting.DARK_GRAY);
    public static final ITextComponent JOURNAL_USE_2 = new TranslationTextComponent("agricraft.tooltip.journal_use_2").func_240699_a_(TextFormatting.DARK_GRAY);
    public static final ITextComponent JOURNAL_SEEDS = new TranslationTextComponent("agricraft.tooltip.journal_seeds").func_240699_a_(TextFormatting.DARK_GRAY);
    public static final ITextComponent MAGNIFYING_GLASS = new TranslationTextComponent("agricraft.tooltip.magnifying_glass").func_240699_a_(TextFormatting.DARK_GRAY);
    public static final ITextComponent RAKE = new TranslationTextComponent("agricraft.tooltip.rake").func_240699_a_(TextFormatting.DARK_GRAY);
    public static final ITextComponent TROWEL = new TranslationTextComponent("agricraft.tooltip.trowel").func_240699_a_(TextFormatting.DARK_GRAY);
    public static final ITextComponent SEED_BAG_ACTIVE = new TranslationTextComponent("agricraft.tooltip.seed_bag_active").func_240699_a_(TextFormatting.DARK_GRAY);
    public static final ITextComponent SEED_BAG_CONTENTS = new TranslationTextComponent("agricraft.tooltip.seed_bag_contents").func_240699_a_(TextFormatting.DARK_GRAY);
    public static final ITextComponent SEED_BAG_EMPTY = new TranslationTextComponent("agricraft.tooltip.seed_bag_empty").func_240699_a_(TextFormatting.DARK_GRAY);
    public static final ITextComponent SEED_BAG_SORTER = new TranslationTextComponent("agricraft.tooltip.seed_bag_sorter").func_240699_a_(TextFormatting.DARK_GRAY);
    public static final ITextComponent SEED_BAG_SORTER_DEFAULT = new TranslationTextComponent("agricraft.tooltip.seed_bag_sorter_default").func_240699_a_(TextFormatting.DARK_GRAY);
    public static final ITextComponent SEED_BAG_MAIN_HAND = new TranslationTextComponent("agricraft.tooltip.seed_bag_main_hand").func_240699_a_(TextFormatting.DARK_GRAY);
    public static final ITextComponent SEED_BAG_OFF_HAND = new TranslationTextComponent("agricraft.tooltip.seed_bag_off_hand").func_240699_a_(TextFormatting.DARK_GRAY);
    public static final ITextComponent SEED_BAG_SCROLLING = new TranslationTextComponent("agricraft.tooltip.seed_bag_scrolling").func_240699_a_(TextFormatting.DARK_GRAY);
    public static final ITextComponent SEED_BAG_INACTIVE_1 = new TranslationTextComponent("agricraft.tooltip.seed_bag_inactive_1").func_240699_a_(TextFormatting.DARK_GRAY);
    public static final ITextComponent SEED_BAG_INACTIVE_2 = new TranslationTextComponent("agricraft.tooltip.seed_bag_inactive_2").func_240699_a_(TextFormatting.DARK_GRAY);
    public static final ITextComponent SEED_ANALYZER_L1 = new TranslationTextComponent("agricraft.tooltip.analyzer.l1").func_240699_a_(TextFormatting.DARK_GRAY);
    public static final ITextComponent SEED_ANALYZER_L2 = new TranslationTextComponent("agricraft.tooltip.analyzer.l2").func_240699_a_(TextFormatting.DARK_GRAY);
    public static final ITextComponent GRATE_L1 = new TranslationTextComponent("agricraft.tooltip.grate.l1").func_240699_a_(TextFormatting.DARK_GRAY);
    public static final ITextComponent GRATE_L2 = new TranslationTextComponent("agricraft.tooltip.grate.l2").func_240699_a_(TextFormatting.DARK_GRAY);
    public static final ITextComponent TANK_L1 = new TranslationTextComponent("agricraft.tooltip.tank.l1").func_240699_a_(TextFormatting.DARK_GRAY);
    public static final ITextComponent SPRINKLER = new TranslationTextComponent("agricraft.tooltip.sprinkler.l1").func_240699_a_(TextFormatting.DARK_GRAY);
    public static final ITextComponent VALVE_L1 = new TranslationTextComponent("agricraft.tooltip.valve.l1").func_240699_a_(TextFormatting.DARK_GRAY);
    public static final ITextComponent VALVE_L2 = new TranslationTextComponent("agricraft.tooltip.valve.l2").func_240699_a_(TextFormatting.DARK_GRAY);
    public static final ITextComponent VALVE_L3 = new TranslationTextComponent("agricraft.tooltip.valve.l3").func_240699_a_(TextFormatting.DARK_GRAY);
    public static final ITextComponent SNEAK_INFO = new TranslationTextComponent("agricraft.tooltip.sneak_info").func_240699_a_(TextFormatting.DARK_GRAY);
    public static final ITextComponent EMPTY_LINE = new StringTextComponent("");
    public static final ITextComponent MSG_ANALYZER_VIEW_BLOCKED = new TranslationTextComponent("agricraft.message.analyzer_view_blocked");
    public static final ITextComponent MSG_CLIPPING_IMPOSSIBLE = new TranslationTextComponent("agricraft.message.clipping_impossible");
    public static final ITextComponent MSG_TROWEL_WEED = new TranslationTextComponent("agricraft.message.trowel_weed");
    public static final ITextComponent MSG_TROWEL_PLANT = new TranslationTextComponent("agricraft.message.trowel_plant");
    public static final ITextComponent MSG_TROWEL_NO_PLANT = new TranslationTextComponent("agricraft.message.trowel_no_plant");

    public static ITextComponent getPlantTooltip(IAgriPlant plant) {
        return new StringTextComponent("").func_230529_a_(PLANT).func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_((ITextComponent)plant.getPlantName());
    }

    public static ITextComponent getWeedTooltip(IAgriWeed weed) {
        return new StringTextComponent("").func_230529_a_(WEED).func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_(weed.getWeedName());
    }

    public static ITextComponent getGrowthTooltip(IAgriGrowthStage growth) {
        if (growth.isFinal()) {
            return new StringTextComponent("").func_230529_a_(GROWTH).func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_(MATURE);
        }
        return new StringTextComponent("").func_230529_a_(GROWTH).func_230529_a_((ITextComponent)new StringTextComponent(": " + (int)(100.0 * growth.growthPercentage()) + "%"));
    }

    public static ITextComponent getWeedGrowthTooltip(IAgriGrowthStage growth) {
        return new StringTextComponent("").func_230529_a_(WEED_GROWTH).func_230529_a_((ITextComponent)new StringTextComponent(": " + (int)(100.0 * growth.growthPercentage()) + "%"));
    }

    public static ITextComponent getSoilTooltip(IAgriSoil soil) {
        return new StringTextComponent("").func_230529_a_(SOIL).func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_(soil.getName());
    }

    public static ITextComponent getUnknownTooltip(ITextComponent source) {
        return new StringTextComponent("").func_230529_a_(source).func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_((ITextComponent)UNKNOWN);
    }

    public static ITextComponent getGeneTooltip(IAgriGenePair<?> genePair) {
        return new StringTextComponent("").func_230529_a_((ITextComponent)genePair.getGene().getGeneDescription()).func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_((ITextComponent)genePair.getDominant().getTooltip()).func_230529_a_((ITextComponent)new StringTextComponent(" - ")).func_230529_a_((ITextComponent)genePair.getRecessive().getTooltip());
    }

    public static ITextComponent collect(Stream<ITextComponent> stream, String separator) {
        return stream.collect(AgriToolTips.collector(separator));
    }

    private static Collector<ITextComponent, IFormattableTextComponent, ITextComponent> collector(final String separator) {
        return new Collector<ITextComponent, IFormattableTextComponent, ITextComponent>(){

            @Override
            public Supplier<IFormattableTextComponent> supplier() {
                return () -> new StringTextComponent("");
            }

            @Override
            public BiConsumer<IFormattableTextComponent, ITextComponent> accumulator() {
                return (combined, toAdd) -> {
                    if (!combined.getString().isEmpty()) {
                        combined.func_230529_a_((ITextComponent)new StringTextComponent(separator));
                    }
                    combined.func_230529_a_(toAdd);
                };
            }

            @Override
            public BinaryOperator<IFormattableTextComponent> combiner() {
                return (a, b) -> {
                    if (a.getString().isEmpty()) {
                        return a.func_230529_a_((ITextComponent)new StringTextComponent(separator)).func_230529_a_((ITextComponent)b);
                    }
                    return a.func_230529_a_((ITextComponent)b);
                };
            }

            @Override
            public Function<IFormattableTextComponent, ITextComponent> finisher() {
                return text -> text;
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return ImmutableSet.of();
            }
        };
    }
}

