/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.render.blocks;

import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.content.irrigation.TileEntityIrrigationChannel;
import com.infinityraider.agricraft.content.irrigation.TileEntityIrrigationComponent;
import com.infinityraider.agricraft.content.irrigation.TileEntityIrrigationTank;
import com.infinityraider.agricraft.render.blocks.TileEntityIrrigationComponentRenderer;
import com.infinityraider.infinitylib.render.IRenderUtilities;
import com.infinityraider.infinitylib.render.tessellation.ITessellator;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityIrrigationChannelRenderer
extends TileEntityIrrigationComponentRenderer<TileEntityIrrigationChannel>
implements IRenderUtilities {
    public static final ResourceLocation MODEL_HANDWHEEL = new ResourceLocation(AgriCraft.instance.getModId(), "block/channel/valve_wheel");
    public static final ResourceLocation TEXTURE_VALVE = new ResourceLocation("minecraft", "block/iron_block");
    private IBakedModel handWheelModel;
    private TextureAtlasSprite valveSprite;

    @Override
    protected void renderWater(TileEntityIrrigationChannel tile, float partialTicks, MatrixStack transforms, IRenderTypeBuffer.Impl buffer, int light, int overlay) {
        float level = tile.getRenderLevel(partialTicks) - (float)tile.func_174877_v().func_177956_o();
        float min = tile.getMinLevel() - (float)tile.func_174877_v().func_177956_o();
        level = level == 0.0f ? min : level;
        ITessellator tessellator = this.getTessellator(buffer);
        this.applyWaterColor(tile, tessellator.startDrawingQuads()).setBrightness(light).setOverlay(overlay).pushMatrix();
        tessellator.applyTransformation(transforms.func_227866_c_().func_227870_a_());
        if (tile.getContent() > 0 && tile.isOpen()) {
            tessellator.drawScaledFace(6.0f, 6.0f, 10.0f, 10.0f, Direction.UP, this.getWaterTexture(), 16.0f * level);
        }
        this.drawConnectionNorth(tessellator, tile, partialTicks);
        this.drawConnectionEast(tessellator, tile, partialTicks);
        this.drawConnectionSouth(tessellator, tile, partialTicks);
        this.drawConnectionWest(tessellator, tile, partialTicks);
        if (tile.hasValve() && tile.hasHandWheel()) {
            tessellator.popMatrix().pushMatrix();
            this.renderValveHandWheel(tessellator, tile, transforms, partialTicks);
        }
        tessellator.popMatrix().draw();
    }

    protected void drawConnectionNorth(ITessellator tessellator, TileEntityIrrigationChannel tile, float partialTicks) {
        TileEntityIrrigationComponent component = tile.getNeighbour(Direction.NORTH);
        if (component == null) {
            return;
        }
        float y1 = tile.getRenderLevel(partialTicks) - (float)tile.func_174877_v().func_177956_o();
        float y2 = this.getConnectionLevel(tile, component, partialTicks);
        if (this.dontRenderConnection(tile, component, y2)) {
            return;
        }
        if (tile.isClosed()) {
            y1 = y2;
        }
        float minX = 6.0f;
        float maxX = 10.0f;
        float minZ = 0.0f;
        float maxZ = 6.0f;
        tessellator.addScaledVertexWithUV(maxX, 16.0f * y2, minZ, this.getWaterTexture(), maxX, minZ);
        tessellator.addScaledVertexWithUV(minX, 16.0f * y2, minZ, this.getWaterTexture(), minX, minZ);
        tessellator.addScaledVertexWithUV(minX, 16.0f * y1, maxZ, this.getWaterTexture(), minX, maxZ);
        tessellator.addScaledVertexWithUV(maxX, 16.0f * y1, maxZ, this.getWaterTexture(), maxX, maxZ);
    }

    protected void drawConnectionEast(ITessellator tessellator, TileEntityIrrigationChannel tile, float partialTicks) {
        TileEntityIrrigationComponent component = tile.getNeighbour(Direction.EAST);
        if (component == null) {
            return;
        }
        float y1 = tile.getRenderLevel(partialTicks) - (float)tile.func_174877_v().func_177956_o();
        float y2 = this.getConnectionLevel(tile, component, partialTicks);
        if (this.dontRenderConnection(tile, component, y2)) {
            return;
        }
        if (tile.isClosed()) {
            y1 = y2;
        }
        float minX = 10.0f;
        float maxX = 16.0f;
        float minZ = 6.0f;
        float maxZ = 10.0f;
        tessellator.addScaledVertexWithUV(maxX, 16.0f * y2, minZ, this.getWaterTexture(), maxX, minZ);
        tessellator.addScaledVertexWithUV(minX, 16.0f * y1, minZ, this.getWaterTexture(), minX, minZ);
        tessellator.addScaledVertexWithUV(minX, 16.0f * y1, maxZ, this.getWaterTexture(), minX, maxZ);
        tessellator.addScaledVertexWithUV(maxX, 16.0f * y2, maxZ, this.getWaterTexture(), maxX, maxZ);
    }

    protected void drawConnectionSouth(ITessellator tessellator, TileEntityIrrigationChannel tile, float partialTicks) {
        TileEntityIrrigationComponent component = tile.getNeighbour(Direction.SOUTH);
        if (component == null) {
            return;
        }
        float y1 = tile.getRenderLevel(partialTicks) - (float)tile.func_174877_v().func_177956_o();
        float y2 = this.getConnectionLevel(tile, component, partialTicks);
        if (this.dontRenderConnection(tile, component, y2)) {
            return;
        }
        if (tile.isClosed()) {
            y1 = y2;
        }
        float minX = 6.0f;
        float maxX = 10.0f;
        float minZ = 10.0f;
        float maxZ = 16.0f;
        tessellator.addScaledVertexWithUV(maxX, 16.0f * y1, minZ, this.getWaterTexture(), maxX, minZ);
        tessellator.addScaledVertexWithUV(minX, 16.0f * y1, minZ, this.getWaterTexture(), minX, minZ);
        tessellator.addScaledVertexWithUV(minX, 16.0f * y2, maxZ, this.getWaterTexture(), minX, maxZ);
        tessellator.addScaledVertexWithUV(maxX, 16.0f * y2, maxZ, this.getWaterTexture(), maxX, maxZ);
    }

    protected void drawConnectionWest(ITessellator tessellator, TileEntityIrrigationChannel tile, float partialTicks) {
        TileEntityIrrigationComponent component = tile.getNeighbour(Direction.WEST);
        if (component == null) {
            return;
        }
        float y1 = tile.getRenderLevel(partialTicks) - (float)tile.func_174877_v().func_177956_o();
        float y2 = this.getConnectionLevel(tile, component, partialTicks);
        if (this.dontRenderConnection(tile, component, y2)) {
            return;
        }
        if (tile.isClosed()) {
            y1 = y2;
        }
        float minX = 0.0f;
        float maxX = 6.0f;
        float minZ = 6.0f;
        float maxZ = 10.0f;
        tessellator.addScaledVertexWithUV(maxX, 16.0f * y1, minZ, this.getWaterTexture(), maxX, minZ);
        tessellator.addScaledVertexWithUV(minX, 16.0f * y2, minZ, this.getWaterTexture(), minX, minZ);
        tessellator.addScaledVertexWithUV(minX, 16.0f * y2, maxZ, this.getWaterTexture(), minX, maxZ);
        tessellator.addScaledVertexWithUV(maxX, 16.0f * y1, maxZ, this.getWaterTexture(), maxX, maxZ);
    }

    protected boolean dontRenderConnection(TileEntityIrrigationChannel self, TileEntityIrrigationComponent other, float otherLevel) {
        if (self.getContent() == 0) {
            if (other.getContent() == 0) {
                return true;
            }
            if (other instanceof TileEntityIrrigationChannel) {
                return ((TileEntityIrrigationChannel)other).isClosed();
            }
            return other instanceof TileEntityIrrigationTank && otherLevel < other.getMinLevel();
        }
        return self.isClosed() && other.getContent() == 0;
    }

    protected float getConnectionLevel(TileEntityIrrigationChannel self, TileEntityIrrigationComponent other, float partialTicks) {
        float ownLevel = self.getRenderLevel(partialTicks) - (float)self.func_174877_v().func_177956_o();
        float level = other.getRenderLevel(partialTicks) - (float)other.func_174877_v().func_177956_o();
        float minLevel = self.getMinLevel() - (float)self.func_174877_v().func_177956_o();
        float maxLevel = self.getMaxLevel() - (float)self.func_174877_v().func_177956_o();
        if (other instanceof TileEntityIrrigationChannel) {
            if (((TileEntityIrrigationChannel)other).isOpen()) {
                return (ownLevel + level) / 2.0f;
            }
            return self.isOpen() ? ownLevel : (ownLevel + level) / 2.0f;
        }
        if (other instanceof TileEntityIrrigationTank) {
            return Math.max(minLevel, Math.min(level, maxLevel));
        }
        return ownLevel;
    }

    protected void renderValveHandWheel(ITessellator tessellator, TileEntityIrrigationChannel channel, MatrixStack transforms, float partialTicks) {
        float f = channel.getValveAnimationProgress(partialTicks);
        float minY = MathHelper.func_219799_g((float)f, (float)6.0f, (float)9.0f);
        float maxY = MathHelper.func_219799_g((float)f, (float)10.0f, (float)13.0f);
        tessellator.setColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
        tessellator.applyTransformation(transforms.func_227866_c_().func_227870_a_());
        tessellator.pushMatrix();
        tessellator.drawScaledPrism(6.0f, minY, 6.0f, 10.0f, maxY, 10.0f, this.getValveSprite());
        tessellator.pushMatrix();
        tessellator.translate(0.5f, 0.0f, 0.5f);
        tessellator.rotate(Vector3f.field_229181_d_.func_229187_a_(MathHelper.func_219799_g((float)f, (float)0.0f, (float)180.0f)));
        tessellator.translate(-0.5f, 0.0f, -0.5f);
        tessellator.addQuads(this.getHandWheelModel().getQuads(null, null, channel.getRandom(), (IModelData)EmptyModelData.INSTANCE));
        tessellator.popMatrix();
        tessellator.popMatrix();
    }

    protected IBakedModel getHandWheelModel() {
        if (this.handWheelModel == null) {
            this.handWheelModel = this.getModelManager().getModel(MODEL_HANDWHEEL);
        }
        return this.handWheelModel;
    }

    protected TextureAtlasSprite getValveSprite() {
        if (this.valveSprite == null) {
            this.valveSprite = this.getSprite(TEXTURE_VALVE);
        }
        return this.valveSprite;
    }
}

