/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.render.items;

import com.google.common.collect.Maps;
import com.infinityraider.agricraft.handler.JournalViewPointHandler;
import com.infinityraider.infinitylib.render.IRenderUtilities;
import com.infinityraider.infinitylib.render.item.InfItemRenderer;
import com.infinityraider.infinitylib.render.tessellation.ITessellator;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableFloat;

@OnlyIn(value=Dist.CLIENT)
public class JournalRenderer
implements InfItemRenderer,
JournalViewPointHandler.IPageRenderer,
IRenderUtilities {
    private static final JournalRenderer INSTANCE = new JournalRenderer();
    private static final Vector3f COLOR_COVER = new Vector3f(0.0f, 0.007843138f, 0.64705884f);
    private static final Vector3f COLOR_PAGE = new Vector3f(0.7411765f, 0.7607843f, 0.6862745f);
    private static final Quaternion ROTATION_RIGHT = Vector3f.field_229179_b_.func_229187_a_(90.0f);
    private static final Quaternion ROTATION_LEFT = Vector3f.field_229178_a_.func_229187_a_(90.0f);
    private static final Quaternion ROTATION_180;
    private static final Matrix4f PROJECTION;
    private static final float HEIGHT = 7.0f;
    private static final float WIDTH = 5.0f;
    private static final float T_COVER = 0.5f;
    private static final float T_PAPER = 1.0f;
    private static final float T_TOTAL = 2.0f;
    private static final float OPEN_ANGLE = 75.0f;
    public static final int PAGE_WIDTH = 128;
    public static final int PAGE_HEIGHT = 192;
    private static final float SCALE_WIDTH = 0.25f;
    private static final float SCALE_HEIGHT = 0.375f;
    private final Map<IRenderTypeBuffer.Impl, ThreadLocal<ITessellator>> tessellators = Maps.newConcurrentMap();

    public static JournalRenderer getInstance() {
        return INSTANCE;
    }

    private JournalRenderer() {
    }

    public void render(ItemStack stack, ItemCameraTransforms.TransformType perspective, MatrixStack transforms, IRenderTypeBuffer buffer, int light, int overlay) {
        if (this.renderFull3D(perspective)) {
            if (buffer instanceof IRenderTypeBuffer.Impl) {
                if (JournalViewPointHandler.getInstance().getJournal() == stack) {
                    this.renderJournalOpen(perspective, transforms, (IRenderTypeBuffer.Impl)buffer, light, overlay);
                } else {
                    this.renderJournalClosed(perspective, transforms, (IRenderTypeBuffer.Impl)buffer, light, overlay);
                }
            } else {
                this.renderFlat(stack, perspective, transforms, buffer, light, overlay);
            }
        } else {
            this.renderFlat(stack, perspective, transforms, buffer, light, overlay);
        }
    }

    protected void renderFlat(ItemStack stack, ItemCameraTransforms.TransformType perspective, MatrixStack transforms, IRenderTypeBuffer buffer, int light, int overlay) {
        this.renderItem(stack, perspective, light, overlay, transforms, buffer);
    }

    protected void renderJournalClosed(ItemCameraTransforms.TransformType perspective, MatrixStack transforms, IRenderTypeBuffer.Impl buffer, int light, int overlay) {
        transforms.func_227860_a_();
        this.applyTransformations(perspective, transforms);
        ITessellator tessellator = this.getTessellator(buffer);
        tessellator.startDrawingQuads();
        tessellator.pushMatrix();
        tessellator.applyTransformation(transforms.func_227866_c_().func_227870_a_());
        tessellator.setBrightness(light).setOverlay(overlay);
        tessellator.setColorRGB(COLOR_COVER).drawScaledPrism(0.0f, -1.0f, -7.0f, 5.0f, -0.5f, 0.0f);
        tessellator.setColorRGB(COLOR_PAGE).drawScaledPrism(0.5f, -0.5f, -6.5f, 4.5f, 0.5f, -0.5f);
        tessellator.setColorRGB(COLOR_COVER).drawScaledPrism(0.0f, -0.5f, -7.0f, 0.5f, 0.5f, 0.0f);
        tessellator.setColorRGB(COLOR_COVER).drawScaledPrism(0.0f, 0.5f, -7.0f, 5.0f, 1.0f, 0.0f);
        tessellator.popMatrix();
        tessellator.draw();
        transforms.func_227865_b_();
    }

    protected void renderJournalOpen(ItemCameraTransforms.TransformType perspective, MatrixStack transforms, IRenderTypeBuffer.Impl buffer, int light, int overlay) {
        float openProgress = JournalViewPointHandler.getInstance().getOpeningProgress(this.getPartialTick());
        float flipProgress = JournalViewPointHandler.getInstance().getFlippingProgress(this.getPartialTick());
        transforms.func_227860_a_();
        this.applyTransformations(perspective, transforms);
        if (!perspective.func_241716_a_()) {
            transforms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f * openProgress));
        }
        ITessellator tessellator = this.getTessellator(buffer);
        this.drawOpenBack(tessellator, transforms, openProgress, light, overlay);
        this.drawOpenRight(tessellator, transforms, openProgress, flipProgress, light, overlay);
        this.drawOpenLeft(tessellator, transforms, openProgress, light, overlay);
        this.drawOpenFlipped(tessellator, transforms, flipProgress, light, overlay);
        transforms.func_227865_b_();
    }

    protected void applyTransformations(ItemCameraTransforms.TransformType perspective, MatrixStack transforms) {
        transforms.func_227861_a_(0.5, (double)0.425f, 0.3125);
        if (!perspective.func_241716_a_()) {
            transforms.func_227861_a_(-0.15625, 0.0625, 0.25);
            transforms.func_227863_a_(Vector3f.field_229178_a_.func_229187_a_(-90.0f));
        }
    }

    protected void drawOpenBack(ITessellator tessellator, MatrixStack transforms, float openProgress, int light, int overlay) {
        tessellator.startDrawingQuads().setBrightness(light).setOverlay(overlay).pushMatrix();
        transforms.func_227860_a_();
        transforms.func_227861_a_((double)(-openProgress / 32.0f), 0.0, 0.0);
        tessellator.applyTransformation(transforms.func_227866_c_().func_227870_a_());
        tessellator.setColorRGB(COLOR_COVER).drawScaledPrism(0.0f, -1.0f, -7.0f, 0.5f, 1.0f, 0.0f);
        transforms.func_227865_b_();
        tessellator.popMatrix().draw();
    }

    protected void drawOpenRight(ITessellator tessellator, MatrixStack transforms, float openProgress, float flipProgress, int light, int overlay) {
        tessellator.startDrawingQuads().setBrightness(light).setOverlay(overlay).pushMatrix();
        transforms.func_227860_a_();
        transforms.func_227861_a_(0.03125, 0.0, 0.0);
        transforms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-openProgress * 75.0f));
        transforms.func_227861_a_(-0.03125, 0.0, 0.0);
        tessellator.applyTransformation(transforms.func_227866_c_().func_227870_a_());
        tessellator.setColorRGB(COLOR_COVER).drawScaledPrism(0.0f, -1.0f, -7.0f, 5.0f, -0.5f, 0.0f);
        tessellator.setColorRGB(COLOR_PAGE).drawScaledPrism(0.5f, -0.5f, -6.5f, 4.5f, 0.0f, -0.5f);
        tessellator.popMatrix().draw();
        if (openProgress > 0.0f) {
            transforms.func_227860_a_();
            transforms.func_227861_a_(0.03125, (double)6.25E-7f, -0.40625);
            transforms.func_227863_a_(ROTATION_RIGHT);
            if (flipProgress != 0.0f) {
                JournalViewPointHandler.getInstance().renderFlippedPageRight(this, transforms);
            } else {
                JournalViewPointHandler.getInstance().renderViewedPageRight(this, transforms);
            }
            transforms.func_227865_b_();
        }
        transforms.func_227865_b_();
    }

    protected void drawOpenLeft(ITessellator tessellator, MatrixStack transforms, float openProgress, int light, int overlay) {
        tessellator.startDrawingQuads().setBrightness(light).setOverlay(overlay).pushMatrix();
        transforms.func_227860_a_();
        transforms.func_227861_a_(0.03125, 0.0, 0.0);
        transforms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(openProgress * 75.0f));
        transforms.func_227861_a_(-0.03125, 0.0, 0.0);
        tessellator.applyTransformation(transforms.func_227866_c_().func_227870_a_());
        tessellator.setColorRGB(COLOR_COVER).drawScaledPrism(0.0f, 0.5f, -7.0f, 5.0f, 1.0f, 0.0f);
        tessellator.setColorRGB(COLOR_PAGE).drawScaledPrism(0.5f, 0.0f, -6.5f, 4.5f, 0.5f, -0.5f);
        tessellator.popMatrix().draw();
        if (openProgress > 0.0f) {
            transforms.func_227860_a_();
            transforms.func_227861_a_(0.28125, (double)-6.25E-7f, -0.40625);
            transforms.func_227863_a_(ROTATION_LEFT);
            JournalViewPointHandler.getInstance().renderViewedPageLeft(this, transforms);
            transforms.func_227865_b_();
        }
        transforms.func_227865_b_();
    }

    protected void drawOpenFlipped(ITessellator tessellator, MatrixStack transforms, float flipProgress, int light, int overlay) {
        if (flipProgress != 0.0f) {
            tessellator.startDrawingQuads().setBrightness(light).setOverlay(overlay).pushMatrix();
            transforms.func_227860_a_();
            transforms.func_227861_a_(0.03125, 0.0, 0.0);
            if (flipProgress < 0.0f) {
                transforms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(MathHelper.func_219799_g((float)(-flipProgress), (float)-75.0f, (float)75.0f)));
            } else {
                transforms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(MathHelper.func_219799_g((float)flipProgress, (float)75.0f, (float)-75.0f)));
            }
            transforms.func_227861_a_(-0.03125, 0.0, 0.0);
            tessellator.applyTransformation(transforms.func_227866_c_().func_227870_a_());
            tessellator.setColorRGB(COLOR_PAGE).drawScaledFaceDouble(0.5f, -6.5f, 4.5f, -0.5f, Direction.UP, 0.0f);
            tessellator.popMatrix().draw();
            transforms.func_227860_a_();
            transforms.func_227861_a_(0.03125, (double)6.25E-5f, -0.40625);
            transforms.func_227863_a_(ROTATION_RIGHT);
            JournalViewPointHandler.getInstance().renderViewedPageRight(this, transforms);
            transforms.func_227865_b_();
            transforms.func_227860_a_();
            transforms.func_227861_a_(0.28125, (double)-6.25E-5f, -0.40625);
            transforms.func_227863_a_(ROTATION_LEFT);
            JournalViewPointHandler.getInstance().renderFlippedPageLeft(this, transforms);
            transforms.func_227865_b_();
            transforms.func_227865_b_();
        }
    }

    protected boolean renderFull3D(ItemCameraTransforms.TransformType perspective) {
        return perspective == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND || perspective == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND || perspective == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND || perspective == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND;
    }

    protected ITessellator getTessellator(IRenderTypeBuffer.Impl buffer) {
        return (ITessellator)this.tessellators.computeIfAbsent(buffer, aBuffer -> ThreadLocal.withInitial(() -> this.getVertexBufferTessellator((IRenderTypeBuffer.Impl)aBuffer, this.getRenderType()))).get();
    }

    protected RenderType getRenderType() {
        return PosColorRenderType.INSTANCE;
    }

    @Override
    public int getPageWidth() {
        return 128;
    }

    @Override
    public int getPageHeight() {
        return 192;
    }

    @Override
    public void drawTexture(MatrixStack transforms, ResourceLocation texture, float x, float y, float w, float h, float u1, float v1, float u2, float v2, float c) {
        this.bindTexture(texture);
        this.drawTexture(transforms, x, y, w, h, u1, v1, u2, v2, c);
    }

    @Override
    public void drawTexture(MatrixStack transforms, TextureAtlasSprite texture, float x, float y, float w, float h, float c) {
        this.bindTextureAtlas();
        this.drawTexture(transforms, x, y, w, h, texture.func_94209_e(), texture.func_94206_g(), texture.func_94212_f(), texture.func_94210_h(), c);
    }

    protected void drawTexture(MatrixStack transforms, float x, float y, float w, float h, float u1, float v1, float u2, float v2, float c) {
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        Matrix4f matrix = transforms.func_227866_c_().func_227870_a_();
        float x1 = 0.25f * x / (float)this.getPageWidth();
        float y1 = 0.375f * y / (float)this.getPageHeight();
        float x2 = 0.25f * (x + w) / (float)this.getPageWidth();
        float y2 = 0.375f * (y + h) / (float)this.getPageHeight();
        bufferbuilder.func_227888_a_(matrix, x1, y2, 0.0f).func_225583_a_(u1, v2).func_227885_a_(c, c, c, 1.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, x2, y2, 0.0f).func_225583_a_(u2, v2).func_227885_a_(c, c, c, 1.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, x2, y1, 0.0f).func_225583_a_(u2, v1).func_227885_a_(c, c, c, 1.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, x1, y1, 0.0f).func_225583_a_(u1, v1).func_227885_a_(c, c, c, 1.0f).func_181675_d();
        bufferbuilder.func_178977_d();
        RenderSystem.enableAlphaTest();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
    }

    @Override
    public float drawText(MatrixStack transforms, ITextComponent text, float x, float y, float scale) {
        transforms.func_227860_a_();
        transforms.func_227861_a_((double)(0.25f * x / (float)this.getPageWidth()), (double)(0.375f * y / (float)this.getPageHeight()), 0.0);
        float f = scale * 0.25f / (float)this.getPageWidth();
        transforms.func_227862_a_(f, f, 1.0f);
        int l = (int)(((float)this.getPageWidth() - x - 2.0f) / scale);
        MutableFloat dy = new MutableFloat();
        this.getFontRenderer().func_238425_b_((ITextProperties)text, l).forEach(t -> {
            this.getFontRenderer().func_238422_b_(transforms, t, 0.0f, 0.0f, 0);
            this.getFontRenderer().getClass();
            dy.add(9.0f);
            this.getFontRenderer().getClass();
            transforms.func_227861_a_(0.0, 9.0, 0.0);
        });
        transforms.func_227865_b_();
        return dy.getValue().floatValue() * scale;
    }

    @Override
    public void drawItem(MatrixStack transforms, ItemStack item, float x, float y) {
        transforms.func_227860_a_();
        transforms.func_227861_a_((double)(0.25f * (x + 8.0f) / (float)this.getPageWidth()), (double)(0.375f * (y + 8.0f) / (float)this.getPageHeight()), 0.0);
        transforms.func_227863_a_(ROTATION_180);
        transforms.func_227860_a_();
        float f = 0.03125f;
        transforms.func_227862_a_(f, f, 1.0f);
        transforms.func_227860_a_();
        transforms.func_227866_c_().func_227870_a_().func_226595_a_(PROJECTION);
        this.renderItem(item, ItemCameraTransforms.TransformType.GUI, 0xF000F0, transforms, (IRenderTypeBuffer)this.getRenderTypeBuffer());
        transforms.func_227865_b_();
        transforms.func_227865_b_();
        transforms.func_227865_b_();
    }

    static {
        ROTATION_LEFT.func_195890_a(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        ROTATION_180 = Vector3f.field_229183_f_.func_229187_a_(180.0f);
        PROJECTION = new Matrix4f(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f});
    }

    private static class PosColorRenderType
    extends RenderType {
        private static final RenderType INSTANCE = PosColorRenderType.func_228632_a_((String)"colored_quads", (VertexFormat)DefaultVertexFormats.field_227850_m_, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228723_a_(field_228520_l_).func_228719_a_(field_228528_t_).func_228728_a_(false));

        public PosColorRenderType(String name, VertexFormat format, int i1, int i2, boolean b1, boolean b2, Runnable runnablePre, Runnable runnablePost) {
            super(name, format, i1, i2, b1, b2, runnablePre, runnablePost);
        }
    }
}

