/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.render.models;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.crop.IAgriGrowthStage;
import com.infinityraider.agricraft.api.v1.misc.IAgriRegisterable;
import com.infinityraider.agricraft.api.v1.misc.IAgriRegistry;
import com.infinityraider.agricraft.api.v1.plant.IAgriGrowable;
import com.infinityraider.agricraft.api.v1.plant.IAgriRenderable;
import com.infinityraider.agricraft.impl.v1.plant.AgriPlantRegistry;
import com.infinityraider.agricraft.impl.v1.plant.AgriWeedRegistry;
import com.infinityraider.agricraft.render.models.AgriPlantModelBridge;
import com.infinityraider.infinitylib.render.IRenderUtilities;
import com.infinityraider.infinitylib.render.model.InfModelLoader;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.geometry.IModelGeometry;

@OnlyIn(value=Dist.CLIENT)
public class AgriPlantModelLoader
implements InfModelLoader<Geometry> {
    private static final ResourceLocation ID = new ResourceLocation(AgriCraft.instance.getModId(), "plant_model_loader");
    private static final AgriPlantModelLoader INSTANCE = new AgriPlantModelLoader();
    private final Geometry geometry = new Geometry();

    public static AgriPlantModelLoader getInstance() {
        return INSTANCE;
    }

    private AgriPlantModelLoader() {
    }

    protected Geometry getGeometry() {
        return this.geometry;
    }

    public ResourceLocation getId() {
        return ID;
    }

    public void func_195410_a(@Nonnull IResourceManager resourceManager) {
    }

    @Nonnull
    public Geometry read(@Nonnull JsonDeserializationContext deserializationContext, @Nonnull JsonObject modelContents) {
        return this.getGeometry();
    }

    public static class Geometry
    implements IModelGeometry<Geometry>,
    IRenderUtilities {
        private Geometry() {
        }

        public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
            return new AgriPlantModelBridge(owner, overrides, spriteGetter);
        }

        public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            ImmutableList.Builder builder = new ImmutableList.Builder();
            this.processRegistryTextures(AgriPlantRegistry.getInstance(), rl -> builder.add((Object)new RenderMaterial(this.getTextureAtlasLocation(), rl)));
            this.processRegistryTextures(AgriWeedRegistry.getInstance(), rl -> builder.add((Object)new RenderMaterial(this.getTextureAtlasLocation(), rl)));
            return builder.build();
        }

        protected <T extends IAgriRegisterable<T> & IAgriGrowable> void processRegistryTextures(IAgriRegistry<T> registry, Consumer<ResourceLocation> consumer) {
            registry.all().stream().flatMap(element -> ((IAgriGrowable)((Object)element)).getGrowthStages().stream().flatMap(stage -> ((IAgriRenderable)((Object)element)).getTexturesFor((IAgriGrowthStage)stage).stream())).forEach(consumer);
        }
    }
}

