/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.render.models;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.content.core.ItemDynamicAgriSeed;
import com.infinityraider.agricraft.impl.v1.plant.AgriPlantRegistry;
import com.infinityraider.infinitylib.render.IRenderUtilities;
import com.infinityraider.infinitylib.render.model.InfModelLoader;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.geometry.IModelGeometry;

@OnlyIn(value=Dist.CLIENT)
public class AgriSeedModelLoader
implements InfModelLoader<Geometry> {
    private static final ResourceLocation ID = new ResourceLocation(AgriCraft.instance.getModId(), "seed_model_loader");
    private static final AgriSeedModelLoader INSTANCE = new AgriSeedModelLoader();
    private final Geometry geometry = new Geometry();

    public static AgriSeedModelLoader getInstance() {
        return INSTANCE;
    }

    private AgriSeedModelLoader() {
    }

    protected Geometry getGeometry() {
        return this.geometry;
    }

    public ResourceLocation getId() {
        return ID;
    }

    public void func_195410_a(@Nonnull IResourceManager resourceManager) {
    }

    @Nonnull
    public Geometry read(@Nonnull JsonDeserializationContext deserializationContext, @Nonnull JsonObject modelContents) {
        return this.getGeometry();
    }

    public static class BakedModel
    implements IBakedModel,
    IRenderUtilities {
        private final IModelConfiguration owner;
        private final ItemOverrideList overrides;

        private BakedModel(IModelConfiguration owner, ItemOverrideList overrides) {
            this.owner = owner;
            this.overrides = overrides;
        }

        @Nonnull
        public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand) {
            return ImmutableList.of();
        }

        public boolean func_177555_b() {
            return false;
        }

        public boolean func_177556_c() {
            return true;
        }

        public boolean func_230044_c_() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        @Nonnull
        public TextureAtlasSprite func_177554_e() {
            return this.getMissingSprite();
        }

        @Nonnull
        @Deprecated
        public ItemCameraTransforms func_177552_f() {
            return this.owner.getCameraTransforms();
        }

        @Nonnull
        public ItemOverrideList func_188617_f() {
            return this.overrides;
        }

        public boolean isLayered() {
            return true;
        }

        public List<Pair<IBakedModel, RenderType>> getLayerModels(ItemStack stack, boolean fabulous) {
            return Collections.singletonList(Pair.of((Object)this.getModelManager().getModel(((ItemDynamicAgriSeed)stack.func_77973_b()).getPlant(stack).getSeedModel()), (Object)RenderTypeLookup.func_239219_a_((ItemStack)stack, (boolean)fabulous)));
        }
    }

    public static class Geometry
    implements IModelGeometry<Geometry>,
    IRenderUtilities {
        private Geometry() {
        }

        public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform transforms, ItemOverrideList overrides, ResourceLocation modelLocation) {
            return new BakedModel(owner, overrides);
        }

        public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            ImmutableList.Builder builder = new ImmutableList.Builder();
            AgriPlantRegistry.getInstance().all().stream().map(IAgriPlant::getSeedTexture).forEach(rl -> builder.add((Object)new RenderMaterial(this.getTextureAtlasLocation(), rl)));
            return builder.build();
        }
    }
}

