/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.render.plant;

import com.agricraft.agricore.plant.AgriRenderType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.infinityraider.agricraft.api.v1.client.AgriPlantRenderType;
import com.infinityraider.agricraft.api.v1.client.IAgriPlantQuadGenerator;
import com.infinityraider.agricraft.api.v1.client.PlantQuadBakeEvent;
import com.infinityraider.agricraft.api.v1.crop.IAgriGrowthStage;
import com.infinityraider.agricraft.api.v1.plant.IAgriRenderable;
import com.infinityraider.infinitylib.render.IRenderUtilities;
import com.infinityraider.infinitylib.render.tessellation.ITessellator;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

@OnlyIn(value=Dist.CLIENT)
public class AgriPlantQuadGenerator
implements IAgriPlantQuadGenerator,
IRenderUtilities {
    private static final AgriPlantQuadGenerator INSTANCE = new AgriPlantQuadGenerator();
    private static final EnumMap<AgriRenderType, AgriPlantRenderType> CONVERSION_MAP = Maps.newEnumMap(AgriRenderType.class);
    private final ThreadLocal<ITessellator> tess = ThreadLocal.withInitial(() -> ((AgriPlantQuadGenerator)this).getBakedQuadTessellator());

    public static AgriPlantQuadGenerator getInstance() {
        return INSTANCE;
    }

    private AgriPlantQuadGenerator() {
    }

    public ITessellator getTessellator() {
        return this.tess.get();
    }

    public List<BakedQuad> bakeQuads(IAgriRenderable plant, IAgriGrowthStage stage, @Nullable Direction direction, @Nonnull ResourceLocation texture, int yOffset, AgriRenderType jsonRenderType) {
        if (direction != null) {
            return Collections.emptyList();
        }
        TextureAtlasSprite sprite = this.getSprite(texture);
        AgriPlantRenderType type = CONVERSION_MAP.get((Object)jsonRenderType);
        List<BakedQuad> quads = CONVERSION_MAP.get((Object)jsonRenderType).bakedQuads(null, sprite, yOffset);
        PlantQuadBakeEvent event = new PlantQuadBakeEvent(this, plant, stage, null, texture, sprite, type, yOffset, quads);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getOutputQuads();
    }

    public List<BakedQuad> fetchQuads(@Nonnull ResourceLocation location) {
        ModelLoader loader = ModelLoader.instance();
        if (loader == null) {
            return ImmutableList.of();
        }
        IBakedModel model = loader.getBakedModel(location, (IModelTransform)ModelRotation.X0_Y0, arg_0 -> ((AgriPlantQuadGenerator)this).getSprite(arg_0));
        return model == null ? ImmutableList.of() : model.func_200117_a(null, null, this.getRandom());
    }

    @Override
    @Nonnull
    public List<BakedQuad> bakeQuadsForHashPattern(@Nonnull TextureAtlasSprite sprite, int yOffset) {
        ITessellator tessellator = this.getTessellator();
        tessellator.startDrawingQuads();
        tessellator.setFace((Direction)null);
        tessellator.pushMatrix();
        tessellator.translate(0.0f, (float)yOffset, 0.0f);
        tessellator.drawScaledFaceDouble(0.0f, 0.0f, 16.0f, 16.0f, Direction.NORTH, sprite, 4.0f);
        tessellator.drawScaledFaceDouble(0.0f, 0.0f, 16.0f, 16.0f, Direction.EAST, sprite, 4.0f);
        tessellator.drawScaledFaceDouble(0.0f, 0.0f, 16.0f, 16.0f, Direction.NORTH, sprite, 12.0f);
        tessellator.drawScaledFaceDouble(0.0f, 0.0f, 16.0f, 16.0f, Direction.EAST, sprite, 12.0f);
        tessellator.popMatrix();
        ImmutableList quads = tessellator.getQuads();
        tessellator.draw();
        return quads;
    }

    @Override
    @Nonnull
    public List<BakedQuad> bakeQuadsForCrossPattern(@Nonnull TextureAtlasSprite sprite, int yOffset) {
        ITessellator tessellator = this.getTessellator();
        tessellator.startDrawingQuads();
        tessellator.setFace((Direction)null);
        tessellator.pushMatrix();
        tessellator.translate(0.5f, (float)yOffset, 0.5f);
        tessellator.rotate(45.0f, 0.0f, 1.0f, 0.0f);
        tessellator.translate(-0.5f, 0.0f, -0.5f);
        tessellator.drawScaledFaceDouble(0.0f, 0.0f, 16.0f, 16.0f, Direction.NORTH, sprite, 8.0f);
        tessellator.drawScaledFaceDouble(0.0f, 0.0f, 16.0f, 16.0f, Direction.EAST, sprite, 8.0f);
        tessellator.popMatrix();
        ImmutableList quads = tessellator.getQuads();
        tessellator.draw();
        return quads;
    }

    @Override
    @Nonnull
    public List<BakedQuad> bakeQuadsForPlusPattern(@Nonnull TextureAtlasSprite sprite, int yOffset) {
        ITessellator tessellator = this.getTessellator();
        tessellator.startDrawingQuads();
        tessellator.setFace((Direction)null);
        tessellator.pushMatrix();
        tessellator.translate(0.0f, 12.0f * (float)yOffset / 16.0f, 0.0f);
        tessellator.drawScaledFaceDouble(-2.0f, 0.0f, 10.0f, 12.0f, Direction.NORTH, sprite, 4.001f, 0.0f, 0.0f, 16.0f, 16.0f);
        tessellator.drawScaledFaceDouble(6.0f, 0.0f, 18.0f, 12.0f, Direction.NORTH, sprite, 3.999f, 0.0f, 0.0f, 16.0f, 16.0f);
        tessellator.drawScaledFaceDouble(-2.0f, 0.0f, 10.0f, 12.0f, Direction.EAST, sprite, 4.001f, 0.0f, 0.0f, 16.0f, 16.0f);
        tessellator.drawScaledFaceDouble(6.0f, 0.0f, 18.0f, 12.0f, Direction.EAST, sprite, 3.999f, 0.0f, 0.0f, 16.0f, 16.0f);
        tessellator.drawScaledFaceDouble(-2.0f, 0.0f, 10.0f, 12.0f, Direction.NORTH, sprite, 12.001f, 0.0f, 0.0f, 16.0f, 16.0f);
        tessellator.drawScaledFaceDouble(6.0f, 0.0f, 18.0f, 12.0f, Direction.NORTH, sprite, 11.999f, 0.0f, 0.0f, 16.0f, 16.0f);
        tessellator.drawScaledFaceDouble(-2.0f, 0.0f, 10.0f, 12.0f, Direction.EAST, sprite, 12.001f, 0.0f, 0.0f, 16.0f, 16.0f);
        tessellator.drawScaledFaceDouble(6.0f, 0.0f, 18.0f, 12.0f, Direction.EAST, sprite, 11.999f, 0.0f, 0.0f, 16.0f, 16.0f);
        tessellator.popMatrix();
        ImmutableList quads = tessellator.getQuads();
        tessellator.draw();
        return quads;
    }

    @Override
    @Nonnull
    public List<BakedQuad> bakeQuadsForRhombusPattern(@Nonnull TextureAtlasSprite sprite, int yOffset) {
        ITessellator tessellator = this.getTessellator();
        tessellator.startDrawingQuads();
        tessellator.setFace((Direction)null);
        float d = MathHelper.func_76129_c((float)128.0f);
        tessellator.pushMatrix();
        tessellator.translate(0.0f, d * (float)yOffset / 16.0f, 0.5f);
        tessellator.rotate(45.0f, 0.0f, 1.0f, 0.0f);
        tessellator.drawScaledFaceDouble(0.0f, 0.0f, d, d, Direction.NORTH, sprite, 0.0f);
        tessellator.drawScaledFaceDouble(0.0f, 0.0f, d, d, Direction.NORTH, sprite, d);
        tessellator.drawScaledFaceDouble(0.0f, 0.0f, d, d, Direction.EAST, sprite, 0.0f);
        tessellator.drawScaledFaceDouble(0.0f, 0.0f, d, d, Direction.EAST, sprite, d);
        tessellator.popMatrix();
        ImmutableList quads = tessellator.getQuads();
        tessellator.draw();
        return quads;
    }

    @Override
    @Nonnull
    public List<BakedQuad> bakeQuadsForGourdPattern(@Nonnull TextureAtlasSprite sprite, int yOffset) {
        if (yOffset == 0) {
            return this.bakeQuadsForHashPattern(sprite, yOffset);
        }
        if (yOffset == 1) {
            ITessellator tessellator = this.getTessellator();
            tessellator.startDrawingQuads();
            tessellator.setFace((Direction)null);
            tessellator.pushMatrix();
            tessellator.drawScaledPrism(7.0f, 0.0f, 2.0f, 11.0f, 4.0f, 6.0f, sprite);
            tessellator.drawScaledPrism(10.0f, 0.0f, 7.0f, 14.0f, 4.0f, 11.0f, sprite);
            tessellator.drawScaledPrism(5.0f, 0.0f, 10.0f, 9.0f, 4.0f, 14.0f, sprite);
            tessellator.drawScaledPrism(2.0f, 0.0f, 5.0f, 6.0f, 4.0f, 9.0f, sprite);
            tessellator.popMatrix();
            ImmutableList quads = tessellator.getQuads();
            tessellator.draw();
            return quads;
        }
        return ImmutableList.of();
    }

    static {
        CONVERSION_MAP.put(AgriRenderType.HASH, AgriPlantRenderType.HASH);
        CONVERSION_MAP.put(AgriRenderType.CROSS, AgriPlantRenderType.CROSS);
        CONVERSION_MAP.put(AgriRenderType.PLUS, AgriPlantRenderType.PLUS);
        CONVERSION_MAP.put(AgriRenderType.RHOMBUS, AgriPlantRenderType.RHOMBUS);
        CONVERSION_MAP.put(AgriRenderType.GOURD, AgriPlantRenderType.GOURD);
    }
}

