/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.util;

import com.google.common.base.Preconditions;
import com.infinityraider.infinitylib.utility.MessageUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.LightType;
import net.minecraft.world.World;

public final class LightHelper {
    public static final String[] LIGHT_METHOD_NAMES = new String[]{"getLight(pos)", "getLightValue(pos)", "getLightFromNeighborsFor(SKY  , pos)", "getLightFromNeighborsFor(BLOCK, pos)"};
    public static final int LIGHT_METHOD_COUNT = LIGHT_METHOD_NAMES.length;

    @Nonnull
    public static byte[] getLightData(@Nonnull World world, @Nonnull BlockPos pos) {
        Preconditions.checkNotNull((Object)world);
        Preconditions.checkNotNull((Object)pos);
        byte[] lightData = new byte[LIGHT_METHOD_COUNT];
        lightData[0] = (byte)world.func_201696_r(pos);
        lightData[1] = (byte)world.func_217298_h(pos);
        lightData[2] = (byte)world.func_226658_a_(LightType.SKY, pos);
        lightData[3] = (byte)world.func_226658_a_(LightType.BLOCK, pos);
        return lightData;
    }

    public static void messageLightData(@Nullable PlayerEntity player, @Nonnull byte[] clientLightData, @Nonnull byte[] serverLightData) {
        Preconditions.checkNotNull((Object)clientLightData);
        Preconditions.checkNotNull((Object)serverLightData);
        Preconditions.checkArgument((clientLightData.length == LIGHT_METHOD_COUNT ? 1 : 0) != 0);
        Preconditions.checkArgument((serverLightData.length == LIGHT_METHOD_COUNT ? 1 : 0) != 0);
        MessageUtil.messagePlayer((PlayerEntity)player, (String)"`7==================================================`r", (Object[])new Object[0]);
        MessageUtil.messagePlayer((PlayerEntity)player, (String)"       `eLight Level`r", (Object[])new Object[0]);
        MessageUtil.messagePlayer((PlayerEntity)player, (String)"   Client   `7|`r   Server   `7|`r Method Name", (Object[])new Object[0]);
        MessageUtil.messagePlayer((PlayerEntity)player, (String)"`7--------------------------------------------------`r", (Object[])new Object[0]);
        for (int i = 0; i < LIGHT_METHOD_COUNT; ++i) {
            MessageUtil.messagePlayer((PlayerEntity)player, (String)"     {0}     `7|`r     {1}     `7|`r {2}", (Object[])new Object[]{clientLightData[i], serverLightData[i], LIGHT_METHOD_NAMES[i]});
        }
        MessageUtil.messagePlayer((PlayerEntity)player, (String)"`7==================================================`r", (Object[])new Object[0]);
    }
}

