/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.ambientenvironment;

import com.blamejared.ambientenvironment.OpenSimplexNoise;
import java.util.Random;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="ambientenvironment", name="Ambient Environment", version="1.0.1", clientSideOnly=true, acceptedMinecraftVersions="[1.12.2]")
public class AmbientEnvironment {
    public static OpenSimplexNoise NOISE_GRASS = new OpenSimplexNoise("NOISE_GRASS".hashCode());
    public static OpenSimplexNoise NOISE_WATER = new OpenSimplexNoise("NOISE_WATER".hashCode());
    public static OpenSimplexNoise NOISE_FOLIAGE = new OpenSimplexNoise("NOISE_FOLIAGE".hashCode());

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void onFMLInitialization(FMLInitializationEvent event) {
        BiomeColorHelper.ColorResolver grassColor = BiomeColorHelper.field_180291_a;
        BiomeColorHelper.ColorResolver waterColor = BiomeColorHelper.field_180290_c;
        BiomeColorHelper.ColorResolver foliageColor = BiomeColorHelper.field_180289_b;
        int levels = 2;
        NoiseGeneratorPerlin NOISE_GRASS = new NoiseGeneratorPerlin(new Random("NOISE_GRASS".hashCode()), levels);
        NoiseGeneratorPerlin NOISE_WATER = new NoiseGeneratorPerlin(new Random("NOISE_WATER".hashCode()), levels);
        NoiseGeneratorPerlin NOISE_FOLIAGE = new NoiseGeneratorPerlin(new Random("NOISE_FOLIAGE".hashCode()), levels);
        BiomeColorHelper.field_180291_a = (biome, pos) -> {
            int newColor = grassColor.func_180283_a(biome, pos);
            float scale = 8.0f;
            double value = NOISE_GRASS.func_151601_a((double)((float)pos.func_177958_n() / scale), (double)((float)pos.func_177952_p() / scale));
            double darkness = 0.25;
            value = AmbientEnvironment.curve(0.0, 1.0, AmbientEnvironment.remap(value, -((1 << levels) - 1), (1 << levels) - 1, 0.0, 1.0), 1.0) * darkness;
            return AmbientEnvironment.blend(newColor, 0, (float)value);
        };
        BiomeColorHelper.field_180290_c = (biome, pos) -> {
            int newColor = waterColor.func_180283_a(biome, pos);
            float scale = 16.0f;
            double value = NOISE_WATER.func_151601_a((double)((float)pos.func_177958_n() / scale), (double)((float)pos.func_177952_p() / scale));
            double darkness = 0.3f;
            value = AmbientEnvironment.curve(0.0, 1.0, AmbientEnvironment.remap(value, -((1 << levels) - 1), (1 << levels) - 1, 0.0, 1.0), 1.0) * darkness;
            return AmbientEnvironment.blend(newColor, 0, (float)value);
        };
        BiomeColorHelper.field_180289_b = (biome, pos) -> {
            int newColor = foliageColor.func_180283_a(biome, pos);
            float scale = 8.0f;
            double value = NOISE_FOLIAGE.func_151601_a((double)((float)pos.func_177958_n() / scale), (double)((float)pos.func_177952_p() / scale));
            double darkness = 1.0;
            value = AmbientEnvironment.curve(0.0, 1.0, AmbientEnvironment.remap(value, -((1 << levels) - 1), (1 << levels) - 1, 0.0, 1.0), 1.0) * darkness;
            return AmbientEnvironment.blend(newColor, 0, (float)value);
        };
    }

    public static double remap(double value, double currentLow, double currentHigh, double newLow, double newHigh) {
        return newLow + (value - currentLow) * (newHigh - newLow) / (currentHigh - currentLow);
    }

    private static float getRed(int hex) {
        return (float)(hex >> 16 & 0xFF) / 255.0f;
    }

    private static float getGreen(int hex) {
        return (float)(hex >> 8 & 0xFF) / 255.0f;
    }

    private static float getBlue(int hex) {
        return (float)(hex & 0xFF) / 255.0f;
    }

    private static float getAlpha(int hex) {
        return (float)(hex >> 24 & 0xFF) / 255.0f;
    }

    private static float[] getARGB(int hex) {
        return new float[]{AmbientEnvironment.getAlpha(hex), AmbientEnvironment.getRed(hex), AmbientEnvironment.getGreen(hex), AmbientEnvironment.getBlue(hex)};
    }

    private static int toInt(float[] argb) {
        int r = (int)Math.floor(argb[1] * 255.0f) & 0xFF;
        int g = (int)Math.floor(argb[2] * 255.0f) & 0xFF;
        int b = (int)Math.floor(argb[3] * 255.0f) & 0xFF;
        int a = (int)Math.floor(argb[0] * 255.0f) & 0xFF;
        return (a << 24) + (r << 16) + (g << 8) + b;
    }

    public static double clamp(double value, double min, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double curve(double start, double end, double amount, double waves) {
        amount = AmbientEnvironment.clamp(amount, 0.0, 1.0);
        amount = AmbientEnvironment.clamp((amount - start) / (end - start), 0.0, 1.0);
        return AmbientEnvironment.clamp(0.5 + 0.5 * Math.sin(Math.cos(Math.PI * Math.tan(90.0 * amount))) * Math.cos(Math.sin(Math.tan(amount))), 0.0, 1.0);
    }

    public static int blend(int color1, int color2, float ratio) {
        float ir = 1.0f - ratio;
        float[] rgb1 = AmbientEnvironment.getARGB(color2);
        float[] rgb2 = AmbientEnvironment.getARGB(color1);
        return AmbientEnvironment.toInt(new float[]{rgb1[0] * ratio + rgb2[0] * ir, rgb1[1] * ratio + rgb2[1] * ir, rgb1[2] * ratio + rgb2[2] * ir, rgb1[3] * ratio + rgb2[3] * ir});
    }
}

