/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.ambientenvironment;

import com.blamejared.ambientenvironment.mixin.BiomeColorsAccessor;
import java.util.stream.IntStream;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1163;
import net.minecraft.class_3543;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.world.level.ColorResolver;

@Environment(value=EnvType.CLIENT)
public class AmbientEnvironment
implements ClientModInitializer {
    public void onInitializeClient() {
        ColorResolver grassColor = class_1163.field_5665;
        ColorResolver waterColor = class_1163.field_5666;
        int levels = 2;
        class_3543 NOISE_GRASS = new class_3543((class_5819)new class_5820((long)"NOISE_GRASS".hashCode()), IntStream.rangeClosed(0, 2));
        class_3543 NOISE_WATER = new class_3543((class_5819)new class_5820((long)"NOISE_WATER".hashCode()), IntStream.rangeClosed(0, 2));
        BiomeColorsAccessor.setGrassColorResolver((biome, posX, posZ) -> {
            int newColor = grassColor.getColor(biome, posX, posZ);
            float scale = 8.0f;
            double value = NOISE_GRASS.method_16451(posX / 8.0, posZ / 8.0, false);
            float darkness = 0.25f;
            value = AmbientEnvironment.curve(0.0, 1.0, AmbientEnvironment.remap(value, -3.0, 3.0, 0.0, 1.0)) * 0.25;
            return AmbientEnvironment.blend(newColor, 0, (float)value);
        });
        BiomeColorsAccessor.setWaterColorResolver((biome, posX, posZ) -> {
            int newColor = waterColor.getColor(biome, posX, posZ);
            float scale = 16.0f;
            double value = NOISE_WATER.method_16451(posX / 16.0, posZ / 16.0, false);
            float darkness = 0.3f;
            value = AmbientEnvironment.curve(0.0, 1.0, AmbientEnvironment.remap(value, -3.0, 3.0, 0.0, 1.0)) * (double)0.3f;
            return AmbientEnvironment.blend(newColor, 0, (float)value);
        });
    }

    public static double remap(double value, double currentLow, double currentHigh, double newLow, double newHigh) {
        return newLow + (value - currentLow) * (newHigh - newLow) / (currentHigh - currentLow);
    }

    private static float getRed(int hex) {
        return (float)(hex >> 16 & 0xFF) / 255.0f;
    }

    private static float getGreen(int hex) {
        return (float)(hex >> 8 & 0xFF) / 255.0f;
    }

    private static float getBlue(int hex) {
        return (float)(hex & 0xFF) / 255.0f;
    }

    private static float getAlpha(int hex) {
        return (float)(hex >> 24 & 0xFF) / 255.0f;
    }

    private static float[] getARGB(int hex) {
        return new float[]{AmbientEnvironment.getAlpha(hex), AmbientEnvironment.getRed(hex), AmbientEnvironment.getGreen(hex), AmbientEnvironment.getBlue(hex)};
    }

    private static int toInt(float[] argb) {
        int r = (int)Math.floor(argb[1] * 255.0f) & 0xFF;
        int g = (int)Math.floor(argb[2] * 255.0f) & 0xFF;
        int b = (int)Math.floor(argb[3] * 255.0f) & 0xFF;
        int a = (int)Math.floor(argb[0] * 255.0f) & 0xFF;
        return (a << 24) + (r << 16) + (g << 8) + b;
    }

    public static double clamp(double value, double min, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double curve(double start, double end, double amount) {
        amount = AmbientEnvironment.clamp(amount, 0.0, 1.0);
        amount = AmbientEnvironment.clamp((amount - start) / (end - start), 0.0, 1.0);
        return AmbientEnvironment.clamp(0.5 + 0.5 * Math.sin(Math.cos(Math.PI * Math.tan(90.0 * amount))) * Math.cos(Math.sin(Math.tan(amount))), 0.0, 1.0);
    }

    public static int blend(int color1, int color2, float ratio) {
        float ir = 1.0f - ratio;
        float[] rgb1 = AmbientEnvironment.getARGB(color2);
        float[] rgb2 = AmbientEnvironment.getARGB(color1);
        return AmbientEnvironment.toInt(new float[]{rgb1[0] * ratio + rgb2[0] * ir, rgb1[1] * ratio + rgb2[1] * ir, rgb1[2] * ratio + rgb2[2] * ir, rgb1[3] * ratio + rgb2[3] * ir});
    }
}

