/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.ambientenvironment;

import java.util.stream.IntStream;
import net.minecraft.Util;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.SimpleRandomSource;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;

public class AmbientEnvironmentCommon {
    public static final int NOISE_OCTAVES = 2;
    public static final PerlinSimplexNoise GRASS_NOISE = new PerlinSimplexNoise((RandomSource)new SimpleRandomSource((long)"NOISE_GRASS".hashCode()), IntStream.rangeClosed(0, 2));
    public static final PerlinSimplexNoise WATER_NOISE = new PerlinSimplexNoise((RandomSource)new SimpleRandomSource((long)"NOISE_WATER".hashCode()), IntStream.rangeClosed(0, 2));
    public static final ColorResolver GRASS_RESOLVER = (ColorResolver)Util.m_137537_(() -> {
        ColorResolver baseResolver = BiomeColors.f_108789_;
        return (biome, x, z) -> AmbientEnvironmentCommon.modifyColour(GRASS_NOISE, baseResolver, biome, x, z, 8.0, 0.25);
    });
    public static final ColorResolver WATER_RESOLVER = (ColorResolver)Util.m_137537_(() -> {
        ColorResolver baseResolver = BiomeColors.f_108791_;
        return (biome, x, z) -> AmbientEnvironmentCommon.modifyColour(WATER_NOISE, baseResolver, biome, x, z, 16.0, 0.3f);
    });

    private static int modifyColour(PerlinSimplexNoise generator, ColorResolver resolver, Biome biome, double x, double z, double scale, double darkness) {
        int base = resolver.m_130045_(biome, x, z);
        double value = generator.m_75449_(x / scale, z / scale, false);
        value = AmbientEnvironmentCommon.curve(0.0, 1.0, AmbientEnvironmentCommon.remap(value, -3.0, 3.0, 0.0, 1.0)) * darkness;
        return AmbientEnvironmentCommon.blend(base, 0, (float)value);
    }

    public static double remap(double value, double currentLow, double currentHigh, double newLow, double newHigh) {
        return newLow + (value - currentLow) * (newHigh - newLow) / (currentHigh - currentLow);
    }

    private static float getRed(int hex) {
        return (float)(hex >> 16 & 0xFF) / 255.0f;
    }

    private static float getGreen(int hex) {
        return (float)(hex >> 8 & 0xFF) / 255.0f;
    }

    private static float getBlue(int hex) {
        return (float)(hex & 0xFF) / 255.0f;
    }

    private static float getAlpha(int hex) {
        return (float)(hex >> 24 & 0xFF) / 255.0f;
    }

    private static float[] getARGB(int hex) {
        return new float[]{AmbientEnvironmentCommon.getAlpha(hex), AmbientEnvironmentCommon.getRed(hex), AmbientEnvironmentCommon.getGreen(hex), AmbientEnvironmentCommon.getBlue(hex)};
    }

    private static int toInt(float[] argb) {
        int r = (int)Math.floor(argb[1] * 255.0f) & 0xFF;
        int g = (int)Math.floor(argb[2] * 255.0f) & 0xFF;
        int b = (int)Math.floor(argb[3] * 255.0f) & 0xFF;
        int a = (int)Math.floor(argb[0] * 255.0f) & 0xFF;
        return (a << 24) + (r << 16) + (g << 8) + b;
    }

    public static double curve(double start, double end, double amount) {
        amount = Mth.m_14008_((double)amount, (double)0.0, (double)1.0);
        amount = Mth.m_14008_((double)((amount - start) / (end - start)), (double)0.0, (double)1.0);
        return Mth.m_14008_((double)(0.5 + 0.5 * Math.sin(Math.cos(Math.PI * Math.tan(90.0 * amount))) * Math.cos(Math.sin(Math.tan(amount)))), (double)0.0, (double)1.0);
    }

    public static int blend(int color1, int color2, float ratio) {
        float ir = 1.0f - ratio;
        float[] rgb1 = AmbientEnvironmentCommon.getARGB(color2);
        float[] rgb2 = AmbientEnvironmentCommon.getARGB(color1);
        return AmbientEnvironmentCommon.toInt(new float[]{rgb1[0] * ratio + rgb2[0] * ir, rgb1[1] * ratio + rgb2[1] * ir, rgb1[2] * ratio + rgb2[2] * ir, rgb1[3] * ratio + rgb2[3] * ir});
    }
}

