/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.arfo.common.blocks;

import com.finallion.arfo.common.blocks.ARFOGlowingGrassBlock;
import com.finallion.arfo.common.blocks.ARFOSpreadableGrassBlock;
import com.finallion.arfo.common.blocks.ARFOSpreadableNetherrackBlock;
import com.finallion.arfo.common.blocks.ARFOSpreadableStoneBlock;
import com.finallion.arfo.init.ARFOBlocks;
import com.finallion.arfo.utils.BlockMapping;
import com.finallion.arfo.utils.MapUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.SpreadableSnowyDirtBlock;
import net.minecraft.fluid.FluidState;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.lighting.LightEngine;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.Tags;

public class ARFOSpreadableBlock
extends SpreadableSnowyDirtBlock
implements IGrowable {
    public static final EnumProperty<DoubleBlockHalf> HALF;
    public static final EnumProperty<SlabType> TYPE;
    public static final BooleanProperty SNOWY;
    public static final BooleanProperty WATERLOGGED;
    private static final Map<Block, List<Block>> grassFeatures;

    protected ARFOSpreadableBlock(AbstractBlock.Properties p_i48324_1_) {
        super(p_i48324_1_);
    }

    public boolean func_176473_a(IBlockReader world, BlockPos p_176473_2_, BlockState state, boolean p_176473_4_) {
        if (state.func_177230_c().func_235332_a_(ARFOBlocks.ALPHA_GRASS_BLOCK)) {
            return false;
        }
        return world.func_180495_p(p_176473_2_.func_177984_a()).func_196958_f();
    }

    public boolean func_180670_a(World p_180670_1_, Random p_180670_2_, BlockPos p_180670_3_, BlockState state) {
        return !state.func_177230_c().func_235332_a_(ARFOBlocks.ALPHA_GRASS_BLOCK);
    }

    public void func_225535_a_(ServerWorld world, Random random, BlockPos pos, BlockState state) {
        BlockPos blockPos = pos.func_177984_a();
        BlockState blockState = world.func_180495_p(pos);
        BlockState failState = Blocks.field_150350_a.func_176223_P();
        MapUtils.initMap(grassFeatures);
        boolean large = false;
        List<Object> features = new ArrayList();
        for (Block b2 : grassFeatures.keySet()) {
            if (!blockState.func_177230_c().func_235332_a_(b2)) continue;
            features = grassFeatures.get(b2);
        }
        block1: for (int i = 0; i < 128; ++i) {
            BlockPos blockPos2 = blockPos;
            for (int j = 0; j < i / 16; ++j) {
                if (!(world.func_180495_p((blockPos2 = blockPos2.func_177982_a(random.nextInt(3) - 1, (random.nextInt(3) - 1) * random.nextInt(3) / 2, random.nextInt(3) - 1)).func_177977_b()).func_177230_c() instanceof ARFOSpreadableBlock) || world.func_180495_p(blockPos2).func_235785_r_((IBlockReader)world, blockPos2)) continue block1;
            }
            BlockState blockState2 = world.func_180495_p(blockPos2);
            if (blockState2.func_177230_c() instanceof ARFOSpreadableBlock && random.nextInt(10) == 0) {
                ((ARFOSpreadableBlock)blockState.func_177230_c()).func_225535_a_(world, random, blockPos2, blockState2);
            }
            if (blockState2.func_177230_c() instanceof ARFOSpreadableBlock && random.nextInt(10) == 0 && blockState2.func_177229_b(TYPE) != SlabType.BOTTOM) {
                ((ARFOSpreadableBlock)blockState.func_177230_c()).func_225535_a_(world, random, blockPos2, blockState2);
            }
            if (!blockState2.func_203425_a(Blocks.field_150350_a)) continue;
            BlockState blockState4 = failState;
            int rand = random.nextInt(80);
            if (rand < 10) {
                blockState4 = ((Block)features.get(0)).func_176223_P();
            } else if (rand < 30) {
                blockState4 = ((Block)features.get(1)).func_176223_P();
            } else if (rand < 35) {
                if (world.func_180495_p(blockPos2.func_177984_a()).func_203425_a(Blocks.field_150350_a)) {
                    blockState4 = (BlockState)((Block)features.get(2)).func_176223_P().func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER);
                    large = true;
                }
            } else if (rand < 40) {
                if (world.func_180495_p(blockPos2.func_177984_a()).func_203425_a(Blocks.field_150350_a)) {
                    blockState4 = (BlockState)((Block)features.get(3)).func_176223_P().func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER);
                    large = true;
                }
            } else if (rand < 45) {
                blockState4 = ((Block)features.get(random.nextInt(features.size() / 2) + 4)).func_176223_P();
            }
            if (!blockState4.func_196955_c((IWorldReader)world, blockPos2)) continue;
            world.func_180501_a(blockPos2, blockState4, 3);
            if (large) {
                world.func_180501_a(blockPos2.func_177984_a(), (BlockState)blockState4.func_177230_c().func_176223_P().func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
            }
            large = false;
        }
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (!ARFOSpreadableBlock.canBeGrass(state, (IWorldReader)world, pos)) {
            ARFOSpreadableBlock.setToDirt((World)world, pos);
        } else {
            ARFOSpreadableBlock.doTick(state, world, pos, random);
        }
    }

    public static void setToDirt(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof ARFOSpreadableGrassBlock || block instanceof ARFOGlowingGrassBlock) {
            world.func_180501_a(pos, ARFOBlocks.ARTIFICIAL_SOIL.func_176223_P(), 3);
        } else if (block instanceof ARFOSpreadableStoneBlock) {
            world.func_180501_a(pos, ARFOBlocks.ARTIFICIAL_STONE_SOIL.func_176223_P(), 3);
        } else if (block instanceof ARFOSpreadableNetherrackBlock) {
            world.func_180501_a(pos, Blocks.field_150424_aL.func_176223_P(), 3);
        } else {
            world.func_180501_a(pos, Blocks.field_150346_d.func_176223_P(), 3);
        }
    }

    public static void doTick(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (ARFOSpreadableBlock.canBeGrass(state, (IWorldReader)world, pos)) {
            for (int i = 0; i < 4; ++i) {
                BlockState matchingSlab;
                BlockPos newPos = pos.func_177982_a(random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1);
                BlockState newState = world.func_180495_p(newPos);
                if (!ARFOSpreadableBlock.canPropagate(state, (IWorldReader)world, newPos)) continue;
                if (newState.func_203425_a(ARFOBlocks.ARTIFICIAL_SOIL)) {
                    if (!(state.func_177230_c() instanceof ARFOSpreadableGrassBlock) && !(state.func_177230_c() instanceof ARFOGlowingGrassBlock) || world.func_180495_p(newPos.func_177984_a()).func_185904_a().func_76220_a()) continue;
                    world.func_180501_a(newPos, state.getBlockState(), 3);
                    continue;
                }
                if (newState.func_203425_a(ARFOBlocks.ARTIFICIAL_SOIL_SLAB)) {
                    matchingSlab = newState;
                    if (!(state.func_177230_c() instanceof ARFOSpreadableGrassBlock) && !(state.func_177230_c() instanceof ARFOGlowingGrassBlock) || state.func_177230_c().func_235332_a_(ARFOBlocks.ALPHA_GRASS_BLOCK)) continue;
                    for (Block b : BlockMapping.slabAndBlocks.keySet()) {
                        if (b != state.func_177230_c()) continue;
                        matchingSlab = BlockMapping.slabAndBlocks.get(b).func_176223_P();
                    }
                    if (world.func_180495_p(newPos.func_177984_a()).func_185904_a().func_76220_a()) continue;
                    if (newState.func_177229_b(TYPE) == SlabType.BOTTOM) {
                        if (((Boolean)newState.func_177229_b((Property)WATERLOGGED)).booleanValue()) continue;
                        world.func_180501_a(newPos, (BlockState)((BlockState)((BlockState)matchingSlab.func_206870_a(TYPE, newState.func_177229_b((Property)SlabBlock.field_196505_a))).func_206870_a((Property)SNOWY, (Comparable)Boolean.valueOf(world.func_180495_p(newPos.func_177984_a()).func_203425_a(Blocks.field_150433_aE)))).func_206870_a((Property)SlabBlock.field_204512_b, newState.func_177229_b((Property)SlabBlock.field_204512_b)), 3);
                        continue;
                    }
                    world.func_180501_a(newPos, (BlockState)((BlockState)((BlockState)matchingSlab.func_206870_a(TYPE, newState.func_177229_b((Property)SlabBlock.field_196505_a))).func_206870_a((Property)SNOWY, (Comparable)Boolean.valueOf(world.func_180495_p(newPos.func_177984_a()).func_203425_a(Blocks.field_150433_aE)))).func_206870_a((Property)SlabBlock.field_204512_b, newState.func_177229_b((Property)SlabBlock.field_204512_b)), 3);
                    continue;
                }
                if (newState.func_203425_a(ARFOBlocks.ARTIFICIAL_STONE_SOIL)) {
                    if (!(state.func_177230_c() instanceof ARFOSpreadableStoneBlock) || world.func_180495_p(newPos.func_177984_a()).func_185904_a().func_76220_a()) continue;
                    world.func_180501_a(newPos, state.getBlockState(), 3);
                    continue;
                }
                if (newState.func_203425_a(ARFOBlocks.ARTIFICIAL_STONE_SOIL_SLAB)) {
                    matchingSlab = newState;
                    if (!(state.func_177230_c() instanceof ARFOSpreadableStoneBlock)) continue;
                    for (Block b : BlockMapping.slabAndBlocks.keySet()) {
                        if (b != state.func_177230_c()) continue;
                        matchingSlab = BlockMapping.slabAndBlocks.get(b).func_176223_P();
                    }
                    if (world.func_180495_p(newPos.func_177984_a()).func_185904_a().func_76220_a()) continue;
                    if (newState.func_177229_b(TYPE) == SlabType.BOTTOM) {
                        if (((Boolean)newState.func_177229_b((Property)WATERLOGGED)).booleanValue()) continue;
                        world.func_180501_a(newPos, (BlockState)((BlockState)((BlockState)matchingSlab.func_206870_a(TYPE, newState.func_177229_b((Property)SlabBlock.field_196505_a))).func_206870_a((Property)SNOWY, (Comparable)Boolean.valueOf(world.func_180495_p(newPos.func_177984_a()).func_203425_a(Blocks.field_150433_aE)))).func_206870_a((Property)SlabBlock.field_204512_b, newState.func_177229_b((Property)SlabBlock.field_204512_b)), 3);
                        continue;
                    }
                    world.func_180501_a(newPos, (BlockState)((BlockState)((BlockState)matchingSlab.func_206870_a(TYPE, newState.func_177229_b((Property)SlabBlock.field_196505_a))).func_206870_a((Property)SNOWY, (Comparable)Boolean.valueOf(world.func_180495_p(newPos.func_177984_a()).func_203425_a(Blocks.field_150433_aE)))).func_206870_a((Property)SlabBlock.field_204512_b, newState.func_177229_b((Property)SlabBlock.field_204512_b)), 3);
                    continue;
                }
                if (newState.func_203425_a(Blocks.field_150424_aL)) {
                    if (!(state.func_177230_c() instanceof ARFOSpreadableNetherrackBlock) || world.func_180495_p(newPos.func_177984_a()).func_185904_a().func_76220_a()) continue;
                    world.func_180501_a(newPos, state.getBlockState(), 3);
                    continue;
                }
                if (newState.func_203425_a(ARFOBlocks.NETHERRACK_SLAB)) {
                    matchingSlab = newState;
                    if (!(state.func_177230_c() instanceof ARFOSpreadableNetherrackBlock)) continue;
                    for (Block b : BlockMapping.slabAndBlocks.keySet()) {
                        if (b != state.func_177230_c()) continue;
                        matchingSlab = BlockMapping.slabAndBlocks.get(b).func_176223_P();
                    }
                    if (world.func_180495_p(newPos.func_177984_a()).func_185904_a().func_76220_a()) continue;
                    if (newState.func_177229_b(TYPE) == SlabType.BOTTOM) {
                        if (((Boolean)newState.func_177229_b((Property)WATERLOGGED)).booleanValue()) continue;
                        world.func_180501_a(newPos, (BlockState)((BlockState)((BlockState)matchingSlab.func_206870_a(TYPE, newState.func_177229_b((Property)SlabBlock.field_196505_a))).func_206870_a((Property)SNOWY, (Comparable)Boolean.valueOf(world.func_180495_p(newPos.func_177984_a()).func_203425_a(Blocks.field_150433_aE)))).func_206870_a((Property)SlabBlock.field_204512_b, newState.func_177229_b((Property)SlabBlock.field_204512_b)), 3);
                        continue;
                    }
                    world.func_180501_a(newPos, (BlockState)((BlockState)((BlockState)matchingSlab.func_206870_a(TYPE, newState.func_177229_b((Property)SlabBlock.field_196505_a))).func_206870_a((Property)SNOWY, (Comparable)Boolean.valueOf(world.func_180495_p(newPos.func_177984_a()).func_203425_a(Blocks.field_150433_aE)))).func_206870_a((Property)SlabBlock.field_204512_b, newState.func_177229_b((Property)SlabBlock.field_204512_b)), 3);
                    continue;
                }
                if (!newState.func_203425_a(ARFOBlocks.DIRT_SLAB)) continue;
                if (state.func_177230_c().func_235332_a_(Blocks.field_196658_i)) {
                    matchingSlab = ARFOBlocks.GRASS_SLAB.func_176223_P();
                    if (world.func_180495_p(newPos.func_177984_a()).func_185904_a().func_76220_a()) continue;
                    if (newState.func_177229_b(TYPE) == SlabType.BOTTOM) {
                        if (((Boolean)newState.func_177229_b((Property)WATERLOGGED)).booleanValue()) continue;
                        world.func_180501_a(newPos, (BlockState)((BlockState)((BlockState)matchingSlab.func_206870_a(TYPE, newState.func_177229_b((Property)SlabBlock.field_196505_a))).func_206870_a((Property)SNOWY, (Comparable)Boolean.valueOf(world.func_180495_p(newPos.func_177984_a()).func_203425_a(Blocks.field_150433_aE)))).func_206870_a((Property)SlabBlock.field_204512_b, newState.func_177229_b((Property)SlabBlock.field_204512_b)), 3);
                        continue;
                    }
                    world.func_180501_a(newPos, (BlockState)((BlockState)((BlockState)matchingSlab.func_206870_a(TYPE, newState.func_177229_b((Property)SlabBlock.field_196505_a))).func_206870_a((Property)SNOWY, (Comparable)Boolean.valueOf(world.func_180495_p(newPos.func_177984_a()).func_203425_a(Blocks.field_150433_aE)))).func_206870_a((Property)SlabBlock.field_204512_b, newState.func_177229_b((Property)SlabBlock.field_204512_b)), 3);
                    continue;
                }
                if (!state.func_177230_c().func_235332_a_(Blocks.field_150391_bh)) continue;
                matchingSlab = ARFOBlocks.MYCELIUM_SLAB.func_176223_P();
                if (world.func_180495_p(newPos.func_177984_a()).func_185904_a().func_76220_a()) continue;
                if (newState.func_177229_b(TYPE) == SlabType.BOTTOM) {
                    if (((Boolean)newState.func_177229_b((Property)WATERLOGGED)).booleanValue()) continue;
                    world.func_180501_a(newPos, (BlockState)((BlockState)((BlockState)matchingSlab.func_206870_a(TYPE, newState.func_177229_b((Property)SlabBlock.field_196505_a))).func_206870_a((Property)SNOWY, (Comparable)Boolean.valueOf(world.func_180495_p(newPos.func_177984_a()).func_203425_a(Blocks.field_150433_aE)))).func_206870_a((Property)SlabBlock.field_204512_b, newState.func_177229_b((Property)SlabBlock.field_204512_b)), 3);
                    continue;
                }
                world.func_180501_a(newPos, (BlockState)((BlockState)((BlockState)matchingSlab.func_206870_a(TYPE, newState.func_177229_b((Property)SlabBlock.field_196505_a))).func_206870_a((Property)SNOWY, (Comparable)Boolean.valueOf(world.func_180495_p(newPos.func_177984_a()).func_203425_a(Blocks.field_150433_aE)))).func_206870_a((Property)SlabBlock.field_204512_b, newState.func_177229_b((Property)SlabBlock.field_204512_b)), 3);
            }
        }
    }

    private static boolean canBeGrass(BlockState state, IWorldReader worldView, BlockPos pos) {
        BlockPos blockPos = pos.func_177984_a();
        BlockState blockState = worldView.func_180495_p(blockPos);
        if (blockState.func_203425_a(Blocks.field_150433_aE) && (Integer)blockState.func_177229_b((Property)SnowBlock.field_176315_a) >= 1) {
            return false;
        }
        if (blockState.func_204520_s().func_206882_g() == 8) {
            return false;
        }
        int i = LightEngine.func_215613_a((IBlockReader)worldView, (BlockState)state, (BlockPos)pos, (BlockState)blockState, (BlockPos)blockPos, (Direction)Direction.UP, (int)blockState.func_200016_a((IBlockReader)worldView, blockPos));
        return i < worldView.func_201572_C();
    }

    private static boolean canPropagate(BlockState state, IWorldReader worldView, BlockPos pos) {
        BlockPos blockPos = pos.func_177984_a();
        return ARFOSpreadableBlock.canBeGrass(state, worldView, pos) && !worldView.func_204610_c(blockPos).func_206884_a((ITag)FluidTags.field_206959_a);
    }

    public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction facing, IPlantable plantable) {
        PlantType type = plantable.getPlantType(world, pos.func_177972_a(facing));
        if (plantable instanceof BushBlock) {
            return true;
        }
        if (PlantType.CAVE.equals(type)) {
            return state.func_224755_d(world, pos, Direction.UP);
        }
        if (PlantType.PLAINS.equals(type)) {
            return this.getBlock() == this;
        }
        if (PlantType.BEACH.equals(type)) {
            boolean isBeach = state.func_203425_a((Block)this) || Tags.Blocks.DIRT.func_230235_a_((Object)this) || state.func_203425_a(Blocks.field_150354_m) || state.func_203425_a(Blocks.field_196611_F);
            boolean hasWater = false;
            for (Direction face : Direction.Plane.HORIZONTAL) {
                BlockState blockState = world.func_180495_p(pos.func_177972_a(face));
                FluidState fluidState = world.func_204610_c(pos.func_177972_a(face));
                hasWater |= blockState.func_203425_a(Blocks.field_185778_de);
                if (!(hasWater |= fluidState.func_206884_a((ITag)FluidTags.field_206959_a))) continue;
                break;
            }
            return isBeach && hasWater;
        }
        return false;
    }

    static {
        grassFeatures = new HashMap<Block, List<Block>>();
        TYPE = BlockStateProperties.field_208145_at;
        HALF = BlockStateProperties.field_208163_P;
        SNOWY = BlockStateProperties.field_208196_w;
        WATERLOGGED = BlockStateProperties.field_208198_y;
    }
}

