/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.arfo.common.blocks;

import com.finallion.arfo.common.blocks.ARFOFernBlock;
import com.finallion.arfo.common.blocks.ARFOGrass;
import com.finallion.arfo.common.blocks.ARFOLargeFernBlock;
import com.finallion.arfo.common.blocks.ARFOLeavesCarpetBlock;
import com.finallion.arfo.common.blocks.ARFOSpreadableBlock;
import com.finallion.arfo.common.blocks.ARFOSpreadableGrassSlab;
import com.finallion.arfo.common.blocks.ARFOSpreadableNetherrackSlab;
import com.finallion.arfo.common.blocks.ARFOSpreadableStoneSlab;
import com.finallion.arfo.common.blocks.ARFOTallGrass;
import com.finallion.arfo.compat.BYG.BYGBlocks;
import com.finallion.arfo.init.ARFOBlocks;
import com.finallion.arfo.utils.BlockMapping;
import com.finallion.arfo.utils.MapUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.MushroomBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SnowBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.lighting.LightEngine;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolType;

public class ARFOSpreadableSlab
extends SlabBlock
implements IGrowable {
    public static final EnumProperty<SlabType> TYPE;
    public static final BooleanProperty WATERLOGGED;
    public static final BooleanProperty SLAB_PLACEMENT;
    public static final BooleanProperty SNOWY;
    public static final EnumProperty<DoubleBlockHalf> HALF;
    private static final Map<Block, List<Block>> grassFeatures;

    public ARFOSpreadableSlab(AbstractBlock.Properties p_i48331_1_) {
        super(p_i48331_1_);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(TYPE, (Comparable)SlabType.BOTTOM)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SNOWY, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState state2, IWorld world, BlockPos pos, BlockPos pos2) {
        return direction != Direction.UP ? super.func_196271_a(state, direction, state2, world, pos, pos2) : (BlockState)state.func_206870_a((Property)SNOWY, (Comparable)Boolean.valueOf(state2.func_203425_a(Blocks.field_196604_cC) || state2.func_203425_a(Blocks.field_150433_aE)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{TYPE, WATERLOGGED, SNOWY});
    }

    public boolean func_176473_a(IBlockReader p_176473_1_, BlockPos p_176473_2_, BlockState state, boolean p_176473_4_) {
        if (state.func_177230_c().func_235332_a_(ARFOBlocks.MYCELIUM_SLAB) || state.func_177230_c().func_235332_a_(ARFOBlocks.GRASS_SLAB) || state.func_177230_c().func_235332_a_(BYGBlocks.BYG_MEADOW_GRASS_SLAB)) {
            return false;
        }
        return p_176473_1_.func_180495_p(p_176473_2_.func_177984_a()).func_196958_f();
    }

    public boolean func_180670_a(World world, Random random, BlockPos pos, BlockState state) {
        return !state.func_177230_c().func_235332_a_(ARFOBlocks.MYCELIUM_SLAB) && !state.func_177230_c().func_235332_a_(ARFOBlocks.GRASS_SLAB) && !state.func_177230_c().func_235332_a_(BYGBlocks.BYG_MEADOW_GRASS_SLAB);
    }

    public void func_225535_a_(ServerWorld world, Random random, BlockPos pos, BlockState state) {
        BlockPos blockPos = pos.func_177984_a();
        BlockState blockState = world.func_180495_p(pos);
        BlockState failState = Blocks.field_150350_a.func_176223_P();
        MapUtils.initMap(grassFeatures);
        boolean large = false;
        List<Object> features = new ArrayList();
        for (Block b1 : BlockMapping.slabAndBlocks.keySet()) {
            if (!BlockMapping.slabAndBlocks.get(b1).func_235332_a_(blockState.func_177230_c())) continue;
            features = grassFeatures.get(b1);
        }
        block1: for (int i = 0; i < 128; ++i) {
            BlockPos blockPos2 = blockPos;
            for (int j = 0; j < i / 16; ++j) {
                if (!(world.func_180495_p((blockPos2 = blockPos2.func_177982_a(random.nextInt(3) - 1, (random.nextInt(3) - 1) * random.nextInt(3) / 2, random.nextInt(3) - 1)).func_177977_b()).func_177230_c() instanceof ARFOSpreadableBlock) || world.func_180495_p(blockPos2).func_235785_r_((IBlockReader)world, blockPos2)) continue block1;
            }
            BlockState blockState2 = world.func_180495_p(blockPos2);
            if (blockState2.func_177230_c() instanceof ARFOSpreadableBlock && random.nextInt(10) == 0) {
                ((ARFOSpreadableBlock)blockState.func_177230_c()).func_225535_a_(world, random, blockPos2, blockState2);
            }
            if (blockState2.func_177230_c() instanceof ARFOSpreadableBlock && random.nextInt(10) == 0 && blockState2.func_177229_b(TYPE) != SlabType.BOTTOM) {
                ((ARFOSpreadableBlock)blockState.func_177230_c()).func_225535_a_(world, random, blockPos2, blockState2);
            }
            if (!blockState2.func_196958_f()) continue;
            BlockState blockState4 = failState;
            int rand = random.nextInt(80);
            if (rand < 10) {
                blockState4 = ((Block)features.get(0)).func_176223_P();
            } else if (rand < 30) {
                blockState4 = ((Block)features.get(1)).func_176223_P();
            } else if (rand < 35) {
                if (world.func_180495_p(blockPos2.func_177984_a()).func_196958_f()) {
                    blockState4 = (BlockState)((Block)features.get(2)).func_176223_P().func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER);
                    large = true;
                }
            } else if (rand < 40) {
                if (world.func_180495_p(blockPos2.func_177984_a()).func_196958_f()) {
                    blockState4 = (BlockState)((Block)features.get(3)).func_176223_P().func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER);
                    large = true;
                }
            } else if (rand < 45) {
                blockState4 = ((Block)features.get(random.nextInt(features.size() / 2) + 4)).func_176223_P();
            }
            if (!blockState4.func_196955_c((IWorldReader)world, blockPos2)) continue;
            if (world.func_180495_p(blockPos2.func_177977_b()).func_177230_c() instanceof ARFOSpreadableSlab && world.func_180495_p(blockPos2.func_177977_b()).func_177229_b(TYPE) == SlabType.BOTTOM) {
                if (blockState4.func_177230_c() instanceof ARFOGrass || blockState4.func_177230_c() instanceof ARFOFernBlock || blockState4.func_177230_c() instanceof ARFOTallGrass || blockState4.func_177230_c() instanceof ARFOLargeFernBlock || blockState4.func_177230_c() instanceof ARFOLeavesCarpetBlock) {
                    world.func_180501_a(blockPos2, (BlockState)blockState4.func_206870_a((Property)SLAB_PLACEMENT, (Comparable)Boolean.valueOf(true)), 3);
                }
            } else {
                world.func_180501_a(blockPos2, blockState4, 3);
            }
            if (large) {
                BlockState downState = world.func_180495_p(blockPos2.func_177977_b());
                if (downState.func_177230_c() instanceof ARFOSpreadableSlab && world.func_180495_p(blockPos2.func_177977_b()).func_177229_b(TYPE) == SlabType.BOTTOM) {
                    world.func_180501_a(blockPos2.func_177984_a(), (BlockState)((BlockState)blockState4.func_177230_c().func_176223_P().func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER)).func_206870_a((Property)SLAB_PLACEMENT, (Comparable)Boolean.valueOf(true)), 3);
                } else {
                    world.func_180501_a(blockPos2.func_177984_a(), (BlockState)blockState4.func_177230_c().func_176223_P().func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
                }
            }
            large = false;
        }
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (!ARFOSpreadableSlab.canBeGrass(state, (IWorldReader)world, pos)) {
            ARFOSpreadableSlab.setToDirt((World)world, pos);
        } else {
            ARFOSpreadableSlab.doTick(state, world, pos, random);
        }
    }

    private static boolean canBeGrass(BlockState state, IWorldReader world, BlockPos pos) {
        BlockPos posUp = pos.func_177984_a();
        BlockState stateUp = world.func_180495_p(posUp);
        if (stateUp.func_177230_c() == Blocks.field_150433_aE && (Integer)stateUp.func_177229_b((Property)SnowBlock.field_176315_a) >= 1) {
            return false;
        }
        if (state.func_177230_c() instanceof ARFOSpreadableSlab && ((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue() && state.func_177229_b(TYPE) != SlabType.TOP && world.func_204610_c(posUp).func_206884_a((ITag)FluidTags.field_206959_a) || stateUp.func_204520_s().func_206882_g() == 8) {
            return false;
        }
        if (state.func_177230_c() instanceof ARFOSpreadableSlab && !stateUp.func_185904_a().func_76220_a() && state.func_177229_b(TYPE) == SlabType.TOP) {
            return true;
        }
        if (stateUp.func_177230_c() instanceof ARFOLeavesCarpetBlock || stateUp.func_177230_c() instanceof LeavesBlock || stateUp.func_177230_c() instanceof FenceGateBlock || stateUp.func_177230_c() instanceof FenceBlock) {
            return true;
        }
        int i = LightEngine.func_215613_a((IBlockReader)world, (BlockState)state, (BlockPos)pos, (BlockState)stateUp, (BlockPos)posUp, (Direction)Direction.UP, (int)stateUp.func_200016_a((IBlockReader)world, posUp));
        return i < world.func_201572_C();
    }

    private static boolean canPropagate(BlockState state, IWorldReader world, BlockPos pos) {
        return ARFOSpreadableSlab.canBeGrass(state, world, pos) && !world.func_204610_c(pos.func_177984_a()).func_206884_a((ITag)FluidTags.field_206959_a) && (!(state.func_177230_c() instanceof ARFOSpreadableSlab) || (Boolean)state.func_177229_b((Property)WATERLOGGED) == false || state.func_177229_b(TYPE) != SlabType.BOTTOM);
    }

    public static void setToDirt(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof ARFOSpreadableStoneSlab) {
            world.func_180501_a(pos, (BlockState)((BlockState)ARFOBlocks.ARTIFICIAL_STONE_SOIL_SLAB.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, state.func_177229_b((Property)SlabBlock.field_196505_a))).func_206870_a((Property)SlabBlock.field_204512_b, state.func_177229_b((Property)SlabBlock.field_204512_b)), 3);
        } else if (block instanceof ARFOSpreadableNetherrackSlab) {
            world.func_180501_a(pos, (BlockState)((BlockState)ARFOBlocks.NETHERRACK_SLAB.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, state.func_177229_b((Property)SlabBlock.field_196505_a))).func_206870_a((Property)SlabBlock.field_204512_b, state.func_177229_b((Property)SlabBlock.field_204512_b)), 3);
        } else if (block.func_235332_a_(BYGBlocks.BYG_MEADOW_GRASS_SLAB)) {
            world.func_180501_a(pos, (BlockState)((BlockState)BYGBlocks.BYG_MEADOW_DIRT_SLAB.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, state.func_177229_b((Property)SlabBlock.field_196505_a))).func_206870_a((Property)SlabBlock.field_204512_b, state.func_177229_b((Property)SlabBlock.field_204512_b)), 3);
        } else if (block instanceof ARFOSpreadableGrassSlab) {
            world.func_180501_a(pos, (BlockState)((BlockState)ARFOBlocks.ARTIFICIAL_SOIL_SLAB.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, state.func_177229_b((Property)SlabBlock.field_196505_a))).func_206870_a((Property)SlabBlock.field_204512_b, state.func_177229_b((Property)SlabBlock.field_204512_b)), 3);
        } else {
            world.func_180501_a(pos, (BlockState)((BlockState)ARFOBlocks.DIRT_SLAB.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, state.func_177229_b((Property)SlabBlock.field_196505_a))).func_206870_a((Property)SlabBlock.field_204512_b, state.func_177229_b((Property)SlabBlock.field_204512_b)), 3);
        }
    }

    public static void doTick(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (ARFOSpreadableSlab.canBeGrass(state, (IWorldReader)world, pos)) {
            for (int i = 0; i < 4; ++i) {
                BlockPos newPos = pos.func_177982_a(random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1);
                BlockState newState = world.func_180495_p(newPos);
                if (!ARFOSpreadableSlab.canPropagate(state, (IWorldReader)world, newPos)) continue;
                if (newState.func_203425_a(Blocks.field_150346_d)) {
                    if ((state.func_177230_c().func_235332_a_(ARFOBlocks.GRASS_SLAB) || state.func_177230_c().func_235332_a_(BYGBlocks.BYG_MEADOW_GRASS_SLAB)) && !world.func_180495_p(newPos.func_177984_a()).func_185904_a().func_76220_a()) {
                        world.func_180501_a(newPos, Blocks.field_196658_i.func_176223_P(), 3);
                        continue;
                    }
                    if (!state.func_177230_c().func_235332_a_(ARFOBlocks.MYCELIUM_SLAB)) continue;
                    world.func_180501_a(newPos, Blocks.field_150391_bh.func_176223_P(), 3);
                    continue;
                }
                if (newState.func_203425_a(ARFOBlocks.DIRT_SLAB)) {
                    if (state.func_177230_c().func_235332_a_(ARFOBlocks.GRASS_SLAB) && !world.func_180495_p(newPos.func_177984_a()).func_185904_a().func_76220_a()) {
                        if (newState.func_177229_b(TYPE) == SlabType.BOTTOM) {
                            if (!((Boolean)newState.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
                                world.func_180501_a(newPos, (BlockState)((BlockState)((BlockState)ARFOBlocks.GRASS_SLAB.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, newState.func_177229_b((Property)SlabBlock.field_196505_a))).func_206870_a((Property)SNOWY, (Comparable)Boolean.valueOf(world.func_180495_p(newPos.func_177984_a()).func_203425_a(Blocks.field_150433_aE)))).func_206870_a((Property)SlabBlock.field_204512_b, newState.func_177229_b((Property)SlabBlock.field_204512_b)), 3);
                            }
                        } else {
                            world.func_180501_a(newPos, (BlockState)((BlockState)((BlockState)ARFOBlocks.GRASS_SLAB.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, newState.func_177229_b((Property)SlabBlock.field_196505_a))).func_206870_a((Property)SNOWY, (Comparable)Boolean.valueOf(world.func_180495_p(newPos.func_177984_a()).func_203425_a(Blocks.field_150433_aE)))).func_206870_a((Property)SlabBlock.field_204512_b, newState.func_177229_b((Property)SlabBlock.field_204512_b)), 3);
                        }
                    }
                    if (state.func_177230_c() != ARFOBlocks.MYCELIUM_SLAB || world.func_180495_p(newPos.func_177984_a()).func_185904_a().func_76220_a()) continue;
                    if (newState.func_177229_b(TYPE) == SlabType.BOTTOM) {
                        if (((Boolean)newState.func_177229_b((Property)WATERLOGGED)).booleanValue()) continue;
                        world.func_180501_a(newPos, (BlockState)((BlockState)((BlockState)ARFOBlocks.MYCELIUM_SLAB.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, newState.func_177229_b((Property)SlabBlock.field_196505_a))).func_206870_a((Property)SNOWY, (Comparable)Boolean.valueOf(world.func_180495_p(newPos.func_177984_a()).func_203425_a(Blocks.field_150433_aE)))).func_206870_a((Property)SlabBlock.field_204512_b, newState.func_177229_b((Property)SlabBlock.field_204512_b)), 3);
                        continue;
                    }
                    world.func_180501_a(newPos, (BlockState)((BlockState)((BlockState)ARFOBlocks.MYCELIUM_SLAB.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, newState.func_177229_b((Property)SlabBlock.field_196505_a))).func_206870_a((Property)SNOWY, (Comparable)Boolean.valueOf(world.func_180495_p(newPos.func_177984_a()).func_203425_a(Blocks.field_150433_aE)))).func_206870_a((Property)SlabBlock.field_204512_b, newState.func_177229_b((Property)SlabBlock.field_204512_b)), 3);
                    continue;
                }
                if (newState.func_203425_a(BYGBlocks.BYG_MEADOW_DIRT_SLAB)) {
                    if (!state.func_177230_c().func_235332_a_(BYGBlocks.BYG_MEADOW_GRASS_SLAB) || world.func_180495_p(newPos.func_177984_a()).func_185904_a().func_76220_a()) continue;
                    if (newState.func_177229_b(TYPE) == SlabType.BOTTOM) {
                        if (((Boolean)newState.func_177229_b((Property)WATERLOGGED)).booleanValue()) continue;
                        world.func_180501_a(newPos, (BlockState)((BlockState)((BlockState)BYGBlocks.BYG_MEADOW_GRASS_SLAB.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, newState.func_177229_b((Property)SlabBlock.field_196505_a))).func_206870_a((Property)SNOWY, (Comparable)Boolean.valueOf(world.func_180495_p(newPos.func_177984_a()).func_203425_a(Blocks.field_150433_aE)))).func_206870_a((Property)SlabBlock.field_204512_b, newState.func_177229_b((Property)SlabBlock.field_204512_b)), 3);
                        continue;
                    }
                    world.func_180501_a(newPos, (BlockState)((BlockState)((BlockState)BYGBlocks.BYG_MEADOW_GRASS_SLAB.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, newState.func_177229_b((Property)SlabBlock.field_196505_a))).func_206870_a((Property)SNOWY, (Comparable)Boolean.valueOf(world.func_180495_p(newPos.func_177984_a()).func_203425_a(Blocks.field_150433_aE)))).func_206870_a((Property)SlabBlock.field_204512_b, newState.func_177229_b((Property)SlabBlock.field_204512_b)), 3);
                    continue;
                }
                if (newState.func_203425_a(ARFOBlocks.ARTIFICIAL_SOIL)) {
                    if (!(state.func_177230_c() instanceof ARFOSpreadableGrassSlab) || world.func_180495_p(newPos.func_177984_a()).func_185904_a().func_76220_a()) continue;
                    for (Block b : BlockMapping.slabAndBlocks.keySet()) {
                        if (BlockMapping.slabAndBlocks.get(b).func_176223_P().func_177230_c() != state.func_177230_c()) continue;
                        newState = b.func_176223_P();
                        break;
                    }
                    world.func_180501_a(newPos, newState, 3);
                    continue;
                }
                if (newState.func_203425_a(ARFOBlocks.ARTIFICIAL_SOIL_SLAB)) {
                    if (!(state.func_177230_c() instanceof ARFOSpreadableGrassSlab)) continue;
                    world.func_180501_a(newPos, (BlockState)((BlockState)((BlockState)state.func_206870_a(TYPE, newState.func_177229_b((Property)SlabBlock.field_196505_a))).func_206870_a((Property)SNOWY, (Comparable)Boolean.valueOf(world.func_180495_p(newPos.func_177984_a()).func_203425_a(Blocks.field_150433_aE)))).func_206870_a((Property)SlabBlock.field_204512_b, newState.func_177229_b((Property)SlabBlock.field_204512_b)), 3);
                    continue;
                }
                if (newState.func_203425_a(ARFOBlocks.ARTIFICIAL_STONE_SOIL)) {
                    if (!(state.func_177230_c() instanceof ARFOSpreadableStoneSlab) || world.func_180495_p(newPos.func_177984_a()).func_185904_a().func_76220_a()) continue;
                    for (Block b : BlockMapping.slabAndBlocks.keySet()) {
                        if (BlockMapping.slabAndBlocks.get(b).func_176223_P().func_177230_c() != state.func_177230_c()) continue;
                        newState = b.func_176223_P();
                        break;
                    }
                    world.func_180501_a(newPos, newState, 3);
                    continue;
                }
                if (newState.func_203425_a(ARFOBlocks.ARTIFICIAL_STONE_SOIL_SLAB)) {
                    if (!(state.func_177230_c() instanceof ARFOSpreadableStoneSlab)) continue;
                    world.func_180501_a(newPos, (BlockState)((BlockState)((BlockState)state.func_206870_a(TYPE, newState.func_177229_b((Property)SlabBlock.field_196505_a))).func_206870_a((Property)SNOWY, (Comparable)Boolean.valueOf(world.func_180495_p(newPos.func_177984_a()).func_203425_a(Blocks.field_150433_aE)))).func_206870_a((Property)SlabBlock.field_204512_b, newState.func_177229_b((Property)SlabBlock.field_204512_b)), 3);
                    continue;
                }
                if (newState.func_203425_a(Blocks.field_150424_aL)) {
                    if (!(state.func_177230_c() instanceof ARFOSpreadableNetherrackSlab) || world.func_180495_p(newPos.func_177984_a()).func_185904_a().func_76220_a()) continue;
                    for (Block b : BlockMapping.slabAndBlocks.keySet()) {
                        if (BlockMapping.slabAndBlocks.get(b).func_176223_P().func_177230_c() != state.func_177230_c()) continue;
                        newState = b.func_176223_P();
                        break;
                    }
                    world.func_180501_a(newPos, newState, 3);
                    continue;
                }
                if (!newState.func_203425_a(ARFOBlocks.NETHERRACK_SLAB) || !(state.func_177230_c() instanceof ARFOSpreadableNetherrackSlab)) continue;
                world.func_180501_a(newPos, (BlockState)((BlockState)((BlockState)state.func_206870_a(TYPE, newState.func_177229_b((Property)SlabBlock.field_196505_a))).func_206870_a((Property)SNOWY, (Comparable)Boolean.valueOf(world.func_180495_p(newPos.func_177984_a()).func_203425_a(Blocks.field_150433_aE)))).func_206870_a((Property)SlabBlock.field_204512_b, newState.func_177229_b((Property)SlabBlock.field_204512_b)), 3);
            }
        }
    }

    public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction facing, IPlantable plantable) {
        PlantType type = plantable.getPlantType(world, pos.func_177972_a(facing));
        if (state.func_177229_b(TYPE) != SlabType.BOTTOM) {
            if (plantable instanceof MushroomBlock) {
                return true;
            }
            if (plantable instanceof BushBlock) {
                return true;
            }
            if (PlantType.CAVE.equals(type)) {
                return true;
            }
            if (PlantType.PLAINS.equals(type)) {
                return this.getBlock() == this;
            }
            if (PlantType.BEACH.equals(type)) {
                boolean isBeach = state.func_203425_a((Block)this) || Tags.Blocks.DIRT.func_230235_a_((Object)this) || state.func_203425_a(Blocks.field_150354_m) || state.func_203425_a(Blocks.field_196611_F);
                boolean hasWater = false;
                for (Direction face : Direction.Plane.HORIZONTAL) {
                    BlockState blockState = world.func_180495_p(pos.func_177972_a(face));
                    FluidState fluidState = world.func_204610_c(pos.func_177972_a(face));
                    hasWater |= blockState.func_203425_a(Blocks.field_185778_de);
                    if (!(hasWater |= fluidState.func_206884_a((ITag)FluidTags.field_206959_a))) continue;
                    break;
                }
                return isBeach && hasWater;
            }
        }
        return false;
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, World world, BlockPos pos, PlayerEntity player, ItemStack stack, ToolType toolType) {
        if (state.func_177230_c() == ARFOBlocks.GRASS_SLAB || state.func_177230_c() == ARFOBlocks.MYCELIUM_SLAB) {
            if (toolType == ToolType.HOE && state.func_177229_b(TYPE) == SlabType.DOUBLE) {
                return Blocks.field_150458_ak.func_176223_P();
            }
            if (toolType == ToolType.SHOVEL && state.func_177229_b(TYPE) == SlabType.DOUBLE) {
                return (BlockState)ARFOBlocks.GRASS_PATH_SLAB.func_176223_P().func_206870_a(TYPE, (Comparable)SlabType.DOUBLE);
            }
            if (toolType == ToolType.SHOVEL && state.func_177229_b(TYPE) == SlabType.BOTTOM) {
                return ARFOBlocks.GRASS_PATH_SLAB.func_176223_P();
            }
            return toolType == ToolType.SHOVEL && state.func_177229_b(TYPE) == SlabType.TOP ? (BlockState)ARFOBlocks.GRASS_PATH_SLAB.func_176223_P().func_206870_a(TYPE, (Comparable)SlabType.TOP) : null;
        }
        return null;
    }

    static {
        HALF = BlockStateProperties.field_208163_P;
        grassFeatures = new HashMap<Block, List<Block>>();
        TYPE = BlockStateProperties.field_208145_at;
        WATERLOGGED = BlockStateProperties.field_208198_y;
        SNOWY = BlockStateProperties.field_208196_w;
        SLAB_PLACEMENT = BlockStateProperties.field_208193_t;
    }
}

