/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.arfo.common.loot;

import com.finallion.arfo.init.ARFOItems;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class GrassLootModifiers {

    public static class GrassLootModifier
    extends LootModifier {
        private List<DyeEntry> dropped_dye = new ArrayList<DyeEntry>();

        public GrassLootModifier(ILootCondition[] conditionsIn, List<String> dyes) {
            super(conditionsIn);
            this.dropped_dye.add(new DyeEntry(Items.field_151014_N, 1));
            for (String d : dyes) {
                Item seedItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(d));
                if (seedItem == ARFOItems.JUNGLE_DYE) {
                    this.dropped_dye.add(new DyeEntry(ARFOItems.JUNGLE_DYE, 5));
                    continue;
                }
                if (seedItem == ARFOItems.JUNGLE_EDGE_DYE) {
                    this.dropped_dye.add(new DyeEntry(ARFOItems.JUNGLE_EDGE_DYE, 5));
                    continue;
                }
                if (seedItem == ARFOItems.BADLANDS_DYE) {
                    this.dropped_dye.add(new DyeEntry(ARFOItems.BADLANDS_DYE, 5));
                    continue;
                }
                if (seedItem == ARFOItems.SAVANNA_DYE) {
                    this.dropped_dye.add(new DyeEntry(ARFOItems.SAVANNA_DYE, 5));
                }
                if (seedItem == ARFOItems.FOREST_DYE) {
                    this.dropped_dye.add(new DyeEntry(ARFOItems.FOREST_DYE, 5));
                    continue;
                }
                if (seedItem == ARFOItems.BIRCH_FOREST_DYE) {
                    this.dropped_dye.add(new DyeEntry(ARFOItems.BIRCH_FOREST_DYE, 5));
                    continue;
                }
                if (seedItem == ARFOItems.DARK_FOREST_DYE) {
                    this.dropped_dye.add(new DyeEntry(ARFOItems.DARK_FOREST_DYE, 5));
                    continue;
                }
                if (seedItem == ARFOItems.PLAINS_DYE) {
                    this.dropped_dye.add(new DyeEntry(ARFOItems.PLAINS_DYE, 5));
                }
                if (seedItem == ARFOItems.SWAMP_DYE) {
                    this.dropped_dye.add(new DyeEntry(ARFOItems.SWAMP_DYE, 5));
                    continue;
                }
                if (seedItem == ARFOItems.LUSH_SWAMP_DYE) {
                    this.dropped_dye.add(new DyeEntry(ARFOItems.LUSH_SWAMP_DYE, 5));
                    continue;
                }
                if (seedItem == ARFOItems.MOUNTAINS_DYE) {
                    this.dropped_dye.add(new DyeEntry(ARFOItems.MOUNTAINS_DYE, 5));
                    continue;
                }
                if (seedItem == ARFOItems.MUSHROOM_FIELDS_DYE) {
                    this.dropped_dye.add(new DyeEntry(ARFOItems.MUSHROOM_FIELDS_DYE, 5));
                }
                if (seedItem == ARFOItems.TAIGA_DYE) {
                    this.dropped_dye.add(new DyeEntry(ARFOItems.TAIGA_DYE, 5));
                    continue;
                }
                if (seedItem == ARFOItems.MEGA_TAIGA_DYE) {
                    this.dropped_dye.add(new DyeEntry(ARFOItems.MEGA_TAIGA_DYE, 5));
                    continue;
                }
                if (seedItem == ARFOItems.SNOWY_DYE) {
                    this.dropped_dye.add(new DyeEntry(ARFOItems.SNOWY_DYE, 5));
                    continue;
                }
                if (seedItem == ARFOItems.SNOWY_BEACH_DYE) {
                    this.dropped_dye.add(new DyeEntry(ARFOItems.SNOWY_BEACH_DYE, 5));
                    continue;
                }
                if (seedItem != ARFOItems.WATERS_DYE) continue;
                this.dropped_dye.add(new DyeEntry(ARFOItems.WATERS_DYE, 5));
            }
        }

        protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
            ArrayList<ItemStack> newLoot = new ArrayList<ItemStack>();
            for (ItemStack stack : generatedLoot) {
                if (stack.func_77973_b() == Items.field_151014_N) {
                    DyeEntry dyeEntry = (DyeEntry)WeightedRandom.func_76271_a((Random)context.func_216032_b(), this.dropped_dye);
                    ItemStack new_stack = new ItemStack((IItemProvider)dyeEntry.dye_item, stack.func_190916_E());
                    newLoot.add(new_stack);
                    continue;
                }
                newLoot.add(stack);
            }
            return newLoot;
        }

        public static class Serializer
        extends GlobalLootModifierSerializer<GrassLootModifier> {
            public GrassLootModifier read(ResourceLocation location, JsonObject object, ILootCondition[] ailootcondition) {
                ArrayList<String> dyes = new ArrayList<String>();
                JsonArray dyeList = JSONUtils.func_151214_t((JsonObject)object, (String)"dyes");
                for (JsonElement je : dyeList) {
                    dyes.add(je.getAsString());
                }
                return new GrassLootModifier(ailootcondition, dyes);
            }

            public JsonObject write(GrassLootModifier instance) {
                return this.makeConditions(instance.conditions);
            }
        }
    }

    public static class DyeEntry
    extends WeightedRandom.Item {
        public final Item dye_item;

        public DyeEntry(Item dye_id, int itemWeightIn) {
            super(itemWeightIn);
            this.dye_item = dye_id;
        }
    }
}

