/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.arfo.data;

import com.finallion.arfo.ArtificialFoliage;
import com.finallion.arfo.common.blocks.ARFOFernBlock;
import com.finallion.arfo.init.ARFOBlocks;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.LootTableProvider;
import net.minecraft.item.Items;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.conditions.BlockStateProperty;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.conditions.MatchTool;
import net.minecraft.loot.conditions.SurvivesExplosion;
import net.minecraft.loot.functions.ExplosionDecay;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public abstract class BaseLootTableProvider
extends LootTableProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    protected final Map<Block, LootTable.Builder> lootTables = new HashMap<Block, LootTable.Builder>();
    private final DataGenerator generator;

    public BaseLootTableProvider(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
        this.generator = dataGeneratorIn;
    }

    protected abstract void addTables();

    protected LootTable.Builder createStandardTable(String name, Block block) {
        StandaloneLootEntry.Builder entry = ItemLootEntry.func_216168_a((IItemProvider)block);
        LootPool.Builder builder = LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)entry).func_212840_b_(SurvivesExplosion.func_215968_b());
        return LootTable.func_216119_b().func_216040_a(builder);
    }

    protected LootTable.Builder createDoubleGrassTable(String name, Block block) {
        LootEntry.Builder entryOne = ((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_((Property)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.LOWER)))).func_212840_b_(MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_200308_a((IItemProvider)Items.field_151097_aZ)));
        LootEntry.Builder entryTwo = ((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_((Property)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.UPPER)))).func_212840_b_(MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_200308_a((IItemProvider)Items.field_151097_aZ)));
        LootPool.Builder builder = LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(entryOne).func_216045_a(entryTwo).func_212840_b_(SurvivesExplosion.func_215968_b());
        return LootTable.func_216119_b().func_216040_a(builder);
    }

    protected LootTable.Builder createShearTable(String name, Block block) {
        ILootCondition.IBuilder SHEAR = MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_200308_a((IItemProvider)Items.field_151097_aZ));
        LootEntry.Builder entry = ItemLootEntry.func_216168_a((IItemProvider)block).func_212840_b_(SHEAR);
        LootPool.Builder builder = LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(entry);
        return LootTable.func_216119_b().func_216040_a(builder);
    }

    protected LootTable.Builder createSlabTable(String name, Block block) {
        StandaloneLootEntry.Builder entry = ItemLootEntry.func_216168_a((IItemProvider)block).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)2)).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_((Property)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE)))).func_212841_b_((ILootFunction.IBuilder)ExplosionDecay.func_215863_b());
        LootPool.Builder builder = LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)entry);
        return LootTable.func_216119_b().func_216040_a(builder);
    }

    protected LootTable.Builder createPottedTable(String name, Block block) {
        String fernName = block.toString().replace("potted_", "");
        Set ferns = Registry.field_212618_g.func_201756_e().filter(b -> b instanceof ARFOFernBlock).collect(Collectors.toSet());
        Block fern = ARFOBlocks.JUNGLE_FERN;
        for (Block b2 : ferns) {
            if (!b2.toString().equals(fernName)) continue;
            fern = b2;
        }
        StandaloneLootEntry.Builder fernLoot = ItemLootEntry.func_216168_a((IItemProvider)fern);
        StandaloneLootEntry.Builder potLoot = ItemLootEntry.func_216168_a((IItemProvider)Blocks.field_150457_bL);
        LootPool.Builder builder = LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)fernLoot).func_212840_b_(SurvivesExplosion.func_215968_b());
        LootPool.Builder builderTwo = LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)potLoot).func_212840_b_(SurvivesExplosion.func_215968_b());
        return LootTable.func_216119_b().func_216040_a(builder).func_216040_a(builderTwo);
    }

    public void func_200398_a(DirectoryCache cache) {
        this.addTables();
        HashMap<ResourceLocation, LootTable> tables = new HashMap<ResourceLocation, LootTable>();
        for (Map.Entry<Block, LootTable.Builder> entry : this.lootTables.entrySet()) {
            tables.put(entry.getKey().func_220068_i(), entry.getValue().func_216039_a(LootParameterSets.field_216267_h).func_216038_b());
        }
        this.writeTables(cache, tables);
    }

    private void writeTables(DirectoryCache cache, Map<ResourceLocation, LootTable> tables) {
        Path outputFolder = this.generator.func_200391_b();
        tables.forEach((key, lootTable) -> {
            Path path = outputFolder.resolve("data/" + key.func_110624_b() + "/loot_tables/" + key.func_110623_a() + ".json");
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)LootTableManager.func_215301_a((LootTable)lootTable), (Path)path);
            }
            catch (IOException e) {
                ArtificialFoliage.LOGGER.error("Couldn't write loot table {}", (Object)path, (Object)e);
            }
        });
    }

    public String func_200397_b() {
        return "Artificial Foliage loot tables";
    }
}

