/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.arfo.data.providers;

import com.finallion.arfo.common.items.ARFODyeItem;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ARFOItemModelProvider
extends ItemModelProvider {
    private static final ResourceLocation GENERATED = new ResourceLocation("item/generated");

    public ARFOItemModelProvider(DataGenerator generator, String modid, ExistingFileHelper existingFileHelper) {
        super(generator, modid, existingFileHelper);
    }

    protected void registerModels() {
        Set items = Registry.field_212630_s.func_201756_e().filter(i -> "arfo".equals(Registry.field_212630_s.func_177774_c(i).func_110624_b())).collect(Collectors.toSet());
        for (Item item : items) {
            String name = Registry.field_212630_s.func_177774_c((Object)item).func_110623_a();
            if (item instanceof ARFODyeItem) {
                this.registerBasicARFOItem(name);
                continue;
            }
            if (name.contains("leaves") || name.contains("grass_block") || name.contains("slab") || name.contains("soil") || name.contains("glowing") || name.contains("overgrown")) {
                this.registerBlockItemModel(name);
                continue;
            }
            if (name.contains("sugar_cane")) {
                this.registerBasicItem(name, "sugar_cane");
                continue;
            }
            if (name.contains("vine")) {
                this.registerBasicItem(name, "vine");
                continue;
            }
            if (name.contains("tall") && name.contains("grass")) {
                this.registerBasicItem(name, "tall_grass_top");
                continue;
            }
            if (name.contains("large") && name.contains("fern")) {
                this.registerBasicItem(name, "large_fern_top");
                continue;
            }
            if (name.contains("grass")) {
                this.registerBasicItem(name, "grass");
                continue;
            }
            if (name.contains("fern")) {
                this.registerBasicItem(name, "fern");
                continue;
            }
            if (!name.contains("water_bucket")) continue;
            this.registerBasicARFOItem(name);
        }
    }

    private void registerBlockItemModel(String name) {
        ((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + name)));
    }

    private void registerBasicARFOItem(String name) {
        this.singleTexture(name, this.mcLoc("item/generated"), "layer0", this.modLoc("items/" + name));
    }

    private void registerBasicItem(String name, String type) {
        this.singleTexture(name, this.mcLoc("item/generated"), "layer0", this.mcLoc("block/" + type));
    }

    @Nonnull
    public String func_200397_b() {
        return "Artificial Foliage item models";
    }
}

