/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.arfo.data.providers;

import com.finallion.arfo.common.blocks.ARFOLargeFernBlock;
import com.finallion.arfo.common.blocks.ARFOSugarCaneBlock;
import com.finallion.arfo.common.blocks.ARFOTallGrass;
import com.finallion.arfo.common.blocks.ARFOVinesBlock;
import com.finallion.arfo.data.BaseLootTableProvider;
import com.finallion.arfo.init.ARFOBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.DataGenerator;

public class ARFOLootTableProvider
extends BaseLootTableProvider {
    public ARFOLootTableProvider(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    @Override
    protected void addTables() {
        for (Block b : ARFOBlocks.blocksList) {
            if (b.toString().contains("potted")) {
                this.lootTables.put(b, this.createPottedTable(b.toString(), b));
                continue;
            }
            if (b.toString().contains("slab")) {
                this.lootTables.put(b, this.createSlabTable(b.toString(), b));
                continue;
            }
            if (b.toString().contains("grass_block") || b.toString().contains("overgrown") || b.toString().contains("soil")) {
                this.lootTables.put(b, this.createStandardTable(b.toString(), b));
                continue;
            }
            if (b instanceof ARFOSugarCaneBlock) {
                this.lootTables.put(b, this.createStandardTable(b.toString(), Blocks.field_196608_cF));
                continue;
            }
            if (b instanceof ARFOTallGrass || b instanceof ARFOLargeFernBlock) {
                this.lootTables.put(b, this.createDoubleGrassTable(b.toString(), b));
                continue;
            }
            if (b instanceof ARFOVinesBlock) {
                this.lootTables.put(b, this.createShearTable(b.toString(), Blocks.field_150395_bd));
                continue;
            }
            if (b.toString().contains("water}")) continue;
            this.lootTables.put(b, this.createShearTable(b.toString(), b));
        }
    }

    @Override
    public String func_200397_b() {
        return "Artificial Foliage loot tables";
    }
}

