/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.init;

import com.yungnickyoung.minecraft.bettermineshafts.BetterMineshafts;
import com.yungnickyoung.minecraft.bettermineshafts.init.BMStructureFeatures;
import com.yungnickyoung.minecraft.bettermineshafts.world.BetterMineshaftFeatureConfig;
import com.yungnickyoung.minecraft.bettermineshafts.world.BetterMineshaftStructure;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3037;
import net.minecraft.class_3195;
import net.minecraft.class_5312;
import net.minecraft.class_5458;
import net.minecraft.class_5470;

public class BMConfiguredStructureFeatures {
    public static class_5312<BetterMineshaftFeatureConfig, ? extends class_3195<BetterMineshaftFeatureConfig>> NORMAL_MINESHAFT = BMStructureFeatures.MINESHAFT_STRUCTURE.method_28659((class_3037)new BetterMineshaftFeatureConfig(BetterMineshafts.CONFIG.mineshaftSpawnRate, BetterMineshaftStructure.Type.NORMAL));
    public static class_5312<BetterMineshaftFeatureConfig, ? extends class_3195<BetterMineshaftFeatureConfig>> MESA_MINESHAFT = BMStructureFeatures.MINESHAFT_STRUCTURE.method_28659((class_3037)new BetterMineshaftFeatureConfig(BetterMineshafts.CONFIG.mineshaftSpawnRate, BetterMineshaftStructure.Type.MESA));
    public static class_5312<BetterMineshaftFeatureConfig, ? extends class_3195<BetterMineshaftFeatureConfig>> JUNGLE_MINESHAFT = BMStructureFeatures.MINESHAFT_STRUCTURE.method_28659((class_3037)new BetterMineshaftFeatureConfig(BetterMineshafts.CONFIG.mineshaftSpawnRate, BetterMineshaftStructure.Type.JUNGLE));
    public static class_5312<BetterMineshaftFeatureConfig, ? extends class_3195<BetterMineshaftFeatureConfig>> SNOW_MINESHAFT = BMStructureFeatures.MINESHAFT_STRUCTURE.method_28659((class_3037)new BetterMineshaftFeatureConfig(BetterMineshafts.CONFIG.mineshaftSpawnRate, BetterMineshaftStructure.Type.SNOW));
    public static class_5312<BetterMineshaftFeatureConfig, ? extends class_3195<BetterMineshaftFeatureConfig>> MUSHROOM_MINESHAFT = BMStructureFeatures.MINESHAFT_STRUCTURE.method_28659((class_3037)new BetterMineshaftFeatureConfig(BetterMineshafts.CONFIG.mineshaftSpawnRate, BetterMineshaftStructure.Type.MUSHROOM));
    public static class_5312<BetterMineshaftFeatureConfig, ? extends class_3195<BetterMineshaftFeatureConfig>> SAVANNA_MINESHAFT = BMStructureFeatures.MINESHAFT_STRUCTURE.method_28659((class_3037)new BetterMineshaftFeatureConfig(BetterMineshafts.CONFIG.mineshaftSpawnRate, BetterMineshaftStructure.Type.SAVANNA));
    public static class_5312<BetterMineshaftFeatureConfig, ? extends class_3195<BetterMineshaftFeatureConfig>> DESERT_MINESHAFT = BMStructureFeatures.MINESHAFT_STRUCTURE.method_28659((class_3037)new BetterMineshaftFeatureConfig(BetterMineshafts.CONFIG.mineshaftSpawnRate, BetterMineshaftStructure.Type.DESERT));
    public static class_5312<BetterMineshaftFeatureConfig, ? extends class_3195<BetterMineshaftFeatureConfig>> REDDESERT_MINESHAFT = BMStructureFeatures.MINESHAFT_STRUCTURE.method_28659((class_3037)new BetterMineshaftFeatureConfig(BetterMineshafts.CONFIG.mineshaftSpawnRate, BetterMineshaftStructure.Type.RED_DESERT));
    public static class_5312<BetterMineshaftFeatureConfig, ? extends class_3195<BetterMineshaftFeatureConfig>> ICE_MINESHAFT = BMStructureFeatures.MINESHAFT_STRUCTURE.method_28659((class_3037)new BetterMineshaftFeatureConfig(BetterMineshafts.CONFIG.mineshaftSpawnRate, BetterMineshaftStructure.Type.ICE));
    public static final List<class_5312<BetterMineshaftFeatureConfig, ? extends class_3195<BetterMineshaftFeatureConfig>>> CONFIGURED_STRUCTURE_FEATURES = Arrays.asList(NORMAL_MINESHAFT, MESA_MINESHAFT, JUNGLE_MINESHAFT, SNOW_MINESHAFT, MUSHROOM_MINESHAFT, SAVANNA_MINESHAFT, DESERT_MINESHAFT, REDDESERT_MINESHAFT, ICE_MINESHAFT);
    public static Map<String, class_5312<?, ?>> exceptionMap;
    public static Map<class_1959.class_1961, class_5312<?, ?>> normalMap;

    public static void init() {
        BMConfiguredStructureFeatures.registerConfiguredStructures();
        BMConfiguredStructureFeatures.addConfiguredStructuresToBiomes();
    }

    private static void registerConfiguredStructures() {
        class_2378 registry = class_5458.field_25930;
        class_2378.method_10230((class_2378)registry, (class_2960)new class_2960("bettermineshafts", "mineshaft_normal"), NORMAL_MINESHAFT);
        class_2378.method_10230((class_2378)registry, (class_2960)new class_2960("bettermineshafts", "mineshaft_mesa"), MESA_MINESHAFT);
        class_2378.method_10230((class_2378)registry, (class_2960)new class_2960("bettermineshafts", "mineshaft_jungle"), JUNGLE_MINESHAFT);
        class_2378.method_10230((class_2378)registry, (class_2960)new class_2960("bettermineshafts", "mineshaft_mushroom"), MUSHROOM_MINESHAFT);
        class_2378.method_10230((class_2378)registry, (class_2960)new class_2960("bettermineshafts", "mineshaft_savanna"), SAVANNA_MINESHAFT);
        class_2378.method_10230((class_2378)registry, (class_2960)new class_2960("bettermineshafts", "mineshaft_desert"), DESERT_MINESHAFT);
        class_2378.method_10230((class_2378)registry, (class_2960)new class_2960("bettermineshafts", "mineshaft_reddesert"), REDDESERT_MINESHAFT);
        class_2378.method_10230((class_2378)registry, (class_2960)new class_2960("bettermineshafts", "mineshaft_ice"), ICE_MINESHAFT);
        class_2378.method_10230((class_2378)registry, (class_2960)new class_2960("bettermineshafts", "mineshaft_snow"), SNOW_MINESHAFT);
    }

    private static void addConfiguredStructuresToBiomes() {
        exceptionMap = new HashMap();
        normalMap = new HashMap();
        exceptionMap.put("ice", ICE_MINESHAFT);
        exceptionMap.put("icy", ICE_MINESHAFT);
        exceptionMap.put("desert_lakes", REDDESERT_MINESHAFT);
        normalMap.put(class_1959.class_1961.field_9354, MESA_MINESHAFT);
        normalMap.put(class_1959.class_1961.field_9358, JUNGLE_MINESHAFT);
        normalMap.put(class_1959.class_1961.field_9362, SNOW_MINESHAFT);
        normalMap.put(class_1959.class_1961.field_9361, SNOW_MINESHAFT);
        normalMap.put(class_1959.class_1961.field_9368, DESERT_MINESHAFT);
        normalMap.put(class_1959.class_1961.field_9365, MUSHROOM_MINESHAFT);
        normalMap.put(class_1959.class_1961.field_9356, SAVANNA_MINESHAFT);
        BiomeModifications.create((class_2960)new class_2960("bettermineshafts", "mineshaft_replacement")).add(ModificationPhase.ADDITIONS, selectionContext -> BMConfiguredStructureFeatures.biomeHasVanillaMineshaft(selectionContext), (selectionContext, modificationContext) -> {
            modificationContext.getGenerationSettings().removeStructure(class_3195.field_24844);
            class_2960 biomeName = selectionContext.getBiomeKey().method_29177();
            class_1959.class_1961 biomeCategory = selectionContext.getBiome().method_8688();
            if (biomeName.toString().equals("minecraft:badlands")) {
                modificationContext.getGenerationSettings().addBuiltInStructure(REDDESERT_MINESHAFT);
                return;
            }
            class_5312<?, ?> mineshaft = null;
            for (String biomePhrase : exceptionMap.keySet()) {
                if (!biomeName.toString().contains(biomePhrase)) continue;
                mineshaft = exceptionMap.get(biomePhrase);
                break;
            }
            if (mineshaft != null) {
                modificationContext.getGenerationSettings().addBuiltInStructure(mineshaft);
            } else {
                mineshaft = normalMap.getOrDefault(biomeCategory, null);
                if (mineshaft != null) {
                    modificationContext.getGenerationSettings().addBuiltInStructure(mineshaft);
                } else {
                    modificationContext.getGenerationSettings().addBuiltInStructure(NORMAL_MINESHAFT);
                }
            }
        });
    }

    private static boolean biomeHasVanillaMineshaft(BiomeSelectionContext context) {
        return context.hasBuiltInStructure(class_5470.field_26293) || context.hasBuiltInStructure(class_5470.field_26294);
    }
}

