/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.yungnickyoung.minecraft.bettermineshafts.BetterMineshafts;
import com.yungnickyoung.minecraft.bettermineshafts.world.BetterMineshaftStructure;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftGenerator;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftStructurePieceType;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.MineshaftPiece;
import com.yungnickyoung.minecraft.yungsapi.world.BoundingBoxHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1694;
import net.minecraft.class_1701;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2442;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_39;
import net.minecraft.class_4778;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_6130;

public class SmallTunnel
extends MineshaftPiece {
    private final List<Integer> supports = new ArrayList<Integer>();
    private static final int SECONDARY_AXIS_LEN = 5;
    private static final int Y_AXIS_LEN = 5;
    private static final int MAIN_AXIS_LEN = 8;
    private static final int LOCAL_X_END = 4;
    private static final int LOCAL_Y_END = 4;
    private static final int LOCAL_Z_END = 7;

    public SmallTunnel(class_3218 world, class_2487 compoundTag) {
        super(BetterMineshaftStructurePieceType.SMALL_TUNNEL, compoundTag);
        class_2499 listTag1 = compoundTag.method_10554("Supports", 3);
        for (int i = 0; i < listTag1.size(); ++i) {
            this.supports.add(listTag1.method_10600(i));
        }
    }

    public SmallTunnel(int chunkPieceLen, Random random, class_3341 blockBox, class_2350 direction, BetterMineshaftStructure.Type type) {
        super(BetterMineshaftStructurePieceType.SMALL_TUNNEL, chunkPieceLen, type, blockBox);
        this.method_14926(direction);
    }

    @Override
    protected void method_14943(class_3218 world, class_2487 tag) {
        super.method_14943(world, tag);
        class_2499 listTag1 = new class_2499();
        this.supports.forEach(z -> listTag1.add((Object)class_2497.method_23247((int)z)));
        tag.method_10566("Supports", (class_2520)listTag1);
    }

    public static class_3341 determineBoxPosition(class_6130 structurePiecesHolder, Random random, int x, int y, int z, class_2350 direction) {
        class_3341 blockBox = BoundingBoxHelper.boxFromCoordsWithRotation((int)x, (int)y, (int)z, (int)5, (int)5, (int)8, (class_2350)direction);
        class_3443 intersectingPiece = structurePiecesHolder.method_35461(blockBox);
        return intersectingPiece != null ? null : blockBox;
    }

    @Override
    public void method_14918(class_3443 structurePiece, class_6130 structurePiecesHolder, Random random) {
        class_2350 direction = this.method_14934();
        if (direction == null) {
            return;
        }
        switch (direction) {
            default: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePiecesHolder, random, this.field_15315.method_35415(), this.field_15315.method_35416(), this.field_15315.method_35417() - 1, direction, this.field_15316);
                break;
            }
            case field_11035: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePiecesHolder, random, this.field_15315.method_35418(), this.field_15315.method_35416(), this.field_15315.method_35420() + 1, direction, this.field_15316);
                break;
            }
            case field_11039: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePiecesHolder, random, this.field_15315.method_35415() - 1, this.field_15315.method_35416(), this.field_15315.method_35420(), direction, this.field_15316);
                break;
            }
            case field_11034: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePiecesHolder, random, this.field_15315.method_35418() + 1, this.field_15315.method_35416(), this.field_15315.method_35417(), direction, this.field_15316);
            }
        }
        this.buildSupports(random);
    }

    public boolean method_14931(class_5281 world, class_5138 structureAccessor, class_2794 generator, Random random, class_3341 box, class_1923 pos, class_2338 blockPos) {
        if (this.isTouchingLiquid((class_1922)world, box)) {
            return false;
        }
        if (this.isInOcean(world, 0, 0) || this.isInOcean(world, 4, 7)) {
            return false;
        }
        this.chanceReplaceNonAir(world, box, random, this.getReplacementRate(), 0, 1, 0, 4, 4, 7, this.getMainSelector());
        this.chanceReplaceNonAir(world, box, random, this.getReplacementRate(), 0, 0, 0, 4, 0, 7, this.getFloorSelector());
        this.fill(world, box, 1, 1, 0, 3, 3, 7, field_15314);
        this.replaceAir(world, box, 1, 0, 0, 3, 0, 7, this.getMainBlock());
        this.replaceAir(world, box, 1, 0, 0, 3, 0, 7, this.getMainBlock());
        this.generateSupports(world, box, random);
        this.generateRails(world, box, random);
        this.generateCobwebs(world, box, random);
        this.generateChestCarts(world, box, random);
        this.generateTntCarts(world, box, random);
        this.addVines(world, box, random, 1, 0, 1, 3, 4, 6);
        this.addBiomeDecorations(world, box, random, 1, 0, 0, 3, 3, 6);
        this.generateTorches(world, box, random);
        return true;
    }

    private void generateCobwebs(class_5281 world, class_3341 box, Random random) {
        float chance = (float)BetterMineshafts.CONFIG.spawnRates.cobwebSpawnRate;
        this.supports.forEach(z -> {
            this.chanceReplaceAir(world, box, random, chance, 1, 3, z - 1, 1, 3, z + 1, class_2246.field_10343.method_9564());
            this.chanceReplaceAir(world, box, random, chance, 3, 3, z - 1, 3, 3, z + 1, class_2246.field_10343.method_9564());
        });
    }

    private void generateChestCarts(class_5281 world, class_3341 box, Random random) {
        for (int z = 0; z <= 7; ++z) {
            class_2338 blockPos;
            if (!((double)random.nextFloat() < BetterMineshafts.CONFIG.spawnRates.smallShaftChestMinecartSpawnRate) || !box.method_14662((class_2382)(blockPos = new class_2338(this.method_14928(2, z), this.method_14924(1), this.method_14941(2, z)))) || world.method_8320(blockPos.method_10074()).method_26215()) continue;
            class_1694 chestMinecartEntity = new class_1694((class_1937)world.method_8410(), (double)((float)blockPos.method_10263() + 0.5f), (double)((float)blockPos.method_10264() + 0.5f), (double)((float)blockPos.method_10260() + 0.5f));
            chestMinecartEntity.method_7562(class_39.field_472, random.nextLong());
            world.method_8649((class_1297)chestMinecartEntity);
        }
    }

    private void generateSupports(class_5281 world, class_3341 box, Random random) {
        class_2680 supportBlock = this.getSupportBlock();
        if (supportBlock.method_28501().contains(class_2741.field_22174) && supportBlock.method_28501().contains(class_2741.field_22177)) {
            supportBlock = (class_2680)((class_2680)supportBlock.method_11657((class_2769)class_2741.field_22174, (Comparable)class_4778.field_22180)).method_11657((class_2769)class_2741.field_22177, (Comparable)class_4778.field_22180);
        } else if (supportBlock.method_28501().contains(class_2741.field_12487) && supportBlock.method_28501().contains(class_2741.field_12527)) {
            supportBlock = (class_2680)((class_2680)supportBlock.method_11657((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(true));
        }
        for (int z : this.supports) {
            this.fill(world, box, 1, 1, z, 1, 2, z, this.getSupportBlock());
            this.fill(world, box, 3, 1, z, 3, 2, z, this.getSupportBlock());
            this.fill(world, box, 1, 3, z, 3, 3, z, this.getMainBlock());
            this.chanceReplaceNonAir(world, box, random, 0.25f, 1, 3, z, 3, 3, z, supportBlock);
        }
    }

    private void generateRails(class_5281 world, class_3341 box, Random random) {
        this.chanceFill(world, box, random, 0.5f, 2, 1, 0, 2, 1, 7, class_2246.field_10167.method_9564());
        for (int n = 0; n <= 7; ++n) {
            this.chanceAddBlock(world, random, 0.07f, (class_2680)class_2246.field_10425.method_9564().method_11657((class_2769)class_2442.field_11364, (Comparable)Boolean.valueOf(true)), 2, 1, n, box);
        }
    }

    private void generateTntCarts(class_5281 world, class_3341 box, Random random) {
        for (int z = 0; z <= 7; ++z) {
            class_2338 blockPos;
            if (!((double)random.nextFloat() < BetterMineshafts.CONFIG.spawnRates.smallShaftTntMinecartSpawnRate) || !box.method_14662((class_2382)(blockPos = new class_2338(this.method_14928(2, z), this.method_14924(1), this.method_14941(2, z)))) || world.method_8320(blockPos.method_10074()).method_26215()) continue;
            class_1701 tntMinecartEntity = new class_1701((class_1937)world.method_8410(), (double)((float)blockPos.method_10263() + 0.5f), (double)((float)blockPos.method_10264() + 0.5f), (double)((float)blockPos.method_10260() + 0.5f));
            world.method_8649((class_1297)tntMinecartEntity);
        }
    }

    private void generateTorches(class_5281 world, class_3341 box, Random random) {
        class_2680 torchBlock = class_2246.field_10099.method_9564();
        for (int z = 0; z <= 7; ++z) {
            boolean canPlace;
            class_2338 adjPos;
            class_2338 pos;
            if (this.supports.contains(z)) continue;
            float r = random.nextFloat();
            if ((double)r < BetterMineshafts.CONFIG.spawnRates.torchSpawnRate / 2.0) {
                pos = new class_2338(this.method_14928(1, z), this.method_14924(2), this.method_14941(1, z));
                adjPos = new class_2338(this.method_14928(0, z), this.method_14924(2), this.method_14941(0, z));
                boolean bl = canPlace = world.method_8320(pos).method_26215() && world.method_8320(adjPos) != field_15314;
                if (!canPlace) continue;
                this.replaceAir(world, box, 1, 2, z, 1, 2, z, (class_2680)torchBlock.method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11034));
                continue;
            }
            if (!((double)r < BetterMineshafts.CONFIG.spawnRates.torchSpawnRate)) continue;
            pos = new class_2338(this.method_14928(3, z), this.method_14924(2), this.method_14941(3, z));
            adjPos = new class_2338(this.method_14928(4, z), this.method_14924(2), this.method_14941(4, z));
            boolean bl = canPlace = world.method_8320(pos).method_26215() && world.method_8320(adjPos) != field_15314;
            if (!canPlace) continue;
            this.replaceAir(world, box, 3, 2, z, 3, 2, z, (class_2680)torchBlock.method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11039));
        }
    }

    private void buildSupports(Random random) {
        for (int z = 0; z <= 7; ++z) {
            int r = random.nextInt(7);
            if (r != 0) continue;
            this.supports.add(z);
            z += 5;
        }
    }
}

