/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.google.common.collect.ImmutableSet;
import com.yungnickyoung.minecraft.bettermineshafts.world.BetterMineshaftStructure;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BlockSetSelectors;
import com.yungnickyoung.minecraft.yungsapi.world.BlockSetSelector;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_1922;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2266;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2488;
import net.minecraft.class_2541;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3614;
import net.minecraft.class_3708;
import net.minecraft.class_3719;
import net.minecraft.class_3773;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_6130;

public abstract class MineshaftPiece
extends class_3443 {
    public BetterMineshaftStructure.Type mineshaftType;
    private static final Set<class_3614> LIQUIDS = ImmutableSet.of((Object)class_3614.field_15922, (Object)class_3614.field_15920);

    public MineshaftPiece(class_3773 structurePieceType, int chainLength, BetterMineshaftStructure.Type type, class_3341 boundingBox) {
        super(structurePieceType, chainLength, boundingBox);
        this.mineshaftType = type;
    }

    public MineshaftPiece(class_3773 structurePieceType, class_2487 compoundTag) {
        super(structurePieceType, compoundTag);
        this.mineshaftType = BetterMineshaftStructure.Type.byIndex(compoundTag.method_10550("MST"));
    }

    protected void method_14943(class_3218 world, class_2487 tag) {
        tag.method_10569("MST", this.mineshaftType.ordinal());
    }

    public void method_14918(class_3443 structurePiece, class_6130 structurePiecesHolder, Random random) {
    }

    protected BlockSetSelector getMainSelector() {
        return BlockSetSelectors.MAIN_SELECTOR.get((Object)this.mineshaftType);
    }

    protected BlockSetSelector getFloorSelector() {
        return BlockSetSelectors.FLOOR_SELECTOR.get((Object)this.mineshaftType);
    }

    protected BlockSetSelector getBrickSelector() {
        return BlockSetSelectors.BRICK_SELECTOR.get((Object)this.mineshaftType);
    }

    protected BlockSetSelector getLegSelector() {
        return BlockSetSelectors.LEG_SELECTOR.get((Object)this.mineshaftType);
    }

    protected class_2680 getMainBlock() {
        return BlockSetSelectors.MAIN_BLOCK.get((Object)this.mineshaftType);
    }

    protected class_2680 getSupportBlock() {
        return BlockSetSelectors.SUPPORT_BLOCK.get((Object)this.mineshaftType);
    }

    protected class_2680 getMainSlab() {
        return BlockSetSelectors.SLAB_BLOCK.get((Object)this.mineshaftType);
    }

    protected class_2680 getGravel() {
        return BlockSetSelectors.GRAVEL_BLOCK.get((Object)this.mineshaftType);
    }

    protected class_2680 getMainDoorwayWall() {
        return BlockSetSelectors.STONE_WALL_BLOCK.get((Object)this.mineshaftType);
    }

    protected class_2680 getMainDoorwaySlab() {
        return BlockSetSelectors.STONE_SLAB_BLOCK.get((Object)this.mineshaftType);
    }

    protected class_2680 getTrapdoor() {
        return switch (this.mineshaftType) {
            case BetterMineshaftStructure.Type.MESA, BetterMineshaftStructure.Type.RED_DESERT -> class_2246.field_10246.method_9564();
            case BetterMineshaftStructure.Type.JUNGLE -> class_2246.field_10017.method_9564();
            case BetterMineshaftStructure.Type.SNOW, BetterMineshaftStructure.Type.ICE -> class_2246.field_10323.method_9564();
            case BetterMineshaftStructure.Type.SAVANNA -> class_2246.field_10608.method_9564();
            default -> class_2246.field_10137.method_9564();
        };
    }

    protected float getVineChance() {
        return switch (this.mineshaftType) {
            case BetterMineshaftStructure.Type.RED_DESERT, BetterMineshaftStructure.Type.DESERT -> 0.1f;
            case BetterMineshaftStructure.Type.JUNGLE -> 0.6f;
            case BetterMineshaftStructure.Type.SNOW, BetterMineshaftStructure.Type.ICE -> 0.05f;
            default -> 0.25f;
        };
    }

    protected float getReplacementRate() {
        return this.mineshaftType == BetterMineshaftStructure.Type.SNOW || this.mineshaftType == BetterMineshaftStructure.Type.ICE || this.mineshaftType == BetterMineshaftStructure.Type.MUSHROOM ? 0.95f : 0.6f;
    }

    protected boolean addBarrel(class_5281 world, class_3341 boundingBox, Random random, class_2338 pos, class_2960 lootTableId) {
        if (boundingBox.method_14662((class_2382)pos) && world.method_8320(pos).method_26204() != class_2246.field_16328) {
            world.method_8652(pos, (class_2680)class_2246.field_16328.method_9564().method_11657((class_2769)class_3708.field_16320, (Comparable)class_2350.field_11036), 2);
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof class_3719) {
                ((class_3719)blockEntity).method_11285(lootTableId, random.nextLong());
            }
            return true;
        }
        return false;
    }

    protected boolean addBarrel(class_5281 world, class_3341 boundingBox, Random random, int x, int y, int z, class_2960 lootTableId) {
        class_2338 blockPos = new class_2338(this.method_14928(x, z), this.method_14924(y), this.method_14941(x, z));
        return this.addBarrel(world, boundingBox, random, blockPos, lootTableId);
    }

    protected void addVines(class_5281 world, class_3341 boundingBox, class_2350 facing, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    mutable.method_10103(this.method_14928(x, z), this.method_14924(y), this.method_14941(x, z)).method_10098(facing);
                    class_2680 nextBlock = this.method_14929((class_1922)world, x + facing.method_10148(), y + facing.method_10164(), z + facing.method_10165(), boundingBox);
                    if (!this.method_14929((class_1922)world, x, y, z, boundingBox).method_26215() || !class_2248.method_9501((class_265)nextBlock.method_26220((class_1922)world, (class_2338)mutable), (class_2350)facing.method_10153()) || nextBlock.method_26204().method_9564() == class_2246.field_9983.method_9564() || !(random.nextFloat() < chance)) continue;
                    this.method_14917(world, (class_2680)class_2246.field_10597.method_9564().method_11657((class_2769)class_2541.method_10828((class_2350)(facing.method_10166() == class_2350.class_2351.field_11048 ? facing : facing.method_10153())), (Comparable)Boolean.valueOf(true)), x, y, z, boundingBox);
                }
            }
        }
    }

    protected void addVines(class_5281 world, class_3341 boundingBox, Random random, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        float chance = this.getVineChance();
        this.addVines(world, boundingBox, class_2350.field_11034, random, chance, minX, minY, minZ, maxX, maxY, maxZ);
        this.addVines(world, boundingBox, class_2350.field_11039, random, chance, minX, minY, minZ, maxX, maxY, maxZ);
        this.addVines(world, boundingBox, class_2350.field_11043, random, chance, minX, minY, minZ, maxX, maxY, maxZ);
        this.addVines(world, boundingBox, class_2350.field_11035, random, chance, minX, minY, minZ, maxX, maxY, maxZ);
    }

    protected void addBiomeDecorations(class_5281 world, class_3341 box, Random random, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2338 blockPos = new class_2338(this.method_14928(x, z), this.method_14924(y), this.method_14941(x, z));
                    class_2680 state = this.method_14929((class_1922)world, x, y, z, box);
                    class_2680 stateBelow = this.method_14929((class_1922)world, x, y - 1, z, box);
                    class_2248 blockBelow = stateBelow.method_26204();
                    if (this.mineshaftType == BetterMineshaftStructure.Type.SNOW && state == field_15314 && class_2246.field_10477.method_9558(field_15314, (class_4538)world, blockPos)) {
                        this.method_14917(world, (class_2680)class_2246.field_10477.method_9564().method_11657((class_2769)class_2488.field_11518, (Comparable)Integer.valueOf(random.nextInt(2) + 1)), x, y, z, box);
                    }
                    if ((this.mineshaftType == BetterMineshaftStructure.Type.DESERT || this.mineshaftType == BetterMineshaftStructure.Type.RED_DESERT) && random.nextFloat() < 0.1f && state == field_15314 && class_2246.field_10029.method_9558(field_15314, (class_4538)world, blockPos)) {
                        this.method_14917(world, (class_2680)class_2246.field_10029.method_9564().method_11657((class_2769)class_2266.field_10709, (Comparable)Integer.valueOf(0)), x, y, z, box);
                        if (random.nextFloat() < 0.5f && this.method_14929((class_1922)world, x, y + 1, z, box) == field_15314) {
                            this.method_14917(world, (class_2680)class_2246.field_10029.method_9564().method_11657((class_2769)class_2266.field_10709, (Comparable)Integer.valueOf(0)), x, y + 1, z, box);
                        }
                    }
                    if (!(this.mineshaftType != BetterMineshaftStructure.Type.MESA && this.mineshaftType != BetterMineshaftStructure.Type.DESERT && this.mineshaftType != BetterMineshaftStructure.Type.RED_DESERT || !(random.nextFloat() < 0.1f) || state != field_15314 || blockBelow != class_2246.field_10102 && blockBelow != class_2246.field_10534 && blockBelow != class_2246.field_10415 && blockBelow != class_2246.field_10611 && blockBelow != class_2246.field_10184 && blockBelow != class_2246.field_10143 && blockBelow != class_2246.field_10123 && blockBelow != class_2246.field_10566)) {
                        this.method_14917(world, class_2246.field_10428.method_9564(), x, y, z, box);
                    }
                    if (this.mineshaftType != BetterMineshaftStructure.Type.MUSHROOM || state != field_15314 || blockBelow != class_2246.field_10402 && blockBelow != class_2246.field_10566) continue;
                    float r = random.nextFloat();
                    if (r < 0.2f) {
                        this.method_14917(world, class_2246.field_10559.method_9564(), x, y, z, box);
                        continue;
                    }
                    if (!(r < 0.4f)) continue;
                    this.method_14917(world, class_2246.field_10251.method_9564(), x, y, z, box);
                }
            }
        }
    }

    protected void generateLeg(class_5281 world, Random random, class_3341 box, int x, int z, BlockSetSelector selector) {
        class_2338.class_2339 mutable = new class_2338.class_2339(x, -1, z);
        class_2680 state = this.method_14929((class_1922)world, mutable.method_10263(), mutable.method_10264(), mutable.method_10260(), box);
        while (this.method_14924(mutable.method_10264()) > 0 && (state == field_15314 || state == class_2246.field_10124.method_9564() || LIQUIDS.contains(state.method_26207()))) {
            this.method_14917(world, selector.get(random), x, mutable.method_10264(), z, box);
            mutable.method_10098(class_2350.field_11033);
            state = this.method_14929((class_1922)world, mutable.method_10263(), mutable.method_10264(), mutable.method_10260(), box);
        }
    }

    protected void fill(class_5281 world, class_3341 blockBox, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, class_2680 blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    this.method_14917(world, blockState, x, y, z, blockBox);
                }
            }
        }
    }

    protected void fill(class_5281 world, class_3341 blockBox, Random random, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockSetSelector selector) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    this.method_14917(world, selector.get(random), x, y, z, blockBox);
                }
            }
        }
    }

    protected void replaceAir(class_5281 world, class_3341 blockBox, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, class_2680 blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2680 currState = this.getBlockAtFixed((class_1922)world, x, y, z, blockBox);
                    if (currState == null || !currState.method_26215()) continue;
                    this.method_14917(world, blockState, x, y, z, blockBox);
                }
            }
        }
    }

    protected void replaceAir(class_5281 world, class_3341 blockBox, Random random, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockSetSelector selector) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2680 currState = this.getBlockAtFixed((class_1922)world, x, y, z, blockBox);
                    if (currState == null || !currState.method_26215()) continue;
                    this.method_14917(world, selector.get(random), x, y, z, blockBox);
                }
            }
        }
    }

    protected void replaceNonAir(class_5281 world, class_3341 blockBox, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, class_2680 blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2680 currState = this.getBlockAtFixed((class_1922)world, x, y, z, blockBox);
                    if (currState == null || currState.method_26215()) continue;
                    this.method_14917(world, blockState, x, y, z, blockBox);
                }
            }
        }
    }

    protected void replaceNonAir(class_5281 world, class_3341 blockBox, Random random, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockSetSelector selector) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2680 currState = this.getBlockAtFixed((class_1922)world, x, y, z, blockBox);
                    if (currState == null || currState.method_26215()) continue;
                    this.method_14917(world, selector.get(random), x, y, z, blockBox);
                }
            }
        }
    }

    protected void chanceFill(class_5281 world, class_3341 blockBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, class_2680 blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (!(random.nextFloat() < chance)) continue;
                    this.method_14917(world, blockState, x, y, z, blockBox);
                }
            }
        }
    }

    protected void chanceFill(class_5281 world, class_3341 blockBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockSetSelector selector) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (!(random.nextFloat() < chance)) continue;
                    this.method_14917(world, selector.get(random), x, y, z, blockBox);
                }
            }
        }
    }

    protected void chanceReplaceAir(class_5281 world, class_3341 blockBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, class_2680 blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2680 currState;
                    if (!(random.nextFloat() < chance) || (currState = this.getBlockAtFixed((class_1922)world, x, y, z, blockBox)) == null || !currState.method_26215()) continue;
                    this.method_14917(world, blockState, x, y, z, blockBox);
                }
            }
        }
    }

    protected void chanceReplaceAir(class_5281 world, class_3341 blockBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockSetSelector selector) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2680 currState;
                    if (!(random.nextFloat() < chance) || (currState = this.getBlockAtFixed((class_1922)world, x, y, z, blockBox)) == null || !currState.method_26215()) continue;
                    this.method_14917(world, selector.get(random), x, y, z, blockBox);
                }
            }
        }
    }

    protected void chanceReplaceNonAir(class_5281 world, class_3341 blockBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, class_2680 blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2680 currState;
                    if (!(random.nextFloat() < chance) || (currState = this.getBlockAtFixed((class_1922)world, x, y, z, blockBox)) == null || currState.method_26215()) continue;
                    this.method_14917(world, blockState, x, y, z, blockBox);
                }
            }
        }
    }

    protected void chanceReplaceNonAir(class_5281 world, class_3341 blockBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockSetSelector selector) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2680 currState;
                    if (!(random.nextFloat() < chance) || (currState = this.getBlockAtFixed((class_1922)world, x, y, z, blockBox)) == null || currState.method_26215()) continue;
                    this.method_14917(world, selector.get(random), x, y, z, blockBox);
                }
            }
        }
    }

    protected void chanceAddBlock(class_5281 world, Random random, float chance, class_2680 block, int x, int y, int z, class_3341 blockBox) {
        if (random.nextFloat() < chance) {
            this.method_14917(world, block, x, y, z, blockBox);
        }
    }

    protected class_2680 getBlockAtFixed(class_1922 blockView, int x, int y, int z, class_3341 blockBox) {
        int k;
        int j;
        int i = this.method_14928(x, z);
        class_2338 blockPos = new class_2338(i, j = this.method_14924(y), k = this.method_14941(x, z));
        return !blockBox.method_14662((class_2382)blockPos) ? null : blockView.method_8320(blockPos);
    }

    protected boolean isTouchingLiquid(class_1922 world, class_3341 box) {
        int y;
        int x;
        int minX = Math.max(this.field_15315.method_35415() - 1, box.method_35415());
        int minY = Math.max(this.field_15315.method_35416() - 1, box.method_35416());
        int minZ = Math.max(this.field_15315.method_35417() - 1, box.method_35417());
        int maxX = Math.min(this.field_15315.method_35418() + 1, box.method_35418());
        int maxY = Math.min(this.field_15315.method_35419() + 1, box.method_35419());
        int maxZ = Math.min(this.field_15315.method_35420() + 1, box.method_35420());
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                if (world.method_8320((class_2338)mutable.method_10103(x, minY, z)).method_26207().method_15797()) {
                    return true;
                }
                if (!world.method_8320((class_2338)mutable.method_10103(x, maxY, z)).method_26207().method_15797()) continue;
                return true;
            }
        }
        for (x = minX; x <= maxX; ++x) {
            for (y = minY; y <= maxY; ++y) {
                if (world.method_8320((class_2338)mutable.method_10103(x, y, minZ)).method_26207().method_15797()) {
                    return true;
                }
                if (!world.method_8320((class_2338)mutable.method_10103(x, y, maxZ)).method_26207().method_15797()) continue;
                return true;
            }
        }
        for (int z = minZ; z <= maxZ; ++z) {
            for (y = minY; y <= maxY; ++y) {
                if (world.method_8320((class_2338)mutable.method_10103(minX, y, z)).method_26207().method_15797()) {
                    return true;
                }
                if (!world.method_8320((class_2338)mutable.method_10103(maxX, y, z)).method_26207().method_15797()) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isInOcean(class_5281 world, int localX, int localZ) {
        class_2338.class_2339 pos = new class_2338.class_2339(this.method_14928(localX, localZ), 1, this.method_14941(localX, localZ));
        return world.method_23753((class_2338)pos).method_8688() == class_1959.class_1961.field_9367;
    }
}

