/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.yungnickyoung.minecraft.bettermineshafts.BetterMineshafts;
import com.yungnickyoung.minecraft.bettermineshafts.world.BetterMineshaftStructure;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftStructurePieceType;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.MineshaftPiece;
import com.yungnickyoung.minecraft.yungsapi.world.BoundingBoxHelper;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_6130;

public class OreDeposit
extends MineshaftPiece {
    private OreType oreType;
    private static final int SECONDARY_AXIS_LEN = 5;
    private static final int Y_AXIS_LEN = 5;
    private static final int MAIN_AXIS_LEN = 4;
    private static final int LOCAL_X_END = 4;
    private static final int LOCAL_Y_END = 4;
    private static final int LOCAL_Z_END = 3;

    public OreDeposit(class_3218 world, class_2487 compoundTag) {
        super(BetterMineshaftStructurePieceType.ORE_DEPOSIT, compoundTag);
        this.oreType = OreType.valueOf(compoundTag.method_10550("OreType"));
    }

    public OreDeposit(int chunkPieceLen, Random random, class_3341 blockBox, class_2350 direction, BetterMineshaftStructure.Type type) {
        super(BetterMineshaftStructurePieceType.ORE_DEPOSIT, chunkPieceLen, type, blockBox);
        this.method_14926(direction);
    }

    @Override
    protected void method_14943(class_3218 world, class_2487 tag) {
        super.method_14943(world, tag);
        tag.method_10569("OreType", this.oreType.value);
    }

    public static class_3341 determineBoxPosition(class_6130 structurePiecesHolder, Random random, int x, int y, int z, class_2350 direction) {
        class_3341 blockBox = BoundingBoxHelper.boxFromCoordsWithRotation((int)x, (int)y, (int)z, (int)5, (int)5, (int)4, (class_2350)direction);
        class_3443 intersectingPiece = structurePiecesHolder.method_35461(blockBox);
        return intersectingPiece != null ? null : blockBox;
    }

    @Override
    public void method_14918(class_3443 structurePiece, class_6130 structurePiecesHolder, Random random) {
        int r = random.nextInt(100);
        for (OreType oreType : OreType.values()) {
            if (r >= oreType.threshold) continue;
            this.oreType = oreType;
            break;
        }
        if (OreType.DIAMOND.threshold != 100) {
            BetterMineshafts.LOGGER.error("Your ore spawn chances don't add up to 100! Ores won't spawn as you intend!");
        }
        if (this.oreType == null) {
            this.oreType = OreType.COBBLE;
        }
    }

    public boolean method_14931(class_5281 world, class_5138 structureAccessor, class_2794 generator, Random random, class_3341 box, class_1923 pos, class_2338 blockPos) {
        if (this.isTouchingLiquid((class_1922)world, box)) {
            return false;
        }
        if (this.isInOcean(world, 0, 0) || this.isInOcean(world, 4, 3)) {
            return false;
        }
        class_2680 COBBLE = class_2246.field_10445.method_9564();
        class_2680 ORE_BLOCK = this.oreType.getBlock();
        this.chanceReplaceNonAir(world, box, random, 0.9f, 0, 0, 0, 4, 4, 3, COBBLE);
        this.chanceReplaceNonAir(world, box, random, 0.65f, 1, 1, 1, 3, 3, 2, ORE_BLOCK);
        this.chanceReplaceNonAir(world, box, random, 0.15f, 0, 0, 0, 4, 4, 3, ORE_BLOCK);
        return true;
    }

    public static enum OreType {
        COBBLE(0, class_2246.field_10445.method_9564(), BetterMineshafts.CONFIG.ores.cobble),
        COAL(1, class_2246.field_10418.method_9564(), BetterMineshafts.CONFIG.ores.coal + OreType.COBBLE.threshold),
        IRON(2, class_2246.field_10212.method_9564(), BetterMineshafts.CONFIG.ores.iron + OreType.COAL.threshold),
        REDSTONE(3, class_2246.field_10080.method_9564(), BetterMineshafts.CONFIG.ores.redstone + OreType.IRON.threshold),
        GOLD(4, class_2246.field_10571.method_9564(), BetterMineshafts.CONFIG.ores.gold + OreType.REDSTONE.threshold),
        LAPIS(5, class_2246.field_10090.method_9564(), BetterMineshafts.CONFIG.ores.lapis + OreType.GOLD.threshold),
        EMERALD(6, class_2246.field_10013.method_9564(), BetterMineshafts.CONFIG.ores.emerald + OreType.LAPIS.threshold),
        DIAMOND(7, class_2246.field_10442.method_9564(), BetterMineshafts.CONFIG.ores.diamond + OreType.EMERALD.threshold);

        private final int value;
        private final class_2680 block;
        private final int threshold;

        private OreType(int value, class_2680 block, int threshold) {
            this.value = value;
            this.block = block;
            this.threshold = threshold;
        }

        public static OreType valueOf(int value) {
            return Arrays.stream(OreType.values()).filter(oreType -> oreType.value == value).findFirst().get();
        }

        public class_2680 getBlock() {
            return this.block;
        }
    }
}

