/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.api.lock;

import java.awt.Color;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public abstract class KeyLockItem
extends Item {
    public static final String TAG_COLOR1 = "color1";
    public static final String TAG_COLOR2 = "color2";
    public static final String TAG_KEYLOCK_ID = "keyid";

    public KeyLockItem(Item.Properties properties) {
        super(properties.func_200917_a(1));
    }

    public int func_77619_b() {
        return 20;
    }

    @Nullable
    public UUID getID(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof KeyLockItem) {
            CompoundNBT tag = itemStack.func_196082_o();
            if (!tag.func_186855_b(TAG_KEYLOCK_ID)) {
                UUID uuid = UUID.randomUUID();
                this.setID(itemStack, uuid);
                return uuid;
            }
            return tag.func_186857_a(TAG_KEYLOCK_ID);
        }
        return null;
    }

    public void setID(ItemStack itemStack, UUID uuid) {
        if (itemStack.func_77973_b() instanceof KeyLockItem) {
            CompoundNBT tag = itemStack.func_196082_o();
            tag.func_186854_a(TAG_KEYLOCK_ID, uuid);
            itemStack.func_77982_d(tag);
        }
    }

    public void func_77622_d(ItemStack stack, World worldIn, PlayerEntity playerIn) {
        if (!worldIn.field_72995_K) {
            this.ensureHasID(stack);
        }
    }

    protected void ensureHasID(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof KeyLockItem) {
            CompoundNBT tag = itemStack.func_77978_p();
            if (tag == null) {
                tag = new CompoundNBT();
            }
            if (!tag.func_186855_b(TAG_KEYLOCK_ID)) {
                tag.func_186854_a(TAG_KEYLOCK_ID, UUID.randomUUID());
                itemStack.func_77982_d(tag);
            }
        }
    }

    public static int getKeyColor1(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof KeyLockItem) {
            CompoundNBT tag;
            if (itemStack.func_77942_o() && (tag = itemStack.func_77978_p()).func_74764_b(TAG_COLOR1)) {
                return tag.func_74762_e(TAG_COLOR1);
            }
            return MaterialColor.field_151647_F.field_76291_p;
        }
        return Color.WHITE.getRGB();
    }

    public static void setKeyColor1(ItemStack itemStack, int color) {
        if (itemStack.func_77973_b() instanceof KeyLockItem) {
            CompoundNBT tag = itemStack.func_77978_p();
            if (tag == null) {
                tag = new CompoundNBT();
            }
            tag.func_74768_a(TAG_COLOR1, color);
            itemStack.func_77982_d(tag);
        }
    }

    public static boolean hasKeyColor1(ItemStack itemStack) {
        return itemStack.func_77973_b() instanceof KeyLockItem && itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b(TAG_COLOR1);
    }

    public static int getKeyColor2(ItemStack itemStack) {
        CompoundNBT tag;
        if (itemStack.func_77973_b() instanceof KeyLockItem && itemStack.func_77942_o() && (tag = itemStack.func_77978_p()).func_74764_b(TAG_COLOR2)) {
            return tag.func_74762_e(TAG_COLOR2);
        }
        return KeyLockItem.getKeyColor1(itemStack);
    }

    public static void setKeyColor2(ItemStack itemStack, int color) {
        if (itemStack.func_77973_b() instanceof KeyLockItem) {
            CompoundNBT tag = itemStack.func_77978_p();
            if (tag == null) {
                tag = new CompoundNBT();
            }
            tag.func_74768_a(TAG_COLOR2, color);
            itemStack.func_77982_d(tag);
        }
    }

    public static boolean hasKeyColor2(ItemStack itemStack) {
        return itemStack.func_77973_b() instanceof KeyLockItem && itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b(TAG_COLOR2);
    }

    public static void clearColors(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            CompoundNBT tag = itemStack.func_77978_p();
            tag.func_82580_o(TAG_COLOR1);
            tag.func_82580_o(TAG_COLOR2);
            itemStack.func_77982_d(tag);
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (flagIn.func_194127_a() && stack.func_77942_o()) {
            CompoundNBT tag = stack.func_77978_p();
            if (tag.func_186855_b(TAG_KEYLOCK_ID)) {
                tooltip.add((ITextComponent)new TranslationTextComponent("Keytag : " + tag.func_186857_a(TAG_KEYLOCK_ID)));
            }
            if (tag.func_74764_b(TAG_COLOR1)) {
                tooltip.add((ITextComponent)new TranslationTextComponent("Color 1 : #" + Integer.toHexString(tag.func_74762_e(TAG_COLOR1)).toUpperCase()));
            }
            if (tag.func_74764_b(TAG_COLOR2)) {
                tooltip.add((ITextComponent)new TranslationTextComponent("Color 2 : #" + Integer.toHexString(tag.func_74762_e(TAG_COLOR2)).toUpperCase()));
            }
        }
    }
}

