/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.client.model.xobj;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import io.github.tehstoneman.betterstorage.client.model.xobj.XOBJModel;
import java.io.IOException;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.obj.LineReader;
import net.minecraftforge.client.model.obj.MaterialLibrary;

public class XOBJLoader
implements IModelLoader<XOBJModel> {
    public static XOBJLoader INSTANCE = new XOBJLoader();
    private final Map<XOBJModel.ModelSettings, XOBJModel> modelCache = Maps.newHashMap();
    private final Map<ResourceLocation, MaterialLibrary> materialCache = Maps.newHashMap();
    private IResourceManager manager = Minecraft.func_71410_x().func_195551_G();

    public void func_195410_a(IResourceManager resourceManager) {
        this.modelCache.clear();
        this.materialCache.clear();
        this.manager = resourceManager;
    }

    public XOBJModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
        if (!modelContents.has("model")) {
            throw new RuntimeException("XOBJ Loader requires a 'model' key that points to a valid .OBJ model.");
        }
        String modelLocation = modelContents.get("model").getAsString();
        boolean detectCullableFaces = JSONUtils.func_151209_a((JsonObject)modelContents, (String)"detectCullableFaces", (boolean)true);
        boolean diffuseLighting = JSONUtils.func_151209_a((JsonObject)modelContents, (String)"diffuseLighting", (boolean)false);
        boolean flipV = JSONUtils.func_151209_a((JsonObject)modelContents, (String)"flip-v", (boolean)false);
        boolean ambientToFullbright = JSONUtils.func_151209_a((JsonObject)modelContents, (String)"ambientToFullbright", (boolean)true);
        String materialLibraryOverrideLocation = modelContents.has("materialLibraryOverride") ? JSONUtils.func_151200_h((JsonObject)modelContents, (String)"materialLibraryOverride") : null;
        return this.loadModel(new XOBJModel.ModelSettings(new ResourceLocation(modelLocation), detectCullableFaces, diffuseLighting, flipV, ambientToFullbright, materialLibraryOverrideLocation));
    }

    public XOBJModel loadModel(XOBJModel.ModelSettings settings) {
        return this.modelCache.computeIfAbsent(settings, data -> {
            IResource resource;
            try {
                resource = this.manager.func_199002_a(settings.modelLocation);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not find OBJ model", e);
            }
            try (LineReader reader = new LineReader(resource);){
                XOBJModel xOBJModel = new XOBJModel(reader, settings);
                return xOBJModel;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not read OBJ model", e);
            }
        });
    }
}

