/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.client.renderer.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import io.github.tehstoneman.betterstorage.api.ConnectedType;
import io.github.tehstoneman.betterstorage.client.renderer.Resources;
import io.github.tehstoneman.betterstorage.client.renderer.tileentity.model.ChestModel;
import io.github.tehstoneman.betterstorage.client.renderer.tileentity.model.LargeChestModel;
import io.github.tehstoneman.betterstorage.common.block.BetterStorageBlocks;
import io.github.tehstoneman.betterstorage.common.block.BlockConnectableContainer;
import io.github.tehstoneman.betterstorage.common.block.BlockReinforcedChest;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityReinforcedChest;
import io.github.tehstoneman.betterstorage.common.world.storage.HexKeyConfig;
import io.github.tehstoneman.betterstorage.config.BetterStorageConfig;
import io.github.tehstoneman.betterstorage.util.BetterStorageResource;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;

public class TileEntityReinforcedChestRenderer
extends TileEntityRenderer<TileEntityReinforcedChest> {
    private final ChestModel simpleChest = new ChestModel();
    private final ChestModel largeChest = new LargeChestModel();
    private HexKeyConfig config;
    private static ItemRenderer itemRenderer;
    private static BlockRendererDispatcher blockRenderer;
    private static ModelManager modelManager;

    public TileEntityReinforcedChestRenderer(TileEntityRendererDispatcher rendererDispatcher) {
        super(rendererDispatcher);
    }

    public void render(TileEntityReinforcedChest tileEntity, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        BlockState blockState = tileEntity.func_145830_o() ? tileEntity.func_195044_w() : (BlockState)((BlockReinforcedChest)BetterStorageBlocks.REINFORCED_CHEST.get()).func_176223_P().func_206870_a((Property)BlockReinforcedChest.FACING, (Comparable)Direction.SOUTH);
        ConnectedType chestType = blockState.func_235901_b_(BlockConnectableContainer.TYPE) ? (ConnectedType)((Object)blockState.func_177229_b(BlockConnectableContainer.TYPE)) : ConnectedType.SINGLE;
        Direction facing = (Direction)blockState.func_177229_b((Property)BlockReinforcedChest.FACING);
        if (chestType != ConnectedType.SLAVE) {
            boolean flag;
            matrixStack.func_227860_a_();
            this.config = tileEntity.getConfig();
            boolean bl = flag = chestType != ConnectedType.SINGLE;
            if (blockRenderer == null) {
                blockRenderer = Minecraft.func_71410_x().func_175602_ab();
            }
            if (modelManager == null) {
                modelManager = Minecraft.func_71410_x().func_209506_al();
            }
            float f = facing.func_185119_l();
            matrixStack.func_227861_a_(0.5, 0.5, 0.5);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-f));
            matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
            if (((Boolean)BetterStorageConfig.CLIENT.useObjModels.get()).booleanValue()) {
                Item item;
                IBakedModel modelBase = modelManager.getModel((ResourceLocation)(chestType == ConnectedType.SINGLE ? Resources.MODEL_REINFORCED_CHEST : Resources.MODEL_REINFORCED_CHEST_LARGE));
                IBakedModel modelLid = modelManager.getModel((ResourceLocation)(chestType == ConnectedType.SINGLE ? Resources.MODEL_REINFORCED_CHEST_LID : Resources.MODEL_REINFORCED_CHEST_LID_LARGE));
                IBakedModel modelFrame = modelManager.getModel((ResourceLocation)(chestType == ConnectedType.SINGLE ? Resources.MODEL_REINFORCED_CHEST_FRAME : Resources.MODEL_REINFORCED_CHEST_LARGE_FRAME));
                IBakedModel modelLidFrame = modelManager.getModel((ResourceLocation)(chestType == ConnectedType.SINGLE ? Resources.MODEL_REINFORCED_CHEST_LID_FRAME : Resources.MODEL_REINFORCED_CHEST_LID_LARGE_FRAME));
                World world = tileEntity.func_145831_w();
                BlockPos pos = tileEntity.func_174877_v();
                IVertexBuilder renderBufferChest = buffer.getBuffer(Atlases.func_228782_g_());
                RenderMaterial material = new RenderMaterial(PlayerContainer.field_226615_c_, (ResourceLocation)Resources.TEXTURE_REINFORCED_FRAME);
                ItemStack itemStack = this.config.getStackInSlot(HexKeyConfig.SLOT_APPEARANCE);
                if (!itemStack.func_190926_b() && (item = itemStack.func_77973_b()) instanceof BlockItem) {
                    BlockState state = ((BlockItem)item).func_179223_d().func_176223_P();
                    TextureAtlasSprite texture = Minecraft.func_71410_x().func_175602_ab().func_175023_a().getTexture(state, world, pos);
                    material = new RenderMaterial(PlayerContainer.field_226615_c_, texture.func_195668_m());
                }
                IVertexBuilder renderBufferFrame = material.func_229311_a_(buffer, RenderType::func_228634_a_);
                IModelData data = modelBase.getModelData((IBlockDisplayReader)world, pos, blockState, ModelDataManager.getModelData((World)world, (BlockPos)pos));
                MatrixStack.Entry currentMatrix = matrixStack.func_227866_c_();
                blockRenderer.func_175019_b().renderModel(currentMatrix, renderBufferChest, null, modelBase, 1.0f, 1.0f, 1.0f, combinedLight, combinedOverlay, data);
                blockRenderer.func_175019_b().renderModel(currentMatrix, renderBufferFrame, null, modelFrame, 1.0f, 1.0f, 1.0f, combinedLight, combinedOverlay, data);
                this.rotateLid(tileEntity, partialTicks, matrixStack);
                blockRenderer.func_175019_b().renderModel(currentMatrix, renderBufferChest, null, modelLid, 1.0f, 1.0f, 1.0f, combinedLight, combinedOverlay, data);
                blockRenderer.func_175019_b().renderModel(currentMatrix, renderBufferFrame, null, modelLidFrame, 1.0f, 1.0f, 1.0f, combinedLight, combinedOverlay, data);
            } else {
                ChestModel modelChest = this.getChestModel(tileEntity, flag);
                RenderMaterial material = this.getMaterial(tileEntity, flag);
                IVertexBuilder vertexBuilder = material.func_229311_a_(buffer, RenderType::func_228634_a_);
                this.rotateLid(tileEntity, partialTicks, modelChest);
                modelChest.func_225598_a_(matrixStack, vertexBuilder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            this.renderItem(tileEntity, partialTicks, matrixStack, buffer, combinedLight, blockState);
            matrixStack.func_227865_b_();
        }
    }

    private ChestModel getChestModel(TileEntityReinforcedChest tileEntityChest, boolean flag) {
        return flag ? this.largeChest : this.simpleChest;
    }

    protected RenderMaterial getMaterial(TileEntityReinforcedChest tileEntity, boolean flag) {
        BetterStorageResource resourcelocation = flag ? Resources.TEXTURE_CHEST_REINFORCED_DOUBLE : Resources.TEXTURE_CHEST_REINFORCED;
        return new RenderMaterial(PlayerContainer.field_226615_c_, (ResourceLocation)resourcelocation);
    }

    private void rotateLid(TileEntityReinforcedChest tileEntityChest, float partialTicks, ChestModel modelchest) {
        float angle = tileEntityChest.func_195480_a(partialTicks);
        angle = 1.0f - angle;
        angle = 1.0f - angle * angle * angle;
        modelchest.rotateLid(angle);
    }

    private void rotateLid(TileEntityReinforcedChest tileEntityChest, float partialTicks, MatrixStack matrixStack) {
        float angle = tileEntityChest.func_195480_a(partialTicks);
        angle = 1.0f - angle;
        angle = 1.0f - angle * angle * angle;
        matrixStack.func_227861_a_(0.0, 0.5625, 0.0);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_(-angle));
    }

    private void renderItem(TileEntityReinforcedChest chest, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, BlockState state) {
        ItemStack itemstack = chest.getLock();
        if (!itemstack.func_190926_b()) {
            if (itemRenderer == null) {
                itemRenderer = Minecraft.func_71410_x().func_175599_af();
            }
            matrixStack.func_227861_a_(chest.isConnected() ? 1.0 : 0.5, -0.1875, 0.9375);
            matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
            itemRenderer.func_229110_a_(itemstack, ItemCameraTransforms.TransformType.FIXED, packedLight, OverlayTexture.field_229196_a_, matrixStack, buffer);
        }
    }
}

