/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.block;

import io.github.tehstoneman.betterstorage.api.ConnectedType;
import io.github.tehstoneman.betterstorage.api.lock.ILock;
import io.github.tehstoneman.betterstorage.api.lock.LockInteraction;
import io.github.tehstoneman.betterstorage.common.block.BlockLocker;
import io.github.tehstoneman.betterstorage.common.enchantment.EnchantmentBetterStorage;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityContainer;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityReinforcedLocker;
import io.github.tehstoneman.betterstorage.common.world.storage.HexKeyConfig;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BlockReinforcedLocker
extends BlockLocker {
    public BlockReinforcedLocker() {
        this(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(5.0f, 6.0f).func_200947_a(SoundType.field_185848_a));
    }

    public BlockReinforcedLocker(AbstractBlock.Properties properties) {
        super(properties);
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityReinforcedLocker();
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (hit.func_216354_b() == state.func_177229_b((Property)FACING)) {
            if (!worldIn.field_72995_K) {
                TileEntityReinforcedLocker tileChest = BlockReinforcedLocker.getLockerAt(worldIn, pos);
                if (tileChest != null && tileChest.isLocked()) {
                    if (!tileChest.unlockWith(player.func_184586_b(hand))) {
                        ItemStack lock = tileChest.getLock();
                        ((ILock)lock.func_77973_b()).applyEffects(lock, tileChest, player, LockInteraction.OPEN);
                        return ActionResultType.PASS;
                    }
                    if (player.func_213453_ef()) {
                        worldIn.func_217376_c((Entity)new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), tileChest.getLock().func_77946_l()));
                        tileChest.setLock(ItemStack.field_190927_a);
                        return ActionResultType.SUCCESS;
                    }
                }
                return super.func_225533_a_(state, worldIn, pos, player, hand, hit);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Nullable
    public static TileEntityReinforcedLocker getLockerAt(World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityReinforcedLocker) {
            return (TileEntityReinforcedLocker)tileEntity;
        }
        return null;
    }

    @Override
    public BlockState func_196271_a(BlockState thisState, Direction facing, BlockState facingState, IWorld world, BlockPos thisPos, BlockPos facingPos) {
        if (((Boolean)thisState.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(thisPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        if (facingState.func_177230_c() == this && facing.func_176740_k().func_200128_b()) {
            ConnectedType facingType = (ConnectedType)((Object)facingState.func_177229_b((Property)TYPE));
            if (thisState.func_177229_b((Property)TYPE) == ConnectedType.SINGLE && facingType != ConnectedType.SINGLE && thisState.func_177229_b((Property)FACING) == facingState.func_177229_b((Property)FACING) && BlockReinforcedLocker.getDirectionToAttached(facingState) == facing.func_176734_d()) {
                ConnectedType newType = facingType.opposite();
                TileEntityReinforcedLocker thisLocker = BlockReinforcedLocker.getLockerAt((World)world, thisPos);
                TileEntityReinforcedLocker facingLocker = BlockReinforcedLocker.getLockerAt((World)world, facingPos);
                if (newType == ConnectedType.SLAVE) {
                    facingLocker.setConfig(thisLocker.getConfig());
                    thisLocker.setConfig(new HexKeyConfig());
                }
                return (BlockState)thisState.func_206870_a((Property)TYPE, (Comparable)((Object)newType));
            }
        } else if (BlockReinforcedLocker.getDirectionToAttached(thisState) == facing) {
            return (BlockState)thisState.func_206870_a((Property)TYPE, (Comparable)((Object)ConnectedType.SINGLE));
        }
        return super.func_196271_a(thisState, facing, facingState, world, thisPos, facingPos);
    }

    @Override
    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = world.func_175625_s(pos);
            if (tileentity instanceof TileEntityContainer) {
                if (state.func_177229_b((Property)TYPE) == ConnectedType.MASTER) {
                    TileEntityReinforcedLocker thisLocker = BlockReinforcedLocker.getLockerAt(world, pos);
                    TileEntityReinforcedLocker facingLocker = BlockReinforcedLocker.getLockerAt(world, pos.func_177972_a(BlockReinforcedLocker.getDirectionToAttached(state)));
                    facingLocker.setConfig(thisLocker.getConfig());
                    thisLocker.setConfig(new HexKeyConfig());
                }
                ((TileEntityContainer)tileentity).dropInventoryItems();
                world.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        TileEntity tileEntity = blockAccess.func_175625_s(pos);
        if (tileEntity instanceof TileEntityReinforcedLocker) {
            TileEntityReinforcedLocker chest = (TileEntityReinforcedLocker)tileEntity;
            return chest.isPowered() ? MathHelper.func_76125_a((int)chest.getPlayersUsing(), (int)0, (int)15) : 0;
        }
        return 0;
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return side == Direction.UP ? blockState.func_185911_a(blockAccess, pos, side) : 0;
    }

    public float getExplosionResistance(BlockState state, IBlockReader world, BlockPos pos, Explosion explosion) {
        TileEntityReinforcedLocker chest = BlockReinforcedLocker.getLockerAt((World)world, pos);
        if (chest != null && chest.isLocked()) {
            int resist = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)EnchantmentBetterStorage.PERSISTANCE.get()), (ItemStack)chest.getLock()) + 1;
            return super.getExplosionResistance(state, world, pos, explosion) * (float)resist * 2.0f;
        }
        return super.getExplosionResistance(state, world, pos, explosion);
    }
}

