/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.capabilities;

import io.github.tehstoneman.betterstorage.api.IHexKeyConfig;
import io.github.tehstoneman.betterstorage.common.world.storage.HexKeyConfig;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class CapabilityConfig {
    @CapabilityInject(value=IHexKeyConfig.class)
    public static final Capability<IHexKeyConfig> CONFIG_CAPABILITY = null;
    public static ResourceLocation CAPABILITY_RESOURCE = new ResourceLocation("betterstorage", "config");

    public static void register() {
        CapabilityManager.INSTANCE.register(IHexKeyConfig.class, (Capability.IStorage)new Capability.IStorage<IHexKeyConfig>(){

            public INBT writeNBT(Capability<IHexKeyConfig> capability, IHexKeyConfig instance, Direction side) {
                ListNBT nbtTagList = new ListNBT();
                int size = instance.getSlots();
                for (int i = 0; i < size; ++i) {
                    ItemStack stack = instance.getStackInSlot(i);
                    if (stack.func_190926_b()) continue;
                    CompoundNBT itemTag = new CompoundNBT();
                    itemTag.func_74768_a("Slot", i);
                    stack.func_77955_b(itemTag);
                    nbtTagList.add((Object)itemTag);
                }
                return nbtTagList;
            }

            public void readNBT(Capability<IHexKeyConfig> capability, IHexKeyConfig instance, Direction side, INBT nbt) {
                ListNBT tagList = (ListNBT)nbt;
                for (int i = 0; i < tagList.size(); ++i) {
                    CompoundNBT itemTags = tagList.func_150305_b(i);
                    int j = itemTags.func_74762_e("Slot");
                    if (j < 0 || j >= instance.getSlots()) continue;
                    instance.setStackInSlot(j, ItemStack.func_199557_a((CompoundNBT)itemTags));
                }
            }
        }, HexKeyConfig::new);
    }

    public static class Provider
    implements ICapabilitySerializable<CompoundNBT> {
        public IHexKeyConfig hexKeyConfig;
        private final LazyOptional<IHexKeyConfig> capabilityHandler = LazyOptional.of(() -> this.hexKeyConfig);

        public Provider() {
            this.hexKeyConfig = new HexKeyConfig();
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction side) {
            return CONFIG_CAPABILITY.orEmpty(capability, this.capabilityHandler);
        }

        public CompoundNBT serializeNBT() {
            return (CompoundNBT)this.hexKeyConfig.serializeNBT();
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.hexKeyConfig.deserializeNBT((INBT)nbt);
        }
    }
}

