/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.inventory;

import io.github.tehstoneman.betterstorage.common.block.BetterStorageBlocks;
import io.github.tehstoneman.betterstorage.common.inventory.BetterStorageContainerTypes;
import io.github.tehstoneman.betterstorage.common.inventory.CrateSlotHandler;
import io.github.tehstoneman.betterstorage.common.inventory.CrateStackHandler;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityCrate;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ContainerCrate
extends Container {
    private final IItemHandler inventoryCrate;
    private final TileEntityCrate tileCrate;
    private final int rows;
    public int indexStart;
    public int indexPlayer;
    public int indexHotbar;
    private final IntReferenceHolder volume = IntReferenceHolder.func_221492_a();

    public ContainerCrate(int windowID, PlayerInventory playerInventory, World world, BlockPos pos) {
        super((ContainerType)BetterStorageContainerTypes.CRATE.get(), windowID);
        int y;
        int x;
        int i;
        this.tileCrate = (TileEntityCrate)world.func_175625_s(pos);
        this.inventoryCrate = (IItemHandler)this.tileCrate.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElse((Object)new CrateStackHandler(18));
        this.rows = Math.min(this.tileCrate.getCapacity() / 9, 6);
        this.indexStart = 0;
        this.indexHotbar = this.rows * 9;
        this.indexPlayer = this.indexHotbar + 9;
        List<Integer> slotList = ((CrateStackHandler)this.inventoryCrate).getShuffledIndexes(this.indexHotbar);
        for (int i2 = 0; i2 < this.indexHotbar; ++i2) {
            int x2 = i2 % 9 * 18 + 8;
            int y2 = i2 / 9 * 18 + 18;
            this.func_75146_a((Slot)new CrateSlotHandler(this.inventoryCrate, slotList.get(i2), x2, y2));
        }
        int offsetY = 17 + this.rows * 18;
        for (i = 0; i < 27; ++i) {
            x = i % 9 * 18 + 8;
            y = 14 + i / 9 * 18;
            this.func_75146_a(new Slot((IInventory)playerInventory, i + 9, x, y + offsetY));
        }
        for (i = 0; i < 9; ++i) {
            x = i % 9 * 18 + 8;
            y = 72;
            this.func_75146_a(new Slot((IInventory)playerInventory, i, x, 72 + offsetY));
        }
        this.func_216958_a(this.volume);
    }

    public int getRows() {
        return this.rows;
    }

    public int getVolume() {
        return this.volume.func_221495_b();
    }

    public void func_75142_b() {
        this.volume.func_221494_a(((CrateStackHandler)this.inventoryCrate).getOccupiedSlots() * 100 / this.inventoryCrate.getSlots());
        super.func_75142_b();
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        ItemStack returnStack = ItemStack.field_190927_a;
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemStack = slot.func_75211_c();
            returnStack = itemStack.func_77946_l();
            if (index < this.indexHotbar ? !this.func_75135_a(itemStack, this.indexHotbar, this.field_75151_b.size(), true) : !this.func_75135_a(itemStack, 0, this.indexHotbar, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemStack.func_190916_E() > 0) {
                ((CrateStackHandler)this.inventoryCrate).addItems(itemStack);
            }
            if (itemStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return returnStack;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        ((CrateStackHandler)this.inventoryCrate).consolidateStacks();
        this.tileCrate.func_70296_d();
    }

    protected boolean func_75135_a(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        boolean flag = super.func_75135_a(stack, startIndex, endIndex, reverseDirection);
        if (!flag && endIndex <= this.indexHotbar) {
            flag = ((CrateStackHandler)this.inventoryCrate).mergeItemStack(stack, 0, this.inventoryCrate.getSlots()) == 0;
        }
        return flag;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return ContainerCrate.func_216963_a((IWorldPosCallable)IWorldPosCallable.func_221488_a((World)this.tileCrate.func_145831_w(), (BlockPos)this.tileCrate.func_174877_v()), (PlayerEntity)playerIn, (Block)((Block)BetterStorageBlocks.CRATE.get()));
    }
}

