/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.inventory;

import io.github.tehstoneman.betterstorage.common.block.BetterStorageBlocks;
import io.github.tehstoneman.betterstorage.common.inventory.BetterStorageContainerTypes;
import io.github.tehstoneman.betterstorage.common.inventory.ExpandableStackHandler;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityContainer;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ContainerReinforcedLocker
extends Container {
    private final IItemHandler inventoryContainer;
    private final TileEntityContainer tileContainer;
    private final int columns;
    private final int rows;
    public int indexStart;
    public int indexPlayer;
    public int indexHotbar;

    public ContainerReinforcedLocker(int windowId, PlayerInventory playerInventory, World world, BlockPos pos) {
        super((ContainerType)BetterStorageContainerTypes.REINFORCED_LOCKER.get(), windowId);
        int y;
        int x;
        int i;
        this.tileContainer = (TileEntityContainer)world.func_175625_s(pos);
        this.tileContainer.openInventory(playerInventory.field_70458_d);
        this.inventoryContainer = (IItemHandler)this.tileContainer.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElse(null);
        if (this.inventoryContainer instanceof ExpandableStackHandler) {
            this.columns = ((ExpandableStackHandler)this.inventoryContainer).getColumns();
            this.rows = ((ExpandableStackHandler)this.inventoryContainer).getRows();
        } else {
            this.columns = 9;
            this.rows = 3;
        }
        this.indexStart = 0;
        this.indexHotbar = this.rows * this.columns;
        this.indexPlayer = this.indexHotbar + 9;
        for (int i2 = 0; i2 < this.indexHotbar; ++i2) {
            int x2 = i2 % this.columns * 18 + 8;
            int y2 = i2 / this.columns * 18 + 18;
            this.func_75146_a((Slot)new SlotItemHandler(this.inventoryContainer, i2, x2, y2));
        }
        int offsetX = (this.columns * 18 - 162) / 2;
        int offsetY = this.rows * 18 + 18;
        for (i = 0; i < 27; ++i) {
            x = i % 9 * 18 + 8;
            y = 14 + i / 9 * 18;
            this.func_75146_a(new Slot((IInventory)playerInventory, i + 9, offsetX + x, offsetY + y));
        }
        for (i = 0; i < 9; ++i) {
            x = i % 9 * 18 + 8;
            y = 72;
            this.func_75146_a(new Slot((IInventory)playerInventory, i, offsetX + x, offsetY + 72));
        }
    }

    public int getColumns() {
        return this.columns;
    }

    public int getRows() {
        return this.rows;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        this.tileContainer.closeInventory(playerIn);
        super.func_75134_a(playerIn);
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        ItemStack returnStack = ItemStack.field_190927_a;
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemStack = slot.func_75211_c();
            returnStack = itemStack.func_77946_l();
            if (index < this.indexHotbar ? !this.func_75135_a(itemStack, this.indexHotbar, this.field_75151_b.size(), true) : !this.func_75135_a(itemStack, 0, this.indexHotbar, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return returnStack;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return ContainerReinforcedLocker.func_216963_a((IWorldPosCallable)IWorldPosCallable.func_221488_a((World)this.tileContainer.func_145831_w(), (BlockPos)this.tileContainer.func_174877_v()), (PlayerEntity)playerIn, (Block)((Block)BetterStorageBlocks.REINFORCED_LOCKER.get()));
    }
}

