/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.item.cardboard;

import io.github.tehstoneman.betterstorage.api.cardboard.ICardboardItem;
import io.github.tehstoneman.betterstorage.common.block.BetterStorageBlocks;
import io.github.tehstoneman.betterstorage.common.item.BlockItemBetterStorage;
import io.github.tehstoneman.betterstorage.config.BetterStorageConfig;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public class ItemBlockCardboardBox
extends BlockItemBetterStorage
implements ICardboardItem {
    public ItemBlockCardboardBox() {
        super((Block)BetterStorageBlocks.CARDBOARD_BOX.get(), new Item.Properties());
    }

    public boolean showDurabilityBar(ItemStack stack) {
        int maxUses = ItemBlockCardboardBox.getMaxUses();
        if (maxUses > 1 && stack.func_77942_o()) {
            int uses = maxUses;
            CompoundNBT nbt = stack.func_77978_p();
            if (nbt.func_74764_b("Uses")) {
                uses = Math.min(maxUses, nbt.func_74762_e("Uses"));
            }
            return uses < maxUses;
        }
        return false;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        CompoundNBT nbt;
        int maxUses;
        int uses = maxUses = ItemBlockCardboardBox.getMaxUses();
        if (stack.func_77942_o() && (nbt = stack.func_77978_p()).func_74764_b("Uses")) {
            uses = Math.min(maxUses, nbt.func_74762_e("Uses"));
        }
        return 1.0 - (double)((float)uses / (float)maxUses);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_77942_o()) {
            if (flagIn.func_194127_a()) {
                boolean hasItems;
                int maxUses = ItemBlockCardboardBox.getMaxUses();
                boolean bl = hasItems = stack.func_77942_o() && stack.func_77978_p().func_74764_b("Inventory");
                if (!hasItems) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.betterstorage.cardboard_box.use_hint" + (maxUses > 0 ? ".reusable" : Integer.valueOf(0))));
                }
                if (maxUses > 1) {
                    int uses = maxUses;
                    if (stack.func_77978_p().func_74764_b("Uses")) {
                        uses = Math.min(maxUses, stack.func_77978_p().func_74762_e("Uses"));
                    }
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.betterstorage.cardboard_box.uses", new Object[]{uses}));
                }
            }
            if (((Boolean)BetterStorageConfig.CLIENT.cardboardBoxShowContents.get()).booleanValue() && stack.func_77942_o() && stack.func_77978_p().func_74764_b("Inventory")) {
                ItemStackHandler contents = new ItemStackHandler(9);
                contents.deserializeNBT((CompoundNBT)stack.func_77978_p().func_74781_a("Inventory"));
                int limit = 4;
                int count = 0;
                int more = 0;
                for (int i = 0; i < contents.getSlots(); ++i) {
                    ItemStack contentStack = contents.getStackInSlot(i);
                    if (contentStack.func_190926_b()) continue;
                    if (count < 4) {
                        ++count;
                        IFormattableTextComponent text = contentStack.func_200301_q().func_230532_e_();
                        text.func_240702_b_(" x").func_240702_b_(String.valueOf(contentStack.func_190916_E()));
                        tooltip.add((ITextComponent)text);
                        continue;
                    }
                    ++more;
                }
                if (more > 0) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.betterstorage.cardboard_box.plus_more", new Object[]{more}).func_240699_a_(TextFormatting.ITALIC));
                }
            }
        }
    }

    public static int getMaxUses() {
        return (Integer)BetterStorageConfig.COMMON.cardboardBoxUses.get();
    }
}

