/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.tehstoneman.betterstorage.api.lock.IKey;
import io.github.tehstoneman.betterstorage.common.item.crafting.BetterStorageRecipes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CopyKeyRecipe
extends SpecialRecipe {
    static int MAX_WIDTH = 3;
    static int MAX_HEIGHT = 3;
    private int recipeWidth;
    private int recipeHeight;
    private NonNullList<Ingredient> recipeItems;
    private ItemStack recipeOutput;

    public CopyKeyRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    public CopyKeyRecipe(ResourceLocation idIn, String groupIn, int recipeWidthIn, int recipeHeightIn, NonNullList<Ingredient> recipeItemsIn, ItemStack recipeOutputIn) {
        super(idIn);
        this.recipeWidth = recipeWidthIn;
        this.recipeHeight = recipeHeightIn;
        this.recipeItems = recipeItemsIn;
        this.recipeOutput = recipeOutputIn;
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        for (int i = 0; i <= inv.func_174922_i() - this.recipeWidth; ++i) {
            for (int j = 0; j <= inv.func_174923_h() - this.recipeHeight; ++j) {
                if (this.checkMatch(inv, i, j, true)) {
                    return true;
                }
                if (!this.checkMatch(inv, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(CraftingInventory craftingInventory, int p_77573_2_, int p_77573_3_, boolean p_77573_4_) {
        for (int i = 0; i < craftingInventory.func_174922_i(); ++i) {
            for (int j = 0; j < craftingInventory.func_174923_h(); ++j) {
                int k = i - p_77573_2_;
                int l = j - p_77573_3_;
                Ingredient ingredient = Ingredient.field_193370_a;
                if (k >= 0 && l >= 0 && k < this.recipeWidth && l < this.recipeHeight) {
                    ingredient = p_77573_4_ ? (Ingredient)this.recipeItems.get(this.recipeWidth - k - 1 + l * this.recipeWidth) : (Ingredient)this.recipeItems.get(k + l * this.recipeWidth);
                }
                if (ingredient.test(craftingInventory.func_70301_a(i + j * craftingInventory.func_174922_i()))) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack func_77571_b() {
        return this.recipeOutput;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        ItemStack outputStack = this.func_77571_b().func_77946_l();
        if (!outputStack.func_190926_b()) {
            CompoundNBT tagCompound = outputStack.func_196082_o();
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack ingredientStack = inv.func_70301_a(i);
                if (ingredientStack.func_190926_b() || !(ingredientStack.func_77973_b() instanceof IKey) || !ingredientStack.func_77942_o()) continue;
                tagCompound.func_197643_a(ingredientStack.func_77978_p());
            }
            outputStack.func_77982_d(tagCompound);
        }
        return outputStack;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList ret = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < ret.size(); ++i) {
            ItemStack itemStack = inv.func_70301_a(i);
            if (itemStack.func_190926_b()) continue;
            if (itemStack.func_77973_b() instanceof IKey) {
                ret.set(i, (Object)itemStack.func_77946_l());
                continue;
            }
            ret.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemStack));
        }
        return ret;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= this.recipeWidth && height >= this.recipeHeight;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return BetterStorageRecipes.COPY_KEY;
    }

    public boolean func_192399_d() {
        return false;
    }

    private static Map<String, Ingredient> deserializeKey(JsonObject json) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : json.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put(entry.getKey(), Ingredient.func_199802_a((JsonElement)((JsonElement)entry.getValue())));
        }
        map.put(" ", Ingredient.field_193370_a);
        return map;
    }

    @VisibleForTesting
    static String[] shrink(String ... toShrink) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int i1 = 0; i1 < toShrink.length; ++i1) {
            String s = toShrink[i1];
            i = Math.min(i, CopyKeyRecipe.firstNonSpace(s));
            int j1 = CopyKeyRecipe.lastNonSpace(s);
            j = Math.max(j, j1);
            if (j1 < 0) {
                if (k == i1) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (toShrink.length == l) {
            return new String[0];
        }
        String[] astring = new String[toShrink.length - l - k];
        for (int k1 = 0; k1 < astring.length; ++k1) {
            astring[k1] = toShrink[k1 + k].substring(i, j + 1);
        }
        return astring;
    }

    private static int firstNonSpace(String str) {
        int i;
        for (i = 0; i < str.length() && str.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int lastNonSpace(String str) {
        int i;
        for (i = str.length() - 1; i >= 0 && str.charAt(i) == ' '; --i) {
        }
        return i;
    }

    private static String[] patternFromJson(JsonArray jsonArr) {
        String[] astring = new String[jsonArr.size()];
        if (astring.length > MAX_HEIGHT) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, " + MAX_HEIGHT + " is maximum");
        }
        if (astring.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < astring.length; ++i) {
            String s = JSONUtils.func_151206_a((JsonElement)jsonArr.get(i), (String)("pattern[" + i + "]"));
            if (s.length() > MAX_WIDTH) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, " + MAX_WIDTH + " is maximum");
            }
            if (i > 0 && astring[0].length() != s.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            astring[i] = s;
        }
        return astring;
    }

    private static NonNullList<Ingredient> deserializeIngredients(String[] pattern, Map<String, Ingredient> keys, int patternWidth, int patternHeight) {
        NonNullList nonnulllist = NonNullList.func_191197_a((int)(patternWidth * patternHeight), (Object)Ingredient.field_193370_a);
        HashSet set = Sets.newHashSet(keys.keySet());
        set.remove(" ");
        for (int i = 0; i < pattern.length; ++i) {
            for (int j = 0; j < pattern[i].length(); ++j) {
                String s = pattern[i].substring(j, j + 1);
                Ingredient ingredient = keys.get(s);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + s + "' but it's not defined in the key");
                }
                set.remove(s);
                nonnulllist.set(j + patternWidth * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return nonnulllist;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<CopyKeyRecipe> {
        public CopyKeyRecipe read(ResourceLocation recipeId, JsonObject json) {
            String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            Map map = CopyKeyRecipe.deserializeKey(JSONUtils.func_152754_s((JsonObject)json, (String)"key"));
            String[] astring = CopyKeyRecipe.shrink(CopyKeyRecipe.patternFromJson(JSONUtils.func_151214_t((JsonObject)json, (String)"pattern")));
            int i = astring[0].length();
            int j = astring.length;
            NonNullList nonnulllist = CopyKeyRecipe.deserializeIngredients(astring, map, i, j);
            ItemStack itemstack = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            return new CopyKeyRecipe(recipeId, s, i, j, (NonNullList<Ingredient>)nonnulllist, itemstack);
        }

        public CopyKeyRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            int i = buffer.func_150792_a();
            int j = buffer.func_150792_a();
            String s = buffer.func_150789_c(Short.MAX_VALUE);
            NonNullList nonnulllist = NonNullList.func_191197_a((int)(i * j), (Object)Ingredient.field_193370_a);
            for (int k = 0; k < nonnulllist.size(); ++k) {
                nonnulllist.set(k, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            ItemStack itemstack = buffer.func_150791_c();
            return new CopyKeyRecipe(recipeId, s, i, j, (NonNullList<Ingredient>)nonnulllist, itemstack);
        }

        public void write(PacketBuffer buffer, CopyKeyRecipe recipe) {
            buffer.func_150787_b(recipe.recipeWidth);
            buffer.func_150787_b(recipe.recipeHeight);
            buffer.func_180714_a(recipe.func_193358_e());
            for (Ingredient ingredient : recipe.recipeItems) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_150788_a(recipe.func_77571_b());
        }
    }
}

