/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.item.crafting;

import com.google.common.collect.Lists;
import io.github.tehstoneman.betterstorage.api.lock.KeyLockItem;
import io.github.tehstoneman.betterstorage.common.item.crafting.BetterStorageRecipes;
import java.util.ArrayList;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;

public class KeyColorRecipe
extends SpecialRecipe {
    public KeyColorRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        ItemStack resultStack = ItemStack.field_190927_a;
        ArrayList dyeList = Lists.newArrayList();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack itemStack = inv.func_70301_a(i);
            if (itemStack.func_190926_b()) continue;
            if (itemStack.func_77973_b() instanceof KeyLockItem) {
                if (!resultStack.func_190926_b()) {
                    return false;
                }
                resultStack = itemStack;
                continue;
            }
            if (!itemStack.func_77973_b().func_206844_a((ITag)Tags.Items.DYES)) {
                return false;
            }
            dyeList.add(itemStack);
        }
        return !resultStack.func_190926_b() && !dyeList.isEmpty() && dyeList.size() <= 2;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        ItemStack resultStack = ItemStack.field_190927_a;
        CompoundNBT tagCompound = new CompoundNBT();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack ingredientStack = inv.func_70301_a(i);
            if (ingredientStack.func_190926_b()) continue;
            Item item = ingredientStack.func_77973_b();
            if (item instanceof KeyLockItem) {
                if (!resultStack.func_190926_b()) {
                    return ItemStack.field_190927_a;
                }
                KeyLockItem.clearColors(ingredientStack);
                resultStack = ingredientStack.func_77946_l();
                if (!ingredientStack.func_77942_o()) continue;
                tagCompound.func_197643_a(ingredientStack.func_77978_p());
                continue;
            }
            if (item.func_206844_a((ITag)Tags.Items.DYES)) {
                DyeColor dyeColor = DyeColor.getColor((ItemStack)ingredientStack);
                if (!tagCompound.func_74764_b("color1")) {
                    tagCompound.func_74768_a("color1", dyeColor.func_196060_f());
                    continue;
                }
                if (tagCompound.func_74764_b("color2")) continue;
                tagCompound.func_74768_a("color2", dyeColor.func_196060_f());
                continue;
            }
            return ItemStack.field_190927_a;
        }
        resultStack.func_77982_d(tagCompound);
        return resultStack;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return BetterStorageRecipes.COLOR_KEY;
    }

    public boolean func_192399_d() {
        return true;
    }
}

