/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.item.locking;

import io.github.tehstoneman.betterstorage.api.lock.IKey;
import io.github.tehstoneman.betterstorage.common.inventory.ContainerKeyring;
import io.github.tehstoneman.betterstorage.common.inventory.KeyringCapabilityProvider;
import io.github.tehstoneman.betterstorage.common.item.BetterStorageItems;
import io.github.tehstoneman.betterstorage.common.item.ItemBetterStorage;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemKeyring
extends ItemBetterStorage
implements IKey,
INamedContainerProvider {
    public ItemKeyring() {
        super(new Item.Properties());
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_213453_ef()) {
            return new ActionResult(ActionResultType.PASS, (Object)stack);
        }
        if (!world.field_72995_K) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)BetterStorageItems.KEYRING.get()), buf -> buf.func_150788_a(player.func_184586_b(hand)).writeInt(player.field_71071_by.field_70461_c));
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    @Override
    public boolean unlock(ItemStack keyring, ItemStack lock, boolean useAbility) {
        IItemHandler inventory = (IItemHandler)keyring.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElse(null);
        if (inventory != null) {
            for (int i = 0; i < inventory.getSlots(); ++i) {
                IKey keyType;
                ItemStack key = inventory.getStackInSlot(i);
                if (key.func_190926_b() || !(keyType = (IKey)key.func_77973_b()).unlock(key, lock, false)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canApplyEnchantment(ItemStack key, Enchantment enchantment) {
        return false;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new KeyringCapabilityProvider(stack);
    }

    public Container createMenu(int windowID, PlayerInventory playerInventory, PlayerEntity player) {
        ItemStack itemStack = player.func_184614_ca();
        int index = player.field_71071_by.field_70461_c;
        return new ContainerKeyring(windowID, playerInventory, itemStack, index);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.betterstorage.keyring");
    }

    public float getFilledCapacity(ItemStack itemStack) {
        CompoundNBT tag;
        if (itemStack.func_77942_o() && (tag = itemStack.func_77978_p()).func_74764_b("Occupied")) {
            int occupied = tag.func_74762_e("Occupied");
            return (float)occupied / 9.0f;
        }
        return 0.0f;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT tag;
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (flagIn.func_194127_a() && stack.func_77942_o() && (tag = stack.func_77978_p()).func_74764_b("Occupied")) {
            tooltip.add((ITextComponent)new TranslationTextComponent("Keys : " + tag.func_74762_e("Occupied")));
        }
    }
}

