/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.tileentity;

import io.github.tehstoneman.betterstorage.api.ConnectedType;
import io.github.tehstoneman.betterstorage.common.block.BlockConnectableContainer;
import io.github.tehstoneman.betterstorage.common.inventory.ConnectedStackHandler;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityContainer;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class TileEntityConnectable
extends TileEntityContainer {
    public ConnectedStackHandler connectedInventory;
    private final LazyOptional<IItemHandler> connectedHandler = LazyOptional.of(() -> this.connectedInventory);

    public TileEntityConnectable(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (this.isConnected()) {
            if (this.isMain()) {
                if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                    this.connectedInventory = new ConnectedStackHandler(this.inventory, this.getConnectedTileEntity().inventory);
                    return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(capability, this.connectedHandler);
                }
            } else {
                return this.getMainTileEntity().getCapability(capability, facing);
            }
        }
        return super.getCapability(capability, facing);
    }

    public abstract BlockPos getConnected();

    public boolean isConnected() {
        BlockState state = this.func_195044_w();
        if (state.func_235901_b_(BlockConnectableContainer.TYPE)) {
            return state.func_177229_b(BlockConnectableContainer.TYPE) != ConnectedType.SINGLE;
        }
        return false;
    }

    public boolean isMain() {
        BlockState state = this.func_195044_w();
        if (state.func_235901_b_(BlockConnectableContainer.TYPE)) {
            return state.func_177229_b(BlockConnectableContainer.TYPE) == ConnectedType.SINGLE || state.func_177229_b(BlockConnectableContainer.TYPE) == ConnectedType.MASTER;
        }
        return true;
    }

    public TileEntityConnectable getMainTileEntity() {
        if (this.isMain()) {
            return this;
        }
        TileEntityConnectable connectable = this.getConnectedTileEntity();
        if (connectable != null) {
            return connectable;
        }
        return this;
    }

    public TileEntityConnectable getConnectedTileEntity() {
        if (this.func_145831_w() == null || !this.isConnected()) {
            return null;
        }
        TileEntity tileEntity = this.func_145831_w().func_175625_s(this.getConnected());
        return tileEntity instanceof TileEntityConnectable ? (TileEntityConnectable)tileEntity : null;
    }

    public void func_70296_d() {
        if (!this.isMain()) {
            this.getConnectedTileEntity().func_70296_d();
        }
        super.func_70296_d();
    }

    protected abstract String getConnectableName();

    public ITextComponent func_200200_C_() {
        return new TranslationTextComponent(this.getConnectableName().concat(this.isConnected() ? "_large" : ""));
    }
}

