/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.tileentity;

import io.github.tehstoneman.betterstorage.api.ConnectedType;
import io.github.tehstoneman.betterstorage.api.IHasConfig;
import io.github.tehstoneman.betterstorage.api.IHexKeyConfig;
import io.github.tehstoneman.betterstorage.api.lock.IKey;
import io.github.tehstoneman.betterstorage.api.lock.IKeyLockable;
import io.github.tehstoneman.betterstorage.common.block.BlockConnectableContainer;
import io.github.tehstoneman.betterstorage.common.block.BlockReinforcedChest;
import io.github.tehstoneman.betterstorage.common.capabilities.CapabilityConfig;
import io.github.tehstoneman.betterstorage.common.enchantment.EnchantmentBetterStorage;
import io.github.tehstoneman.betterstorage.common.inventory.ConfigContainer;
import io.github.tehstoneman.betterstorage.common.inventory.ReinforcedChestContainer;
import io.github.tehstoneman.betterstorage.common.item.BetterStorageItems;
import io.github.tehstoneman.betterstorage.common.tileentity.BetterStorageTileEntityTypes;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityConnectable;
import io.github.tehstoneman.betterstorage.common.world.storage.HexKeyConfig;
import io.github.tehstoneman.betterstorage.config.BetterStorageConfig;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.IChestLid;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

@OnlyIn(value=Dist.CLIENT, _interface=IChestLid.class)
public class TileEntityReinforcedChest
extends TileEntityConnectable
implements IChestLid,
ITickableTileEntity,
IKeyLockable,
IHasConfig {
    protected int ticksSinceSync;
    private ItemStack lock = ItemStack.field_190927_a.func_77946_l();
    public HexKeyConfig config;
    private final LazyOptional<IHexKeyConfig> configHandler = LazyOptional.of(() -> this.config);

    public TileEntityReinforcedChest() {
        super((TileEntityType)BetterStorageTileEntityTypes.REINFORCED_CHEST.get());
        this.config = new HexKeyConfig(){

            protected void onContentsChanged(int slot) {
                TileEntityReinforcedChest.this.func_70296_d();
            }
        };
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (this.isMain()) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.isLocked() && facing != null) {
                return LazyOptional.empty();
            }
            if (capability == CapabilityConfig.CONFIG_CAPABILITY && !this.isLocked()) {
                return CapabilityConfig.CONFIG_CAPABILITY.orEmpty(capability, this.configHandler);
            }
            return super.getCapability(capability, facing);
        }
        return this.getMainTileEntity().getCapability(capability, facing);
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-1, 0, -1), this.field_174879_c.func_177982_a(2, 2, 2));
    }

    @Override
    public int getColumns() {
        return (Integer)BetterStorageConfig.COMMON.reinforcedColumns.get();
    }

    @Override
    protected String getConnectableName() {
        return "container.betterstorage.reinforced_chest";
    }

    @Override
    public BlockPos getConnected() {
        if (this.isConnected()) {
            return this.func_174877_v().func_177972_a(BlockReinforcedChest.getDirectionToAttached(this.func_195044_w()));
        }
        return this.field_174879_c;
    }

    @Override
    public void dropInventoryItems() {
        super.dropInventoryItems();
        if (!this.config.isEmpty()) {
            if (this.isConnected() && this.isMain()) {
                ((TileEntityReinforcedChest)this.getConnectedTileEntity()).setConfig(this.config);
            } else {
                for (int i = 0; i < this.config.getSlots(); ++i) {
                    ItemStack stack = this.config.getStackInSlot(i);
                    if (stack.func_190926_b()) continue;
                    InventoryHelper.func_180173_a((World)this.func_145831_w(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)stack);
                }
            }
        }
    }

    public Container createMenu(int windowID, PlayerInventory playerInventory, PlayerEntity player) {
        if (this.isMain()) {
            if (player.func_184614_ca().func_77973_b() == BetterStorageItems.HEX_KEY.get()) {
                return new ConfigContainer(windowID, playerInventory, this.func_145831_w(), this.func_174877_v());
            }
            return new ReinforcedChestContainer(windowID, playerInventory, this.func_145831_w(), this.func_174877_v());
        }
        return this.getMainTileEntity().createMenu(windowID, playerInventory, player);
    }

    public void func_73660_a() {
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o();
        int z = this.field_174879_c.func_177952_p();
        ++this.ticksSinceSync;
        if (!this.field_145850_b.field_72995_K && this.numPlayersUsing != 0 && (this.ticksSinceSync + x + y + z) % 200 == 0) {
            this.numPlayersUsing = 0;
            for (PlayerEntity entityplayer : this.field_145850_b.func_217357_a(PlayerEntity.class, new AxisAlignedBB((double)((float)x - 5.0f), (double)((float)y - 5.0f), (double)((float)z - 5.0f), (double)((float)(x + 1) + 5.0f), (double)((float)(y + 1) + 5.0f), (double)((float)(z + 1) + 5.0f)))) {
                if (!(entityplayer.field_71070_bA instanceof ReinforcedChestContainer)) continue;
                ++this.numPlayersUsing;
            }
        }
        this.prevLidAngle = this.lidAngle;
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f) {
            this.playSound(SoundEvents.field_187657_V);
        }
        if (this.numPlayersUsing == 0 && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            float f2 = this.lidAngle;
            this.lidAngle = this.numPlayersUsing > 0 ? (this.lidAngle += 0.1f) : (this.lidAngle -= 0.1f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < 0.5f && f2 >= 0.5f) {
                this.playSound(SoundEvents.field_187651_T);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    protected void playSound(SoundEvent soundIn) {
        ConnectedType chesttype = (ConnectedType)((Object)this.func_195044_w().func_177229_b(BlockConnectableContainer.TYPE));
        double x = (double)this.field_174879_c.func_177958_n() + 0.5;
        double y = (double)this.field_174879_c.func_177956_o() + 0.5;
        double z = (double)this.field_174879_c.func_177952_p() + 0.5;
        if (chesttype != ConnectedType.SINGLE) {
            Direction enumfacing = BlockReinforcedChest.getDirectionToAttached(this.func_195044_w());
            x += (double)enumfacing.func_82601_c() * 0.5;
            z += (double)enumfacing.func_82599_e() * 0.5;
        }
        this.field_145850_b.func_184148_a((PlayerEntity)null, x, y, z, soundIn, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    public float func_195480_a(float partialTicks) {
        return this.prevLidAngle + (this.lidAngle - this.prevLidAngle) * partialTicks;
    }

    @Override
    public ItemStack getLock() {
        if (this.isMain()) {
            return this.lock;
        }
        return ((IKeyLockable)((Object)this.getMainTileEntity())).getLock();
    }

    @Override
    public void setLock(ItemStack lock) {
        if (this.isMain()) {
            if (lock.func_190926_b() || this.isLockValid(lock)) {
                this.lock = lock;
                this.func_145831_w().func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
                this.setPowered(EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)EnchantmentBetterStorage.TRIGGER.get()), (ItemStack)lock) > 0);
                this.func_70296_d();
            }
        } else {
            ((IKeyLockable)((Object)this.getMainTileEntity())).setLock(lock);
        }
    }

    @Override
    public boolean canUse(PlayerEntity player) {
        return !this.isLocked() || this.getMainTileEntity().getPlayersUsing() > 0;
    }

    @Override
    public void applyTrigger() {
        this.setPowered(true);
    }

    @Override
    public boolean unlockWith(ItemStack heldItem) {
        Item item = heldItem.func_77973_b();
        return item instanceof IKey ? ((IKey)item).unlock(heldItem, this.getLock(), false) : false;
    }

    public boolean isPowered() {
        if (this.isMain()) {
            return EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)EnchantmentBetterStorage.TRIGGER.get()), (ItemStack)this.getLock()) > 0;
        }
        return ((TileEntityReinforcedChest)this.getMainTileEntity()).isPowered();
    }

    public void setPowered(boolean powered) {
        if (!this.isMain()) {
            ((TileEntityReinforcedChest)this.getMainTileEntity()).setPowered(powered);
            return;
        }
        Block block = this.func_195044_w().func_177230_c();
        this.func_145831_w().func_195593_d(this.field_174879_c, block);
        if (this.isConnected()) {
            this.func_145831_w().func_195593_d(this.getConnected(), block);
        }
    }

    public void renderUpdate() {
        if (this.isMain()) {
            BlockState state = this.func_195044_w();
            this.func_145831_w().func_225319_b(this.field_174879_c, state, state);
        } else {
            ((TileEntityReinforcedChest)this.getMainTileEntity()).renderUpdate();
        }
    }

    @Override
    public HexKeyConfig getConfig() {
        return this.config;
    }

    @Override
    public void setConfig(HexKeyConfig config) {
        this.config = config;
        this.func_70296_d();
    }

    @Override
    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        if (!this.config.isEmpty()) {
            nbt.func_218657_a("Config", (INBT)this.config.serializeNBT());
        }
        if (!this.lock.func_190926_b()) {
            nbt.func_218657_a("lock", (INBT)this.lock.serializeNBT());
        }
        return nbt;
    }

    public void onDataPacket(NetworkManager network, SUpdateTileEntityPacket packet) {
        CompoundNBT nbt = packet.func_148857_g();
        if (nbt.func_74764_b("Config")) {
            this.config.deserializeNBT(nbt.func_74775_l("Config"));
        } else {
            this.config = new HexKeyConfig();
        }
        if (nbt.func_74764_b("lock")) {
            CompoundNBT lockNBT = (CompoundNBT)nbt.func_74781_a("lock");
            this.lock = ItemStack.func_199557_a((CompoundNBT)lockNBT);
        } else {
            this.lock = ItemStack.field_190927_a;
        }
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    @Override
    public void handleUpdateTag(BlockState state, CompoundNBT nbt) {
        super.handleUpdateTag(state, nbt);
        if (nbt.func_74764_b("Config")) {
            this.config.deserializeNBT(nbt.func_74775_l("Config"));
        } else {
            this.config = new HexKeyConfig();
        }
        if (nbt.func_74764_b("lock")) {
            CompoundNBT lockNBT = (CompoundNBT)nbt.func_74781_a("lock");
            this.lock = ItemStack.func_199557_a((CompoundNBT)lockNBT);
        } else {
            this.lock = ItemStack.field_190927_a;
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        if (!this.config.isEmpty()) {
            nbt.func_218657_a("Config", (INBT)this.config.serializeNBT());
        }
        if (!this.lock.func_190926_b()) {
            CompoundNBT lockNBT = new CompoundNBT();
            this.lock.func_77955_b(lockNBT);
            nbt.func_218657_a("lock", (INBT)lockNBT);
        }
        return super.func_189515_b(nbt);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        if (nbt.func_74764_b("Config")) {
            this.config.deserializeNBT(nbt.func_74775_l("Config"));
        }
        if (nbt.func_74764_b("lock")) {
            CompoundNBT lockNBT = (CompoundNBT)nbt.func_74781_a("lock");
            this.lock = ItemStack.func_199557_a((CompoundNBT)lockNBT);
        } else {
            this.lock = ItemStack.field_190927_a;
        }
        super.func_230337_a_(state, nbt);
    }
}

