/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.event;

import io.github.tehstoneman.betterstorage.api.lock.IKeyLockable;
import io.github.tehstoneman.betterstorage.common.enchantment.EnchantmentBetterStorage;
import io.github.tehstoneman.betterstorage.common.fluid.BetterStorageFluids;
import io.github.tehstoneman.betterstorage.common.fluid.FluidMilk;
import io.github.tehstoneman.betterstorage.common.item.BetterStorageItems;
import io.github.tehstoneman.betterstorage.config.BetterStorageConfig;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="betterstorage")
public class BetterStorageEventHandler {
    @SubscribeEvent
    public static void onPlayerBreakSpeed(PlayerEvent.BreakSpeed event) {
        IKeyLockable lockable;
        PlayerEntity player;
        World world;
        TileEntity tileEntity;
        BlockState blockState = event.getState();
        if (blockState.hasTileEntity() && (tileEntity = (world = (player = event.getPlayer()).func_130014_f_()).func_175625_s(event.getPos())) instanceof IKeyLockable && (lockable = (IKeyLockable)tileEntity) != null && lockable.isLocked()) {
            if (((Boolean)BetterStorageConfig.COMMON.lockBreakable.get()).booleanValue()) {
                ItemStack tool = player.func_184614_ca();
                Set toolTypes = tool.getToolTypes();
                float speed = event.getOriginalSpeed() * 0.2f;
                if (!toolTypes.contains(ToolType.AXE) && !toolTypes.contains(ToolType.PICKAXE)) {
                    speed *= 0.1f;
                } else {
                    int level = Math.max(tool.getHarvestLevel(ToolType.AXE, player, blockState), tool.getHarvestLevel(ToolType.PICKAXE, player, blockState));
                    if (level < EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)EnchantmentBetterStorage.PERSISTANCE.get()), (ItemStack)lockable.getLock())) {
                        speed *= 0.1f;
                    }
                }
                event.setNewSpeed(speed);
            } else if (event.isCancelable()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack heldItem = event.getItemStack();
        if (heldItem.func_77973_b() == Items.field_151117_aB && ((Boolean)BetterStorageConfig.COMMON.useFluidMilk.get()).booleanValue()) {
            World world = event.getWorld();
            BlockPos pos = event.getPos();
            Direction face = event.getFace();
            PlayerEntity player = event.getPlayer();
            Hand hand = event.getHand();
            Boolean result = FluidUtil.getFluidHandler((World)world, (BlockPos)pos, (Direction)face).map(handler -> FluidMilk.interactFluidHandler(player, hand, handler)).orElse(false);
            if (!result.booleanValue()) {
                FluidActionResult fluidActionResult = FluidUtil.tryPlaceFluid((PlayerEntity)player, (World)world, (Hand)hand, (BlockPos)pos.func_177972_a(face), (ItemStack)new ItemStack((IItemProvider)BetterStorageItems.MILK_BUCKET.get()), (FluidStack)new FluidStack((Fluid)BetterStorageFluids.MILK.get(), 1000));
                result = fluidActionResult.isSuccess();
            }
            if (result.booleanValue()) {
                event.setCancellationResult(ActionResultType.SUCCESS);
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
                if (!event.getPlayer().func_184812_l_()) {
                    event.getPlayer().func_184611_a(hand, new ItemStack((IItemProvider)Items.field_151133_ar));
                }
            }
        }
    }
}

