/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.api;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.IStringSerializable;

public enum EnumReinforced implements IStringSerializable
{
    IRON(0, "iron", "ingotIron", "blockIron"),
    GOLD(1, "gold", "ingotGold", "blockGold"),
    DIAMOND(2, "diamond", "gemDiamond", "blockDiamond"),
    EMERALD(3, "emerald", "gemEmerald", "blockEmerald"),
    COPPER(4, "copper", "ingotCopper", "blockCopper"),
    TIN(5, "tin", "ingotTin", "blockTin"),
    SILVER(6, "silver", "ingotSilver", "blockSilver"),
    ZINC(7, "zinc", "ingotZinc", "blockZinc"),
    STEEL(8, "steel", "ingotSteel", "blockSteel");

    private final int meta;
    private final String name;
    private final String ingot;
    private final String block;
    private static EnumReinforced[] META_LOOKUP;
    private static Map<String, EnumReinforced> NAME_LOOKUP;

    private EnumReinforced(int meta, String name, String ingot, String block) {
        this.meta = meta;
        this.name = name;
        this.ingot = ingot;
        this.block = block;
    }

    public String toString() {
        return this.name;
    }

    public String func_176610_l() {
        return this.name;
    }

    public int getMetadata() {
        return this.meta;
    }

    public String getOreDictIngot() {
        return this.ingot;
    }

    public String getOreDictBlock() {
        return this.block;
    }

    public String getUnlocalizedName() {
        return "material.betterstorage." + this.name;
    }

    public static EnumReinforced byMetadata(int meta) {
        return META_LOOKUP[meta];
    }

    public static EnumReinforced byName(String name) {
        return NAME_LOOKUP.get(name);
    }

    static {
        META_LOOKUP = new EnumReinforced[EnumReinforced.values().length];
        NAME_LOOKUP = new HashMap<String, EnumReinforced>();
        EnumReinforced[] enumReinforcedArray = EnumReinforced.values();
        int n = enumReinforcedArray.length;
        for (int i = 0; i < n; ++i) {
            EnumReinforced material;
            EnumReinforced.META_LOOKUP[material.getMetadata()] = material = enumReinforcedArray[i];
            NAME_LOOKUP.put(material.name, material);
        }
    }
}

