/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.api.crafting;

import io.github.tehstoneman.betterstorage.api.crafting.IRecipeInput;
import io.github.tehstoneman.betterstorage.api.crafting.IStationRecipe;
import io.github.tehstoneman.betterstorage.api.crafting.RecipeBounds;
import io.github.tehstoneman.betterstorage.api.crafting.RecipeInputItemStack;
import io.github.tehstoneman.betterstorage.api.crafting.RecipeInputOreDict;
import io.github.tehstoneman.betterstorage.api.crafting.StationCrafting;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public final class BetterStorageCrafting {
    public static final List<IStationRecipe> recipes = new ArrayList<IStationRecipe>();

    private BetterStorageCrafting() {
    }

    public static void addStationRecipe(IStationRecipe recipe) {
        recipes.add(recipe);
    }

    public static StationCrafting findMatchingStationCrafting(ItemStack[] craftingIn) {
        RecipeBounds bounds = new RecipeBounds(craftingIn);
        for (IStationRecipe recipe : recipes) {
            StationCrafting craftingOut = recipe.checkMatch(craftingIn, bounds);
            if (craftingOut == null) continue;
            return craftingOut;
        }
        return null;
    }

    public static IRecipeInput makeInput(Object obj) {
        if (obj instanceof IRecipeInput) {
            return (IRecipeInput)obj;
        }
        if (obj instanceof ItemStack) {
            return new RecipeInputItemStack((ItemStack)obj);
        }
        if (obj instanceof Item) {
            return new RecipeInputItemStack(new ItemStack((Item)obj));
        }
        if (obj instanceof Block) {
            return new RecipeInputItemStack(new ItemStack((Block)obj));
        }
        if (obj instanceof String) {
            return new RecipeInputOreDict((String)obj, 1);
        }
        throw new IllegalArgumentException(String.format("Argument is %s, not an IRecipeInput, ItemStack, Item, Block or String.", obj != null ? obj.getClass().getSimpleName() : "null"));
    }
}

