/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.attachment;

import io.github.tehstoneman.betterstorage.attachment.EnumAttachmentInteraction;
import io.github.tehstoneman.betterstorage.attachment.IAttachmentRenderer;
import io.github.tehstoneman.betterstorage.utils.DirectionUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Attachment {
    public final TileEntity tileEntity;
    public final int subId;
    private double x;
    private double y;
    private double z;
    private double width;
    private double height;
    private double depth;
    private AxisAlignedBB box = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private EnumFacing direction = EnumFacing.NORTH;

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getDepth() {
        return this.depth;
    }

    public float getRotation() {
        return DirectionUtils.getRotation(this.direction);
    }

    public AxisAlignedBB getHighlightBox() {
        return this.box.func_186670_a(this.tileEntity.func_174877_v());
    }

    public Attachment(TileEntity tileEntity, int subId) {
        this.tileEntity = tileEntity;
        this.subId = subId;
    }

    public void setBox(double x, double y, double z, double width, double height, double depth, double scale) {
        this.x = x * scale;
        this.y = y * scale;
        this.z = z * scale;
        this.width = width * scale;
        this.height = height * scale;
        this.depth = depth * scale;
        this.updateBox();
    }

    public void setBox(double x, double y, double z, double width, double height, double depth) {
        this.setBox(x, y, z, width, height, depth, 0.0625);
    }

    public void setDirection(EnumFacing direction) {
        this.direction = direction;
        this.updateBox();
    }

    private void updateBox() {
        double maxZ;
        double maxX;
        double minZ;
        double minX;
        double minY = 1.0 - (this.y + this.height / 2.0);
        double maxY = 1.0 - (this.y - this.height / 2.0);
        switch (this.direction) {
            case EAST: {
                minX = 1.0 - (this.z + this.depth / 2.0);
                minZ = this.x - this.width / 2.0;
                maxX = 1.0 - (this.z - this.depth / 2.0);
                maxZ = this.x + this.width / 2.0;
                break;
            }
            case SOUTH: {
                minX = 1.0 - (this.x + this.width / 2.0);
                minZ = 1.0 - (this.z + this.depth / 2.0);
                maxX = 1.0 - (this.x - this.width / 2.0);
                maxZ = 1.0 - (this.z - this.depth / 2.0);
                break;
            }
            case WEST: {
                minX = this.z - this.depth / 2.0;
                minZ = 1.0 - (this.x + this.width / 2.0);
                maxX = this.z + this.depth / 2.0;
                maxZ = 1.0 - (this.x - this.width / 2.0);
                break;
            }
            default: {
                minX = this.x - this.width / 2.0;
                minZ = this.z - this.depth / 2.0;
                maxX = this.x + this.width / 2.0;
                maxZ = this.z + this.depth / 2.0;
            }
        }
        this.box = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public void update() {
    }

    public boolean interact(EntityPlayer player, EnumAttachmentInteraction type) {
        return false;
    }

    public ItemStack pick() {
        return null;
    }

    public boolean boxVisible(EntityPlayer player) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public abstract IAttachmentRenderer getRenderer();
}

