/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.attachment;

import io.github.tehstoneman.betterstorage.attachment.Attachment;
import io.github.tehstoneman.betterstorage.attachment.EnumAttachmentInteraction;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class Attachments
implements Iterable<Attachment> {
    public static final ThreadLocal<EntityPlayer> playerLocal = new ThreadLocal();
    public final TileEntity tileEntity;
    private final Map<Integer, Attachment> attachments = new HashMap<Integer, Attachment>();

    public Attachments(TileEntity tileEntity) {
        this.tileEntity = tileEntity;
    }

    public boolean interact(RayTraceResult target, EntityPlayer player, EnumAttachmentInteraction interactionType) {
        Attachment attachment = target != null ? this.get(target.subHit) : null;
        return attachment != null ? attachment.interact(player, interactionType) : false;
    }

    public ItemStack pick(RayTraceResult target) {
        Attachment attachment = target != null ? this.get(target.subHit) : null;
        return attachment != null ? attachment.pick() : null;
    }

    public RayTraceResult rayTrace(World world, int x, int y, int z, Vec3d start, Vec3d end) {
        AxisAlignedBB aabb = this.tileEntity.func_145838_q().func_180646_a(world.func_180495_p(new BlockPos(x, y, z)), (IBlockAccess)world, new BlockPos(x, y, z));
        RayTraceResult target = aabb.func_72327_a(start, end);
        EntityPlayer player = playerLocal.get();
        double distance = target != null ? start.func_72438_d(target.field_72307_f) : Double.MAX_VALUE;
        for (Attachment attachment : this) {
            double attachmentDistance;
            AxisAlignedBB attachmentBox;
            RayTraceResult attachmentTarget;
            if (!attachment.boxVisible(player) || (attachmentTarget = (attachmentBox = attachment.getHighlightBox()).func_72327_a(start, end)) == null || (attachmentDistance = start.func_72438_d(attachmentTarget.field_72307_f)) >= distance) continue;
            distance = attachmentDistance;
            target = attachmentTarget;
            target.subHit = attachment.subId;
        }
        return target;
    }

    public void update() {
        for (Attachment attachment : this) {
            attachment.update();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void render(float partialTicks) {
        for (Attachment attachment : this) {
            float rotation = attachment.getRotation();
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
            GL11.glPushMatrix();
            GL11.glRotatef((float)rotation, (float)0.0f, (float)-1.0f, (float)0.0f);
            GL11.glTranslated((double)(0.5 - attachment.getX()), (double)(0.5 - attachment.getY()), (double)(0.5 - attachment.getZ()));
            attachment.getRenderer().render(attachment, partialTicks);
            GL11.glPopMatrix();
            GL11.glPopMatrix();
        }
    }

    public <T extends Attachment> T add(Class<T> attachmentClass) {
        try {
            Constructor<T> constructor = attachmentClass.getConstructor(TileEntity.class, Integer.TYPE);
            Attachment attachment = (Attachment)constructor.newInstance(this.tileEntity, this.getFreeSubId());
            this.attachments.put(attachment.subId, attachment);
            return (T)attachment;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Attachment get(int subId) {
        return this.attachments.get(subId);
    }

    public void remove(Attachment attachment) {
        this.attachments.remove(attachment.subId);
    }

    public boolean has(Attachment attachment) {
        return this.attachments.containsKey(attachment.subId);
    }

    @Override
    public Iterator<Attachment> iterator() {
        return this.attachments.values().iterator();
    }

    private int getFreeSubId() {
        int freeSubId = 0;
        HashSet<Integer> takenSet = new HashSet<Integer>(this.attachments.keySet());
        while (takenSet.remove(++freeSubId)) {
        }
        return freeSubId;
    }
}

