/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.attachment;

import io.github.tehstoneman.betterstorage.BetterStorage;
import io.github.tehstoneman.betterstorage.api.BetterStorageEnchantment;
import io.github.tehstoneman.betterstorage.api.lock.EnumLockInteraction;
import io.github.tehstoneman.betterstorage.api.lock.IKey;
import io.github.tehstoneman.betterstorage.api.lock.ILock;
import io.github.tehstoneman.betterstorage.api.lock.ILockable;
import io.github.tehstoneman.betterstorage.attachment.EnumAttachmentInteraction;
import io.github.tehstoneman.betterstorage.attachment.IAttachmentRenderer;
import io.github.tehstoneman.betterstorage.attachment.ItemAttachment;
import io.github.tehstoneman.betterstorage.attachment.LockAttachmentRenderer;
import io.github.tehstoneman.betterstorage.common.enchantment.EnchantmentBetterStorage;
import io.github.tehstoneman.betterstorage.common.item.BetterStorageItems;
import io.github.tehstoneman.betterstorage.common.item.locking.ItemKeyLock;
import io.github.tehstoneman.betterstorage.utils.StackUtils;
import io.github.tehstoneman.betterstorage.utils.WorldUtils;
import java.util.logging.Logger;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LockAttachment
extends ItemAttachment {
    public int hit = 0;
    public int breakProgress = 0;
    public float wiggle = 0.0f;
    public float wiggleStrength = 0.0f;

    public LockAttachment(TileEntity tileEntity, int subId) {
        super(tileEntity, subId);
        if (!(tileEntity instanceof ILockable)) {
            throw new IllegalArgumentException("tileEntity must be ILockable.");
        }
    }

    @Override
    public boolean boxVisible(EntityPlayer player) {
        ItemStack holding = player != null ? player.func_184614_ca() : null;
        return this.item != null || StackUtils.isLock(holding);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IAttachmentRenderer getRenderer() {
        return LockAttachmentRenderer.instance;
    }

    @Override
    public void update() {
        this.hit = Math.max(-20, this.hit - 1);
        if (this.hit <= -20) {
            this.breakProgress = Math.max(0, this.breakProgress - 1);
        }
        if (this.tileEntity.func_145831_w().field_72995_K) {
            this.wiggle += 1.0f;
            this.wiggleStrength = Math.max(0.0f, this.wiggleStrength * 0.9f - 0.1f);
        }
    }

    @Override
    public boolean interact(EntityPlayer player, EnumAttachmentInteraction type) {
        ItemStack holding = player.func_184614_ca();
        return type == EnumAttachmentInteraction.attack ? this.attack(player, holding) : this.use(player, holding);
    }

    @Override
    public ItemStack pick() {
        int fullColor;
        if (this.item == null) {
            return null;
        }
        ItemStack key = new ItemStack((Item)BetterStorageItems.KEY);
        ItemKeyLock.setID(key, ItemKeyLock.getID(this.item));
        int color = ItemKeyLock.getKeyColor1(this.item);
        if (color >= 0) {
            ItemKeyLock.setKeyColor1(key, color);
        }
        if ((fullColor = ItemKeyLock.getKeyColor2(this.item)) >= 0) {
            ItemKeyLock.setKeyColor2(key, fullColor);
        }
        return key;
    }

    private boolean attack(EntityPlayer player, ItemStack holding) {
        boolean canHurt;
        ILockable lockable = (ILockable)this.tileEntity;
        ItemStack lock = lockable.getLock();
        if (lock == null) {
            return false;
        }
        boolean bl = canHurt = this.hit <= 0 && this.canHurtLock(holding);
        if (canHurt) {
            holding.func_77972_a(2, (EntityLivingBase)player);
        }
        if (!player.field_70170_p.field_72995_K) {
            Logger.getLogger("betterstorage").info("Lock Attacked");
            if (canHurt) {
                this.hit = 10;
                int persistance = BetterStorageEnchantment.getLevel(lock, EnchantmentBetterStorage.persistance);
                if (this.breakProgress > 100 * (1 + persistance)) {
                    if (lock.func_77952_i() < lock.func_77958_k()) {
                        AxisAlignedBB box = this.getHighlightBox();
                        double x = (box.field_72340_a + box.field_72336_d) / 2.0;
                        double y = (box.field_72338_b + box.field_72337_e) / 2.0;
                        double z = (box.field_72339_c + box.field_72334_f) / 2.0;
                        EntityItem entityItem = WorldUtils.spawnItem(this.tileEntity.func_145831_w(), x, y, z, lock);
                    }
                    lockable.setLock(null);
                    this.breakProgress = 0;
                }
                ((ILock)lock.func_77973_b()).applyEffects(lock, lockable, player, EnumLockInteraction.ATTACK);
            }
        } else {
            this.hit(canHurt);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void hit(boolean damage) {
        this.wiggleStrength = Math.min(20.0f, this.wiggleStrength + 12.0f);
        if (damage) {
            this.hit = 10;
            AxisAlignedBB box = this.getHighlightBox();
            double x = (box.field_72340_a + box.field_72336_d) / 2.0;
            double y = (box.field_72338_b + box.field_72337_e) / 2.0;
            double d = (box.field_72339_c + box.field_72334_f) / 2.0;
        }
    }

    private boolean use(EntityPlayer player, ItemStack holding) {
        if (player.field_70170_p.field_72995_K) {
            return false;
        }
        ILockable lockable = (ILockable)this.tileEntity;
        ItemStack lock = lockable.getLock();
        Logger.getLogger("betterstorage").info("lock : " + lock);
        if (lock.func_190926_b()) {
            if (StackUtils.isLock(holding) && lockable.isLockValid(holding)) {
                lockable.setLock(holding);
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                return true;
            }
        } else if (StackUtils.isKey(holding)) {
            IKey keyType = (IKey)holding.func_77973_b();
            ILock lockType = (ILock)lock.func_77973_b();
            boolean success = keyType.unlock(holding, lock, true);
            lockType.onUnlock(lock, holding, lockable, player, success);
            if (!success) {
                return true;
            }
            if (player.func_70093_af()) {
                AxisAlignedBB box = this.getHighlightBox();
                double x = (box.field_72340_a + box.field_72336_d) / 2.0;
                double y = (box.field_72338_b + box.field_72337_e) / 2.0;
                double z = (box.field_72339_c + box.field_72334_f) / 2.0;
                EntityItem item = WorldUtils.spawnItem(player.field_70170_p, x, y, z, lock);
                lockable.setLock(ItemStack.field_190927_a);
            } else {
                lockable.useUnlocked(player);
            }
            return true;
        }
        return false;
    }

    private boolean canHurtLock(ItemStack stack) {
        if (stack == null || !BetterStorage.config.lockBreakable) {
            return false;
        }
        Item item = stack.func_77973_b();
        return item instanceof ItemSword || item instanceof ItemPickaxe || item instanceof ItemAxe;
    }
}

