/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.client;

import io.github.tehstoneman.betterstorage.BetterStorage;
import io.github.tehstoneman.betterstorage.api.EnumReinforced;
import io.github.tehstoneman.betterstorage.client.renderer.block.statemap.SizeStateMap;
import io.github.tehstoneman.betterstorage.common.block.BetterStorageBlocks;
import io.github.tehstoneman.betterstorage.common.item.BetterStorageItems;
import io.github.tehstoneman.betterstorage.common.item.ItemBucketSlime;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ClientEvents {
    private final StateMapperBase propertyStringMapper = new StateMapperBase(){

        protected ModelResourceLocation func_178132_a(IBlockState state) {
            return new ModelResourceLocation("minecraft:air");
        }
    };

    @SubscribeEvent
    public void onRegisterModels(ModelRegistryEvent event) {
        SizeStateMap sizeStateMap = new SizeStateMap();
        if (BetterStorage.config.crateEnabled) {
            this.registerItemModel(BetterStorageBlocks.CRATE);
        }
        if (BetterStorage.config.reinforcedChestEnabled) {
            ModelLoader.setCustomStateMapper((Block)BetterStorageBlocks.REINFORCED_CHEST, (IStateMapper)sizeStateMap);
            for (EnumReinforced material : EnumReinforced.values()) {
                this.registerItemModel(BetterStorageBlocks.REINFORCED_CHEST, material.getMetadata(), BetterStorageBlocks.REINFORCED_CHEST.getRegistryName() + "_" + material.func_176610_l());
            }
        }
        if (BetterStorage.config.lockerEnabled) {
            ModelLoader.setCustomStateMapper((Block)BetterStorageBlocks.LOCKER, (IStateMapper)sizeStateMap);
            this.registerItemModel(BetterStorageBlocks.LOCKER);
            if (BetterStorage.config.reinforcedLockerEnabled) {
                ModelLoader.setCustomStateMapper((Block)BetterStorageBlocks.REINFORCED_LOCKER, (IStateMapper)sizeStateMap);
                for (EnumReinforced material : EnumReinforced.values()) {
                    this.registerItemModel(BetterStorageBlocks.REINFORCED_LOCKER, material.getMetadata(), BetterStorageBlocks.REINFORCED_LOCKER.getRegistryName() + "_" + material.func_176610_l());
                }
            }
        }
        if (BetterStorage.config.flintBlockEnabled) {
            this.registerItemModel(BetterStorageBlocks.BLOCK_FLINT);
        }
        if (BetterStorage.config.keyEnabled) {
            this.registerItemModel(BetterStorageItems.KEY);
            if (BetterStorage.config.masterKeyEnabled) {
                this.registerItemModel(BetterStorageItems.MASTER_KEY);
            }
            if (BetterStorage.config.keyringEnabled) {
                for (int i = 0; i < 4; ++i) {
                    this.registerItemModel((Item)BetterStorageItems.KEYRING, i, new ModelResourceLocation(BetterStorageItems.KEYRING.getRegistryName() + "_" + i, "inventory"));
                }
            }
            if (BetterStorage.config.lockEnabled) {
                this.registerItemModel(BetterStorageItems.LOCK);
            }
        }
        if (BetterStorage.config.cardboardSheetEnabled) {
            this.registerItemModel(BetterStorageItems.CARDBOARD_SHEET);
        }
        if (BetterStorage.config.cardboardBoxEnabled) {
            this.registerItemModel(BetterStorageBlocks.CARDBOARD_BOX);
        }
        if (BetterStorage.config.cardboardSwordEnabled) {
            this.registerItemModel((Item)BetterStorageItems.CARDBOARD_SWORD);
        }
        if (BetterStorage.config.cardboardShovelEnabled) {
            this.registerItemModel((Item)BetterStorageItems.CARDBOARD_SHOVEL);
        }
        if (BetterStorage.config.cardboardPickaxeEnabled) {
            this.registerItemModel((Item)BetterStorageItems.CARDBOARD_PICKAXE);
        }
        if (BetterStorage.config.cardboardAxeEnabled) {
            this.registerItemModel((Item)BetterStorageItems.CARDBOARD_AXE);
        }
        if (BetterStorage.config.cardboardHoeEnabled) {
            this.registerItemModel((Item)BetterStorageItems.CARDBOARD_HOE);
        }
        if (BetterStorage.config.cardboardHelmetEnabled) {
            this.registerItemModel((Item)BetterStorageItems.CARDBOARD_HELMET);
        }
        if (BetterStorage.config.cardboardChestplateEnabled) {
            this.registerItemModel((Item)BetterStorageItems.CARDBOARD_CHESTPLATE);
        }
        if (BetterStorage.config.cardboardLeggingsEnabled) {
            this.registerItemModel((Item)BetterStorageItems.CARDBOARD_LEGGINGS);
        }
        if (BetterStorage.config.cardboardBootsEnabled) {
            this.registerItemModel((Item)BetterStorageItems.CARDBOARD_BOOTS);
        }
        if (BetterStorage.config.slimeBucketEnabled) {
            for (ItemBucketSlime.EnumSlime slime : ItemBucketSlime.EnumSlime.values()) {
                this.registerItemModel((Item)BetterStorageItems.SLIME_BUCKET, slime.getMetadata(), BetterStorageItems.SLIME_BUCKET.getRegistryName() + "_" + slime.getResourceLocation().func_110623_a());
            }
        }
    }

    private void registerBlockItemModelForMeta(IBlockState state, int metadata) {
        Item item = Item.func_150898_a((Block)state.func_177230_c());
        if (item != Items.field_190931_a) {
            this.registerItemModel(item, metadata, this.propertyStringMapper.func_178131_a((Map)state.func_177228_b()));
        }
    }

    private void registerItemModel(Block block) {
        Item item = Item.func_150898_a((Block)block);
        if (item != Items.field_190931_a) {
            this.registerItemModel(item);
        }
    }

    private void registerItemModel(Block block, int metadata, String modelLocation) {
        Item item = Item.func_150898_a((Block)block);
        if (item != Items.field_190931_a) {
            this.registerItemModel(item, metadata, modelLocation);
        }
    }

    private void registerItemModel(Item item) {
        ResourceLocation registryName = item.getRegistryName();
        this.registerItemModel(item, registryName.toString());
    }

    private void registerItemModel(Item item, String modelLocation) {
        ModelResourceLocation fullModelLocation = new ModelResourceLocation(modelLocation, "inventory");
        this.registerItemModel(item, fullModelLocation);
    }

    private void registerItemModel(Item item, int meta, String modelLocation) {
        ModelResourceLocation fullModelLocation = new ModelResourceLocation(modelLocation, "inventory");
        this.registerItemModel(item, meta, fullModelLocation);
    }

    private void registerItemModel(Item item, ModelResourceLocation fullModelLocation) {
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{fullModelLocation});
        this.registerItemModel(item, stack -> fullModelLocation);
    }

    private void registerItemModel(Item item, ItemMeshDefinition meshDefinition) {
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)meshDefinition);
    }

    private void registerItemModel(Item item, int metadata, ModelResourceLocation modelResourceLocation) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)metadata, (ModelResourceLocation)modelResourceLocation);
    }
}

