/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.client.renderer;

import io.github.tehstoneman.betterstorage.common.block.BetterStorageBlocks;
import io.github.tehstoneman.betterstorage.common.block.BlockLockable;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityReinforcedChest;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TileEntityReinforcedChestRenderer
extends TileEntitySpecialRenderer<TileEntityReinforcedChest> {
    protected static BlockRendererDispatcher blockRenderer;

    public void render(TileEntityReinforcedChest chest, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (!chest.isMain()) {
            return;
        }
        GlStateManager.func_179123_a();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179101_C();
        BlockPos pos = chest.func_174877_v();
        ChunkCache world = MinecraftForgeClient.getRegionRenderCache((World)chest.func_145831_w(), (BlockPos)pos);
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == BetterStorageBlocks.REINFORCED_CHEST) {
            state = state.func_177226_a((IProperty)BlockLockable.MATERIAL, (Comparable)((Object)chest.getMaterial()));
            state = state.func_177226_a((IProperty)BlockLockable.CONNECTED, (Comparable)Boolean.valueOf(chest.isConnected()));
            if (blockRenderer == null) {
                blockRenderer = Minecraft.func_71410_x().func_175602_ab();
            }
            GlStateManager.func_179137_b((double)0.5, (double)0.0, (double)0.5);
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D);
            GlStateManager.func_179114_b((float)(180.0f - facing.func_185119_l()), (float)0.0f, (float)1.0f, (float)0.0f);
            if (chest.isConnected() && (facing == EnumFacing.NORTH || facing == EnumFacing.EAST)) {
                GlStateManager.func_179137_b((double)0.5, (double)0.0, (double)-0.5);
            } else {
                GlStateManager.func_179137_b((double)-0.5, (double)0.0, (double)-0.5);
            }
            this.renderBase(chest, partialTicks, destroyStage, state);
            this.renderLid(chest, partialTicks, destroyStage, state);
            this.renderItem(chest, partialTicks, destroyStage, state);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179099_b();
    }

    private void renderBase(TileEntityReinforcedChest chest, float partialTicks, int destroyStage, IBlockState state) {
        GlStateManager.func_179094_E();
        RenderHelper.func_74518_a();
        this.func_147499_a(TextureMap.field_110575_b);
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        World world = chest.func_145831_w();
        GlStateManager.func_179109_b((float)(-chest.func_174877_v().func_177958_n()), (float)(-chest.func_174877_v().func_177956_o()), (float)(-chest.func_174877_v().func_177952_p()));
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        IBakedModel model = blockRenderer.func_175023_a().func_178125_b(state.func_177226_a((IProperty)Properties.StaticProperty, (Comparable)Boolean.valueOf(true)));
        blockRenderer.func_175019_b().func_178267_a((IBlockAccess)world, model, state, chest.func_174877_v(), buffer, false);
        tessellator.func_78381_a();
        RenderHelper.func_74519_b();
        GlStateManager.func_179121_F();
    }

    private void renderLid(TileEntityReinforcedChest chest, float partialTicks, int destroyStage, IBlockState state) {
        GlStateManager.func_179094_E();
        RenderHelper.func_74518_a();
        this.func_147499_a(TextureMap.field_110575_b);
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        float openAngle = chest.prevLidAngle + (chest.lidAngle - chest.prevLidAngle) * partialTicks;
        openAngle = 1.0f - openAngle;
        openAngle = 1.0f - openAngle * openAngle * openAngle;
        GlStateManager.func_179137_b((double)0.0, (double)0.59375, (double)0.9375);
        GlStateManager.func_179114_b((float)(openAngle *= 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)0.0, (double)-0.59375, (double)-0.9375);
        World world = chest.func_145831_w();
        GlStateManager.func_179109_b((float)(-chest.func_174877_v().func_177958_n()), (float)(-chest.func_174877_v().func_177956_o()), (float)(-chest.func_174877_v().func_177952_p()));
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder VertexBuffer = tessellator.func_178180_c();
        VertexBuffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        IBakedModel model = blockRenderer.func_175023_a().func_178125_b(state.func_177226_a((IProperty)Properties.StaticProperty, (Comparable)Boolean.valueOf(false)));
        blockRenderer.func_175019_b().func_178267_a((IBlockAccess)world, model, state, chest.func_174877_v(), tessellator.func_178180_c(), false);
        tessellator.func_78381_a();
        RenderHelper.func_74519_b();
        GlStateManager.func_179121_F();
    }

    private void renderItem(TileEntityReinforcedChest chest, float partialTicks, int destroyStage, IBlockState state) {
        ItemStack itemstack = chest.getLock();
        if (!itemstack.func_190926_b()) {
            EntityItem entityitem = new EntityItem(chest.func_145831_w(), 0.0, 0.0, 0.0, itemstack);
            Item item = entityitem.func_92059_d().func_77973_b();
            GlStateManager.func_179094_E();
            GlStateManager.func_179140_f();
            RenderItem itemRenderer = Minecraft.func_71410_x().func_175599_af();
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            double x = chest.isConnected() ? 0.0 : -0.5;
            double y = 0.375;
            double z = -0.03125;
            GlStateManager.func_179137_b((double)x, (double)0.375, (double)-0.03125);
            GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
            GlStateManager.func_179123_a();
            RenderHelper.func_74519_b();
            itemRenderer.func_181564_a(entityitem.func_92059_d(), ItemCameraTransforms.TransformType.FIXED);
            RenderHelper.func_74518_a();
            GlStateManager.func_179099_b();
            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
        }
    }
}

